/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv.cargabase;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.util.Util;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import unipaf.helper.CargaBaseImagem;

public class CargaBaseImagemWeb
implements CargaBaseImagem {
    StorageService storageService;

    public CargaBaseImagemWeb(StorageService storageService) {
        this.storageService = storageService;
    }

    public void carregarBytesImagem(String[] valoresColunas, ResultSet resultSet, String tabela, boolean exibirImagemProduto) throws SQLException, UnicoMensagemUsuarioException {
        if (!this.tabelas().contains(tabela)) {
            return;
        }
        if (tabela.equalsIgnoreCase("produto") && !exibirImagemProduto) {
            return;
        }
        if (tabela.equalsIgnoreCase("produtoimagem") && !LicencaManager.getInstance().isGourmetSelfCheckout()) {
            return;
        }
        for (CargaBaseImagem.ImagemCarga imagemCarga : (List)this.getColunas().get(tabela)) {
            int iColunaCaminho = resultSet.findColumn(imagemCarga.getCampoCaminhoImagem());
            int iColunaBytesDestino = resultSet.findColumn(imagemCarga.getCampoImagem());
            String caminho = valoresColunas[iColunaCaminho];
            if (Util.stringNullOrEmpty((String)caminho)) {
                return;
            }
            File arquivo = this.storageService.downloadFile(ContextoHolder.getTenant(), this.getTipo(tabela), caminho, false, true);
            if (arquivo == null) {
                return;
            }
            byte[] bytes = Util.file2ByteArray((File)arquivo);
            if (bytes == null) {
                return;
            }
            valoresColunas[iColunaBytesDestino] = "\\x" + Util.getHexString((byte[])bytes);
        }
    }

    private TipoArquivoArmazenado getTipo(String tabela) {
        switch (tabela) {
            case "produto": {
                return TipoArquivoArmazenado.Produto;
            }
            case "tabelaprecopainelimg": {
                return TipoArquivoArmazenado.TABELA_PRECO;
            }
            case "configuracaopaineldepreco": {
                return TipoArquivoArmazenado.LOGO_TABELA_PRECO;
            }
            case "grupogourmetselfcheckout": {
                return TipoArquivoArmazenado.GruposGourmetSelfCheckout;
            }
            case "combinacao": {
                return TipoArquivoArmazenado.Combinacao;
            }
        }
        return null;
    }
}

