/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento.CriaFaltaCaixa;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento.CriaSobraCaixa;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento.SangriaSuprimentoAbstract;
import java.math.BigDecimal;

public class CriaSangriaFechamento
extends SangriaSuprimentoAbstract {
    public CriaSangriaFechamento() {
        super(TipoOperacao.SANGRIA);
        this.setHistorico("FECHAMENTO CAIXA");
        this.setFechamento(true);
    }

    public Long lancar(Sessao sessao, BigDecimal valor) throws UnicoMensagemUsuarioException {
        this.lancarSobraOuFaltaCaixa(sessao, valor);
        return super.lancar(sessao, valor);
    }

    private void lancarSobraOuFaltaCaixa(Sessao sessao, BigDecimal valorLancamento) throws UnicoMensagemUsuarioException {
        BigDecimal valorFalta;
        BigDecimal saldoAtual = this.getSaldo(sessao);
        if (valorLancamento.compareTo(saldoAtual) > 0) {
            BigDecimal valorSobra = valorLancamento.subtract(saldoAtual);
            if (valorSobra.compareTo(BigDecimal.ZERO) != 0) {
                this.setValorSobra(valorSobra);
                CriaSobraCaixa lancaSobra = new CriaSobraCaixa();
                lancaSobra.setMotivo(this.getMotivo());
                this.setIdSobraFalta(lancaSobra.lancar(sessao, valorSobra));
            }
        } else if (valorLancamento.compareTo(saldoAtual) < 0 && (valorFalta = valorLancamento.subtract(saldoAtual)).compareTo(BigDecimal.ZERO) < 0) {
            CriaFaltaCaixa lancaFalta = new CriaFaltaCaixa();
            lancaFalta.setMotivo(this.getMotivo());
            this.setIdSobraFalta(lancaFalta.lancar(sessao, valorFalta.abs()));
        }
    }
}

