/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pendenciasnfce;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusNfce;
import br.intelidata.commons.domain.pojo.notafiscal.PendenciaNfe;
import br.intelidata.commons.domain.pojo.pafecf.CancelamentoOperacao;
import br.intelidata.commons.domain.pojo.pafecf.InutilizacaoNfce;
import br.intelidata.commons.modulo.notafiscal.regranegocio.PendenciaNfeRN;
import br.intelidata.commons.modulo.pdv.regranegocio.CancelamentoOperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.InutilizacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.commons.modulo.pdv.relatorio.PendenciaNfceRelatorio;
import br.intelidata.commons.modulo.pdv.relatorio.PendenciaNfceRelatorioExcecoes;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciasnfce.PendenciasNfceSimpleController;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciasnfce.PendenciasWrapper;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.servidor.nfce.AutorizacaoPendenciaNfce;

@RestController
@RequestMapping(value={"/api/pendencias-nfce"})
@SubMenuMapping(MENU="SubMenuPdvFiscal", NOME="Pend\u00eancias NFC-e", ROTA="/pdvs/pendencias-nfce", PROGRAMA=1451, ICONE="icon icon-trabalharcom")
public class PendenciasNfceSimpleController
extends SimpleController {
    protected ResponseEntityService responseService;
    public NotificationService notificationService;

    public PendenciasNfceSimpleController(ResponseEntityService responseService, NotificationService notificationService) {
        this.responseService = responseService;
        this.notificationService = notificationService;
    }

    @RequestMapping(value={"/buscar-quantidade-pendencias"})
    @DBAutoCommit
    public PendenciasWrapper buscarQuantidadePendencias() {
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "problemas-autorizacao");
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "pendencia-inutilizacao");
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "contigencia-nfce");
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "cancelamentos");
        PendenciasWrapper pendencias = new PendenciasWrapper();
        pendencias.setContigencia(PendenciaNfeRN.getInstance().buscarQtdContigenciaWeb(SessaoUtil.getSessao().getCodigoFilial()));
        pendencias.setProblemaAutorizacao(PendenciaNfeRN.getInstance().buscarQtdProblemasWeb(SessaoUtil.getSessao().getCodigoFilial()));
        pendencias.setInutilizacao(PendenciaNfeRN.getInstance().buscarQtdInutilizacaoWeb(SessaoUtil.getSessao().getCodigoFilial()));
        pendencias.setCancelamento(PendenciaNfeRN.getInstance().buscarQtdCancelamentoWeb(SessaoUtil.getSessao().getCodigoFilial()));
        return pendencias;
    }

    @RequestMapping(value={"/transmitir"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> transmitir(@RequestBody Transmicao transmicao) throws UnicoMensagemUsuarioException {
        PendenciaNfe pendencia = null;
        Operacao operacao = null;
        InutilizacaoNfce inutilizacao = null;
        ArrayList relato = new ArrayList();
        for (Long id : transmicao.getIdOperacoes()) {
            switch (transmicao.getTipoPendencia()) {
                case 0: {
                    AutorizacaoPendenciaNfce.getInstance().autorizarContigencia(id);
                    pendencia = PendenciaNfeRN.getInstance().getPendenciaNfce(id);
                    operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(id);
                    break;
                }
                case 1: {
                    AutorizacaoPendenciaNfce.getInstance().consultarProblemaAutorizacao(id);
                    pendencia = PendenciaNfeRN.getInstance().getPendenciaNfce(id);
                    operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(id);
                    break;
                }
                case 2: {
                    AutorizacaoPendenciaNfce.getInstance().inutilizarNumeracao(id);
                    pendencia = PendenciaNfeRN.getInstance().getPendenciaInutilizacaoNfce(id);
                    inutilizacao = (InutilizacaoNfce)InutilizacaoNfceRN.getInstance().buscarPorId(id);
                    break;
                }
                case 3: {
                    AutorizacaoPendenciaNfce.getInstance().autorizarCancelamentoPendente(id);
                    pendencia = PendenciaNfeRN.getInstance().getPendenciaCancelamentoNfce(id);
                    CancelamentoOperacao cancelamento = (CancelamentoOperacao)CancelamentoOperacaoRN.getInstance().buscarPorId(id);
                    if (cancelamento == null) break;
                    operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(cancelamento.getIdOperacao());
                    break;
                }
            }
            this.registrarAutorizacao(pendencia, operacao, inutilizacao, relato);
        }
        return RelatorioUtil.visualizar((Remessa)new PendenciaNfceRelatorio(relato).getRelatorio(), (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.ARQUIVO_TEXTO_FORMATADO, (String)"Situa\u00e7\u00e3o NFC-e");
    }

    @RequestMapping(value={"/rejeiceos"})
    @DBAutoCommit
    public List<PendenciaNfe> buscarListaRejeicao(@RequestParam Long id) {
        return PendenciaNfeRN.getInstance().buscarListaRejeicoes(id);
    }

    @RequestMapping(value={"/imprimir-exececoes"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirExecoes() throws UnicoMensagemUsuarioException {
        Remessa remessa = new PendenciaNfceRelatorioExcecoes().getRelatorio(SessaoUtil.getSessao());
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.ARQUIVO_TEXTO_FORMATADO, (String)"Exe\u00e7\u00f5es");
    }

    @RequestMapping(value={"/buscar-operacao"})
    @DBAutoCommit
    public Long buscarIdOperacaoSubstituida(@RequestParam Long idObjeto) {
        Operacao nfce = (Operacao)OperacaoNfceRN.getInstance().buscarPorId(idObjeto);
        if (!Util.longNullOuZero((Long)nfce.getIdNfceSubstituta())) {
            return nfce.getIdNfceSubstituta();
        }
        return nfce.getId();
    }

    private void registrarAutorizacao(PendenciaNfe pendencia, Operacao operacao, InutilizacaoNfce inutilizacao, List<String> relato) throws UnicoMensagemUsuarioException {
        if (pendencia != null) {
            if (!Util.stringNullOrEmpty((String)pendencia.getMensagemExcecao())) {
                throw new UnicoMensagemUsuarioException(pendencia.getCodigoErro(), pendencia.getMensagemExcecao());
            }
            if (!Util.stringNullOrEmpty((String)pendencia.getExcecao())) {
                throw new UnicoMensagemUsuarioException("WPDV751", "Ocorreu um erro interno no servidor");
            }
        } else {
            String ln;
            if (operacao != null) {
                ln = operacao.getSerieNfce() + "/" + operacao.getNumeroNfce() + "   " + Util.formataDataHora((Temporal)operacao.getData(), (String)"dd/MM/yyyy") + " " + operacao.getStatusNfce().getDescricao();
                relato.add(ln);
            }
            if (inutilizacao != null) {
                ln = inutilizacao.getSerie() + "/" + inutilizacao.getNumero() + "   " + Util.formataDataHora((Temporal)inutilizacao.getData(), (String)"dd/MM/yyyy") + " " + StatusNfce.NUMERACAO_INUTILIZADA.getDescricao();
                relato.add(ln);
            }
        }
    }
}

