/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.perfil;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.CarregaMenuWeb;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.MenuSistemaManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.web.PermissaoWeb;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.PerfilFilial;
import br.intelidata.commons.domain.pojo.Permissao;
import br.intelidata.commons.domain.pojo.PermissaoAcao;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.dashboard.PermissaoDashBoard;
import br.intelidata.commons.domain.pojo.enuns.TipoPermissao;
import br.intelidata.commons.domain.pojo.enuns.TipoPermissaoAcao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PermissaoDashBoardCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PerfilFilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PerfilRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PermissaoAcaoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PermissaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.core.dashboard.base.interfaces.Widget;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.MenuService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.MenuManager;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.perfil.PerfilWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.perfil.PerfilWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.perfil.PermissaoDashBoardWrapper;
import br.intelidata.uniplusweb.web.rest.menus.ItemMenuWeb;
import br.intelidata.uniplusweb.web.rest.menus.MenuObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/perfis"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarUsuario", NOME="Perfis de usu\u00e1rio", ROTA="/cadastros/perfis", PROGRAMA=20)
public class PerfilCrudController
extends CrudController<PerfilWeb, PerfilRN> {
    private final MenuService menuService;
    private final UnipluswebProperties unipluswebProperties;
    private final Map<String, Widget> widgets;

    @Autowired
    public PerfilCrudController(MenuService menuService, UnipluswebProperties unipluswebProperties, Map<String, Widget> widgets) {
        super((AbstractRegraNegocio)PerfilRN.getInstance(), PerfilWeb::new);
        this.menuService = menuService;
        this.unipluswebProperties = unipluswebProperties;
        this.widgets = widgets;
    }

    @RequestMapping(value={"/edicao-perfil"})
    @DBAutoCommit
    public PerfilWrapper montarMenusEdicaoPerfil(@RequestParam(required=false) Long idPerfil) {
        List menusExcluidos = CarregaMenuWeb.getProgramasExcluidos((Usuario)SessaoUtil.getSessao().getUsuario(), (boolean)this.unipluswebProperties.getAmbiente().isLocal());
        Map permissoes = MenuSistemaManager.getInstance().getMenuWeb(SessaoUtil.getSessao(), idPerfil, menusExcluidos);
        permissoes.forEach((programa, permissao) -> {
            permissao.setAcoes(PermissaoAcaoRN.getInstance().buscarListaPermissaoAcaoPorIdPerfilIdPrograma(Contexto.getInstance().getSessao(), idPerfil, programa.intValue()));
            permissao.getAcoes().forEach(acao -> acao.setSelecionado(NumberUtil.longNullOuZero((Long)idPerfil) || acao.getPermissao() == TipoPermissaoAcao.ACESSO_LIBERADO));
        });
        ArrayList idsFiliais = !NumberUtil.longNullOuZero((Long)idPerfil) ? PerfilFilialRN.getInstance().buscarListaPorIdPerfil(idPerfil).stream().map(PerfilFilial::getIdFilial).collect(Collectors.toList()) : new ArrayList(0);
        PerfilWrapper perfilWrapper = new PerfilWrapper(idsFiliais, this.editMountMenu(this.menuService.menu, permissoes, null, new MenuManager()));
        this.carregarPermissoesDashBoards(perfilWrapper, idPerfil);
        return perfilWrapper;
    }

    @DBTransaction
    public Long create(@RequestBody PerfilWeb perfilWeb, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Long id = this.gravarPerfil(perfilWeb);
        this.gravarAuditoriaRegistro(null, (AbstractPojo)perfilWeb, 0);
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        this.cacheService.clear();
        return id;
    }

    @DBTransaction
    public Long update(@RequestBody PerfilWeb perfilWeb, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.gravarAuditoriaRegistro(perfilWeb.getId(), (AbstractPojo)perfilWeb, 1);
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        this.cacheService.clear();
        return this.gravarPerfil(perfilWeb);
    }

    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        this.gravarAuditoriaRegistro(id, null, 2);
        PerfilRN.getInstance().excluir(PerfilRN.getInstance().buscarPorId(id), SessaoUtil.getSessao());
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        this.cacheService.clear();
    }

    protected GridBuilder<PerfilRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        return new GridBuilder(PerfilRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "perfis";
    }

    private List<ItemMenuWeb> editMountMenu(List<MenuObject> itens, Map<Integer, PermissaoWeb> permissoes, MenuObject menuPai, MenuManager menuManager) {
        ArrayList<ItemMenuWeb> menus = new ArrayList<ItemMenuWeb>();
        for (MenuObject single : itens) {
            int programa;
            boolean gravarMenu = true;
            if (single.getMenuMapping() != null) {
                programa = single.getMenuMapping().PROGRAMA();
                gravarMenu = single.getMenuMapping().GRAVAR_MENU();
            } else {
                programa = single.getSubMenuMapping().PROGRAMA();
            }
            PermissaoWeb permissao = permissoes.get(programa);
            if (permissao == null) continue;
            List filhos = null;
            if (!ListMapUtil.listNullOrEmpty((List)single.getFilhos())) {
                filhos = this.editMountMenu(single.getFilhos(), permissoes, single, menuManager);
            }
            menus.add(new ItemMenuWeb(single.getNome(), single.getTitulo(), permissao.getTipoPermissao(), programa, permissao.getAcoes(), filhos, gravarMenu, single.getPeso()));
        }
        if (menuPai != null && menuPai.getSubMenuMapping() != null && menuPai.getSubMenuMapping().SUBMENU_RELATORIO()) {
            menuManager.montarMenusRelatoriosConfigurados(menuPai, menus, permissoes, true);
        }
        menus.sort(Comparator.comparingInt(ItemMenuWeb::getPeso));
        return menus;
    }

    private Long gravarPerfil(PerfilWeb perfil) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (StringUtil.stringNullOrEmpty((String)perfil.getNome())) {
            throw new UnicoMensagemUsuarioException("WCAD1", "Descri\u00e7\u00e3o do perfil est\u00e1 em branco");
        }
        if ((perfil.isDomingo() || perfil.isSegunda() || perfil.isTerca() || perfil.isQuarta() || perfil.isQuinta() || perfil.isSexta() || perfil.isSabado()) && StringUtil.stringNullOrEmpty((String)sessao.getFilial().getTimeZoneId())) {
            throw new UnicoMensagemUsuarioException("WWW468", "Configure o Timezone na filial para utilizar 'Hor\u00e1rios de acesso'.");
        }
        Long idPerfil = perfil.getId();
        if (NumberUtil.longNullOuZero((Long)idPerfil)) {
            idPerfil = ((PerfilRN)this.rn).incluir((AbstractPojo)perfil, sessao);
        } else {
            this.validarCurrentTimeMillis((AbstractPojo)perfil);
            ((PerfilRN)this.rn).alterar((AbstractPojo)perfil, sessao);
        }
        if (!ListMapUtil.listNullOrEmpty((List)perfil.getIdsFilial())) {
            PerfilFilialRN.getInstance().excluirByPerfil(sessao, idPerfil);
            for (Long id : perfil.getIdsFilial()) {
                PerfilFilialRN.getInstance().incluir((AbstractPojo)new PerfilFilial(id, idPerfil), sessao);
            }
        }
        this.gravarMenus(idPerfil, perfil.getMenus(), sessao);
        for (PermissaoDashBoardWrapper permissao : perfil.getPermissoesDashBoard()) {
            PermissaoDashBoard permissaoDashBoard = PermissaoDashBoardCommonRN.getInstance().buscarPorCodigoDashBoardPerfilWeb(idPerfil, permissao.getCodigo());
            if (permissaoDashBoard != null) {
                permissaoDashBoard.setPermissao(permissao.isPermiteAcesso() ? TipoPermissao.ACESSO_LIBERADO : TipoPermissao.ACESSO_NEGADO);
                PermissaoDashBoardCommonRN.getInstance().alterar((AbstractPojo)permissaoDashBoard, sessao);
                continue;
            }
            permissaoDashBoard = new PermissaoDashBoard();
            permissaoDashBoard.setIdperfil(idPerfil);
            permissaoDashBoard.setCodigoDashBoard(permissao.getCodigo());
            permissaoDashBoard.setPermissao(permissao.isPermiteAcesso() ? TipoPermissao.ACESSO_LIBERADO : TipoPermissao.ACESSO_NEGADO);
            PermissaoDashBoardCommonRN.getInstance().incluir((AbstractPojo)permissaoDashBoard, sessao);
        }
        return idPerfil;
    }

    private void gravarMenus(Long idPerfil, List<ItemMenuWeb> menus, Sessao sessao) throws UnicoMensagemUsuarioException {
        for (ItemMenuWeb item : menus) {
            TipoPermissao permissaoPai = TipoPermissao.ACESSO_NEGADO;
            if (!ListMapUtil.listNullOrEmpty((List)item.getFilhos())) {
                permissaoPai = this.gravarFilhos(idPerfil, item.getFilhos(), sessao);
            }
            if (!item.isGravarMenu()) continue;
            Permissao permissao = PermissaoRN.getInstance().buscarPorIdPerfilPrograma(idPerfil, Integer.valueOf(item.getPrograma()));
            if (permissao == null) {
                permissao = new Permissao();
                permissao.setIdperfil(idPerfil);
                permissao.setPermissao(permissaoPai);
                permissao.setPrograma(Integer.valueOf(item.getPrograma()));
                PermissaoRN.getInstance().incluir((AbstractPojo)permissao, sessao);
                continue;
            }
            permissao.setPermissao(permissaoPai);
            PermissaoRN.getInstance().alterar((AbstractPojo)permissao, sessao);
        }
    }

    private TipoPermissao gravarFilhos(Long idPerfil, List<ItemMenuWeb> menus, Sessao sessao) throws UnicoMensagemUsuarioException {
        TipoPermissao permissaoPai = TipoPermissao.ACESSO_NEGADO;
        for (ItemMenuWeb item : menus) {
            TipoPermissao tipoPermissao;
            if (!ListMapUtil.listNullOrEmpty((List)item.getFilhos())) {
                TipoPermissao permissaoFilhos = this.gravarFilhos(idPerfil, item.getFilhos(), sessao);
                if (!TipoPermissao.ACESSO_NEGADO.equals((Object)permissaoFilhos)) {
                    permissaoPai = permissaoFilhos;
                }
                tipoPermissao = permissaoFilhos;
            } else {
                if (item.getPermissao() != TipoPermissao.ACESSO_NEGADO) {
                    if (permissaoPai == TipoPermissao.ACESSO_NEGADO) {
                        permissaoPai = item.getPermissao();
                    } else if (permissaoPai == TipoPermissao.APENAS_VISUALIZAR && item.getPermissao() == TipoPermissao.ACESSO_LIBERADO) {
                        permissaoPai = TipoPermissao.ACESSO_LIBERADO;
                    }
                }
                tipoPermissao = item.getPermissao();
                if (!ListMapUtil.listNullOrEmpty((List)item.getAcoes())) {
                    for (PermissaoAcao acao : item.getAcoes()) {
                        PermissaoAcao permissaoAcao = PermissaoAcaoRN.getInstance().buscarPorIdPerfilIdProgramaIdAcao(idPerfil, item.getPrograma(), acao.getIdAcao());
                        if (permissaoAcao == null) {
                            permissaoAcao = acao;
                            permissaoAcao.setIdPerfil(idPerfil);
                            this.carregarPermissaoAcao(permissaoAcao, item.getPermissao(), acao.getPermissao());
                            PermissaoAcaoRN.getInstance().incluir((AbstractPojo)permissaoAcao, sessao);
                            continue;
                        }
                        this.carregarPermissaoAcao(permissaoAcao, item.getPermissao(), acao.getPermissao());
                        PermissaoAcaoRN.getInstance().alterar((AbstractPojo)permissaoAcao, sessao);
                    }
                }
            }
            if (!item.isGravarMenu()) continue;
            Permissao permissao = PermissaoRN.getInstance().buscarPorIdPerfilPrograma(idPerfil, Integer.valueOf(item.getPrograma()));
            if (permissao == null) {
                permissao = new Permissao();
                permissao.setIdperfil(idPerfil);
                permissao.setPermissao(tipoPermissao);
                permissao.setPrograma(Integer.valueOf(item.getPrograma()));
                PermissaoRN.getInstance().incluir((AbstractPojo)permissao, sessao);
                continue;
            }
            permissao.setPermissao(tipoPermissao);
            PermissaoRN.getInstance().alterar((AbstractPojo)permissao, sessao);
        }
        return permissaoPai;
    }

    private void carregarPermissaoAcao(PermissaoAcao permissaoAcao, TipoPermissao permissaoItem, TipoPermissaoAcao acaoDefault) {
        if (permissaoItem.equals((Object)TipoPermissao.APENAS_VISUALIZAR)) {
            if (permissaoAcao.getIdAcao().equalsIgnoreCase("visualizar")) {
                permissaoAcao.setPermissao(TipoPermissaoAcao.ACESSO_LIBERADO);
            } else {
                permissaoAcao.setPermissao(TipoPermissaoAcao.ACESSO_NEGADO);
            }
        } else if (permissaoItem.equals((Object)TipoPermissao.ACESSO_NEGADO)) {
            permissaoAcao.setPermissao(TipoPermissaoAcao.ACESSO_NEGADO);
        } else {
            permissaoAcao.setPermissao(acaoDefault);
        }
    }

    private void carregarPermissoesDashBoards(PerfilWrapper perfilWrapper, Long idPerfil) {
        HashMap permissoes = new HashMap();
        if (!NumberUtil.longNullOuZero((Long)idPerfil)) {
            PermissaoDashBoardCommonRN.getInstance().buscarPorPerfilWeb(idPerfil).forEach(permissao -> permissoes.putIfAbsent(permissao.getCodigoDashBoard(), permissao.getPermissao().equals((Object)TipoPermissao.ACESSO_LIBERADO)));
        }
        this.widgets.entrySet().stream().filter(entry -> ((Widget)entry.getValue()).isLicenciado()).forEach(entry -> {
            List widgetsPermitidos = perfilWrapper.getPermissoesDashBoard().getOrDefault(((Widget)entry.getValue()).getCategoria(), new ArrayList());
            widgetsPermitidos.add(new PermissaoDashBoardWrapper((String)entry.getKey(), permissoes.getOrDefault(entry.getKey(), false).booleanValue()));
            perfilWrapper.getPermissoesDashBoard().putIfAbsent(((Widget)entry.getValue()).getCategoria(), widgetsPermitidos);
        });
    }
}

