/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.preco.precificacaorapida;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPreco;
import br.intelidata.commons.domain.pojo.ModeloEtiqueta;
import br.intelidata.commons.domain.pojo.PercentuaisComposicaoPrecoProduto;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.ModoCalculoIPI;
import br.intelidata.commons.domain.pojo.enuns.ModoCalculoPreco;
import br.intelidata.commons.domain.pojo.enuns.TipoEnquadramentoFilial;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.regranegocio.ProdutoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.etiqueta.EtiquetaProduto;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaModel;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaProduto;
import br.intelidata.commons.modulo.etiqueta.regranegocio.ModeloEtiquetaCampoRN;
import br.intelidata.commons.modulo.etiqueta.regranegocio.ModeloEtiquetaRN;
import br.intelidata.commons.modulo.etiqueta.relatorio.EtiquetaJasperRelatorio;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoRN;
import br.intelidata.commons.modulo.preco.regranegocio.PrecificacaoRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.CacheInterfaceService;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.crud.preco.precificacaorapida.PrecificacaoRapidaRequest;
import br.intelidata.uniplusweb.web.rest.app.crud.preco.precificacaorapida.PrecificacaoRapidaWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/precificacao-rapida"})
public class PrecificacaoRapidaSimpleController
extends SimpleController {
    private final FuncionalidadeService funcionalidadeService;
    private final ResponseEntityService responseEntityService;
    private final CacheInterfaceService cacheInterfaceService;
    private final NotificationService notificationService;

    public PrecificacaoRapidaSimpleController(FuncionalidadeService funcionalidadeService, ResponseEntityService responseEntityService, CacheInterfaceService cacheInterfaceService, NotificationService notificationService) {
        this.funcionalidadeService = funcionalidadeService;
        this.responseEntityService = responseEntityService;
        this.cacheInterfaceService = cacheInterfaceService;
        this.notificationService = notificationService;
    }

    @RequestMapping(value={"/buscar-dados/{idProduto}"})
    @DBAutoCommit
    public PrecificacaoRapidaWrapper getFormacaoProduto(@PathVariable Long idProduto) {
        Sessao sessao = SessaoUtil.getSessao();
        FormacaoPreco formacaoPreco = this.getFormacao(sessao, sessao.getFilial().getId(), idProduto);
        PercentuaisComposicaoPrecoProduto percentuaisComposicaoPreco = PrecificacaoRN.getInstance().localizarPercentuaisComposicaoPreco(formacaoPreco.getProduto().getId(), sessao.getFilial());
        return new PrecificacaoRapidaWrapper(formacaoPreco, percentuaisComposicaoPreco, PrecificacaoRN.getInstance().calcularPrecoMinimo(formacaoPreco, percentuaisComposicaoPreco, formacaoPreco.getModoCalculoPreco()), PrecificacaoRN.getInstance().calcularPrecoMaximo(formacaoPreco, percentuaisComposicaoPreco, formacaoPreco.getModoCalculoPreco()));
    }

    private FormacaoPreco getFormacao(Sessao sessao, Long idFilial, Long idProduto) {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(idFilial);
        FormacaoPreco formacaoPreco = this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL) ? FormacaoPrecoRN.getInstance().getFormacaoPrecoPorFilialProduto(filial, filial.getId(), idProduto) : FormacaoPrecoRN.getInstance().getFormacaoPrecoPorProduto(sessao, idProduto);
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 668)) {
            if (NumberUtil.bigDecimalNullOrZero((BigDecimal)formacaoPreco.getPercentualIcmsSaida())) {
                formacaoPreco.setPercentualIcmsSaida(formacaoPreco.getProduto().getAliquotaIcmsInterna());
            }
            if (filial.getTipoEnquadramento() != TipoEnquadramentoFilial.SIMPLESNACIONAL && PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 170)) {
                formacaoPreco.setPercentualPisCofinsSaida(formacaoPreco.getProduto().getAliquotaPis().add(formacaoPreco.getProduto().getAliquotaCofins()));
            }
            if (ModoCalculoIPI.ALIQUOTA.equals((Object)formacaoPreco.getProduto().getModoCalculoIPI())) {
                formacaoPreco.setPercentualDespesasVariaveisVenda(formacaoPreco.getProduto().getIpi());
            } else if (ModoCalculoIPI.UNIDADE.equals((Object)formacaoPreco.getProduto().getModoCalculoIPI())) {
                formacaoPreco.setValorIpiSaida(formacaoPreco.getProduto().getIpi());
                formacaoPreco.setPercentualDespesasVariaveisVenda(BigDecimal.ZERO);
            }
        }
        ModoCalculoPreco modoCalculo = (ModoCalculoPreco)EnumUtils.getPorId(ModoCalculoPreco.class, (Object)PropriedadeRN.getInstance().getPropriedadeInt(filial, 203));
        formacaoPreco.setModoCalculoPreco(modoCalculo);
        FormacaoPrecoRN.getInstance().calcularLucroMarkupAjustado(formacaoPreco, formacaoPreco.getPrecoVendaAjustado());
        return formacaoPreco;
    }

    @PostMapping(value={"/precificar"})
    @DBTransaction
    public ResponseEntity<byte[]> precificar(@RequestBody PrecificacaoRapidaRequest precificacaoRapida) throws UnicoMensagemUsuarioException {
        FormacaoPreco formacaoPreco;
        Sessao sessao = SessaoUtil.getSessao();
        HashMap<Long, Produto> produtos = new HashMap<Long, Produto>();
        List ids = new ArrayList();
        for (Long idFilial : precificacaoRapida.getIdsFiliais()) {
            Filial filial = (Filial)FilialRN.getInstance().buscarPorId(idFilial);
            if (ListMapUtil.listNullOrEmpty((List)precificacaoRapida.getIdsProdutos()) && precificacaoRapida.getParams() == null) {
                this.precificar(sessao, idFilial, precificacaoRapida.getFormacaoPreco(), precificacaoRapida.isLiberarProgramacao());
                continue;
            }
            ModoCalculoPreco modoCalculo = (ModoCalculoPreco)EnumUtils.getPorId(ModoCalculoPreco.class, (Object)PropriedadeRN.getInstance().getPropriedadeInt(filial, 203));
            ids = precificacaoRapida.getParams() != null ? this.cacheInterfaceService.getListaIDs("produtos", precificacaoRapida.getParams().getQuery(), precificacaoRapida.getParams().getFilter()) : precificacaoRapida.getIdsProdutos();
            for (Long idProduto : ids) {
                BigDecimal valorGerado;
                formacaoPreco = this.getFormacao(sessao, idFilial, idProduto);
                if (precificacaoRapida.isImprimirEtiqueta()) {
                    produtos.put(idProduto, formacaoPreco.getProduto());
                }
                formacaoPreco.setModoCalculoPreco(modoCalculo);
                if (ModoCalculoPreco.MARGEM_CONTRIBUICAO.equals((Object)modoCalculo)) {
                    formacaoPreco.setPercentualLucroAjustado(precificacaoRapida.getPercentualAjustado());
                    valorGerado = FormacaoPrecoRN.getInstance().calcularValorPorPercentualInformado(formacaoPreco, precificacaoRapida.getPercentualAjustado());
                } else {
                    formacaoPreco.setPercentualMarkupAjustado(precificacaoRapida.getPercentualAjustado());
                    valorGerado = FormacaoPrecoRN.getInstance().calcularMarkupPorPercentualAjustado(formacaoPreco, precificacaoRapida.getPercentualAjustado());
                }
                formacaoPreco.setPrecoVendaAjustado(valorGerado);
                this.precificar(sessao, idFilial, formacaoPreco, precificacaoRapida.isLiberarProgramacao());
                formacaoPreco.getProduto().setPreco(formacaoPreco.getPrecoVendaAjustado());
            }
        }
        String msgNotificacao = "";
        if (precificacaoRapida.isLiberarProgramacao() || PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 590)) {
            msgNotificacao = ids.size() > 1 ? "Os pre\u00e7os foram atualizados." : "O pre\u00e7o foi atualizado.";
        } else if (ProdutoCommonRN.getInstance().isProgramarPreco(DataHoraFactory.getData(), sessao)) {
            String string = msgNotificacao = ids.size() > 1 ? "Os pre\u00e7os foram programados." : "O pre\u00e7o foi programado.";
        }
        if (!StringUtil.stringNullOrEmpty((String)msgNotificacao)) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.SUCCESS, msgNotificacao);
        }
        ResponseEntity responseEntity = null;
        if (precificacaoRapida.isImprimirEtiqueta()) {
            ModeloEtiqueta modeloEtiqueta = ModeloEtiquetaRN.getInstance().buscarPorId(precificacaoRapida.getIdModelo(), true);
            ModeloEtiquetaProduto model = new ModeloEtiquetaProduto();
            String campoPreco = model.getCampoPreco(ModeloEtiquetaCampoRN.getInstance().buscaCampos(precificacaoRapida.getIdModelo(), model.getCamposConfigPreco()));
            model.setModeloEtiqueta(modeloEtiqueta);
            ArrayList<EtiquetaProduto> etiquetas = new ArrayList<EtiquetaProduto>();
            if (!ListMapUtil.listNullOrEmpty((List)precificacaoRapida.getIdsProdutos())) {
                precificacaoRapida.getIdsProdutos().forEach(id -> {
                    Produto produto = (Produto)produtos.get(id);
                    EtiquetaProduto etiqueta = new EtiquetaProduto(produto, new BigDecimal(precificacaoRapida.getQtdEtiqueta()));
                    model.carregaPrecoProduto(produto, etiqueta, campoPreco, null, Long.valueOf(0L), produto.getPreco());
                    etiquetas.add(etiqueta);
                });
            } else {
                formacaoPreco = precificacaoRapida.getFormacaoPreco();
                EtiquetaProduto etiqueta = new EtiquetaProduto(formacaoPreco.getProduto(), new BigDecimal(precificacaoRapida.getQtdEtiqueta()));
                model.carregaPrecoProduto(formacaoPreco.getProduto(), etiqueta, campoPreco, null, Long.valueOf(0L), formacaoPreco.getPrecoVendaAjustado());
                etiquetas.add(etiqueta);
            }
            model.setEtiquetas(etiquetas);
            HashMap<String, Long> parametros = new HashMap<String, Long>();
            parametros.put("pautaPreco", 0L);
            model.getModeloEtiqueta().setGerarEmPdf(true);
            Remessa remessa = new EtiquetaJasperRelatorio().getRelatorio(sessao, (ModeloEtiquetaModel)model, parametros, 1, 1);
            responseEntity = this.responseEntityService.createPDFResponse(remessa.getMalote().extrai("pdf"));
        }
        PropriedadeRN.getInstance().setPropriedade(sessao, 664, Boolean.valueOf(precificacaoRapida.isImprimirEtiqueta()));
        return responseEntity;
    }

    private void precificar(Sessao sessao, Long idFilial, FormacaoPreco formacaoPreco, boolean liberarProgramacao) throws UnicoMensagemUsuarioException {
        formacaoPreco.setPrecoAlterado(true);
        boolean programarPreco = ProdutoCommonRN.getInstance().isProgramarPreco(DataHoraFactory.getData(), sessao);
        if (programarPreco) {
            formacaoPreco.setDataProgramada(DataHoraFactory.getData());
        }
        ProdutoRN.getInstance().aplicarAlteracaoPreco(sessao, idFilial, formacaoPreco, DataHoraFactory.getData(), true, programarPreco, this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL));
        if (liberarProgramacao) {
            ProgramacaoAlteracaoPrecoRN.getInstance().liberarPrecoProdutoData(sessao, formacaoPreco.getProduto(), DataHoraFactory.getData());
        }
    }
}

