/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.Coalesce;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ConfiguracaoEcommerce;
import br.intelidata.commons.domain.pojo.enuns.IAT;
import br.intelidata.commons.domain.pojo.enuns.IPPT;
import br.intelidata.commons.domain.pojo.enuns.StatusSaldoEstoqueProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoEcommerceCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.fiscal.regranegocio.ClassificacaoTributariaIbsCbsRN;
import br.intelidata.commons.modulo.produto.IbsCbsCustomizavel;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCmvAtual;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCusto;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCustoAquisicao;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCustoMedio;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCustoMedioInicial;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelDataUltimaCompra;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelEan;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelEnviaEcommerce;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelICMSEntradaComporPrecoAntigo;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsCodigo;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsCst;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsNome;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIsImagemEcommerce;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIsPossuiFichaTecnica;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelNomeEmpresa;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPercentualLucro;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPercentualMarkup;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPreco;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPrecoUltimaCompra;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelProdutoEcommerce;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPromocaoVigente;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TratarPesquisaRapida;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.ProdutoPesquisaRapida;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.filtrosgrid.FiltroGridEmpresa;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.filtrosgrid.FiltroGridGrupoProduto;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.filtrosgrid.FiltroGridLimiteEstoque;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.util.MultiValueMap;

public abstract class AbstractProdutoCrudController<E extends AbstractPojo, R extends AbstractRegraNegocio>
extends CrudController<E, R> {
    protected final FuncionalidadeService funcionalidadeService;

    public AbstractProdutoCrudController(R rn, Supplier<E> entitySupplier, FuncionalidadeService funcionalidadeService) {
        super(rn, entitySupplier, true, true, TipoArquivoArmazenado.Produto);
        this.funcionalidadeService = funcionalidadeService;
    }

    protected GridBuilder<ProdutoRN> getGridBuilder() {
        ColunaSQL colunaPrecoUltimaCompra;
        USelect subQuery;
        USelect subQuery2;
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 80, true));
        colunas.add(new ColunaSQL("referencia", "Refer\u00eancia", 120, true));
        colunas.add(new ColunaSQL("ean", "C\u00f3digo de barras", 150, true));
        colunas.add(new ColunaSQL("nome", "Nome", 250, true));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.ESTOQUE_PRODUTO_FILIAL)) {
            subQuery2 = new USelect("complementoprodutoFilial", "cp");
            subQuery2.add(new ColunaSQL("quantidademinima", "quantidademinimagrid"));
            subQuery2.add((ColunaSQL)new Referencia("idproduto", "prod"));
            subQuery2.add((ColunaSQL)new Referencia("idfilial", "filial"));
            subQuery2.add(new Condicao("prod", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
            subQuery2.add(new Condicao("filial", Operador.IGUAL, sessao.getFilial().getCodigo()));
            ColunaSQL coluna = new ColunaSQL(subQuery2, "quantidademinimagrid", 50, false);
            coluna.setNome("quantidademinima");
            coluna.setAlias("quantidademinimagrid");
            coluna.setVisivel(false);
            coluna.setTamanho(50);
            coluna.setDescricao("quantidademinimagrid");
            colunas.add(coluna);
            USelect subQuery22 = new USelect("complementoprodutoFilial", "cp");
            subQuery22.add(new ColunaSQL("quantidademaxima", "quantidademaximagrid"));
            subQuery22.add((ColunaSQL)new Referencia("idproduto", "prod"));
            subQuery22.add((ColunaSQL)new Referencia("idfilial", "filial"));
            subQuery22.add(new Condicao("prod", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
            subQuery22.add(new Condicao("filial", Operador.IGUAL, sessao.getFilial().getCodigo()));
            ColunaSQL coluna2 = new ColunaSQL(subQuery22, "quantidademaximagrid", 50, false);
            coluna2.setNome("quantidademaxima");
            coluna2.setAlias("quantidademaximagrid");
            coluna2.setVisivel(false);
            coluna2.setTamanho(50);
            coluna2.setDescricao("quantidademaximagrid");
            colunas.add(coluna2);
        } else {
            colunas.add(new ColunaSQL("quantidademinima", "quantidademinima", 200, false));
            colunas.add(new ColunaSQL("quantidademaxima", "quantidademaxima", 200, false));
        }
        colunas.add(new ColunaSQL("codigo", "unidadeMedida", "UN", 40, true, new String[]{"fk_produto_unidademedida"}));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            subQuery2 = new USelect("formacaoprecoproduto", "pf");
            subQuery2.add(new ColunaSQL("preco", "preco"));
            subQuery2.add((ColunaSQL)new Referencia("idproduto", "prod"));
            subQuery2.add((ColunaSQL)new Referencia("idfilial", "filial"));
            subQuery2.add(new Condicao("prod", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
            subQuery2.add(new Condicao("filial", Operador.IGUAL, sessao.getFilial().getId()));
            ColunaSQL colunaPreco = new ColunaSQL(new Coalesce(subQuery2, "precoproduto"), "preco", new String[0]);
            colunaPreco.setVisivel(true);
            colunaPreco.setTamanho(100);
            colunaPreco.setDescricao("Pre\u00e7o unit.");
            colunas.add(colunaPreco);
        } else {
            colunas.add(new ColunaSQL("preco", "Pre\u00e7o unit.", 100, true));
        }
        ColunaSQL colunaSaldo = new ColunaSQL("saldo", "Estoque", 80, true);
        colunaSaldo.setAlias("saldo");
        colunaSaldo.setFuncao(Funcao.SALDOESTOQUE_POR_PRODUTO_FILIAL);
        colunaSaldo.setParametrosFuncao(new Object[]{"t1.id", sessao.getIdFilial()});
        colunaSaldo.setVisivel(true);
        colunaSaldo.setClasseValor(((Coluna)ProdutoRN.getInstance().getColunaGridCustomozavelProdutoWW(sessao).get(0)).getClasseDado());
        colunas.add(colunaSaldo);
        ColunaSQL colunaStatusSaldo = new ColunaSQL("statusSaldo", "Status Saldo Estoque", 0, false);
        colunaStatusSaldo.setVirtual(true);
        colunaStatusSaldo.setClasseValor(String.class);
        colunas.add(colunaStatusSaldo);
        ColunaSQL colunaStatusSaldoFilial = new ColunaSQL("statusSaldoFilial", "Status Saldo Estoque", 0, false);
        colunaStatusSaldoFilial.setVirtual(true);
        colunaStatusSaldoFilial.setClasseValor(String.class);
        colunas.add(colunaStatusSaldoFilial);
        ColunaSQL colunaStatusSaldoGeral = new ColunaSQL("statusSaldoGeral", "Status Saldo Estoque", 0, false);
        colunaStatusSaldoGeral.setVirtual(true);
        colunaStatusSaldoGeral.setClasseValor(String.class);
        colunas.add(colunaStatusSaldoGeral);
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            subQuery = new USelect("formacaoprecoproduto", "ct");
            subQuery.add(new ColunaSQL("precocusto", "precocusto"));
            subQuery.add((ColunaSQL)new Referencia("idproduto", "prod"));
            subQuery.add((ColunaSQL)new Referencia("idfilial", "filial"));
            subQuery.add(new Condicao("prod", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
            subQuery.add(new Condicao("filial", Operador.IGUAL, sessao.getFilial().getId()));
            ColunaSQL colunaPrecoCusto = new ColunaSQL(new Coalesce(subQuery, "precocustoproduto"), "precoCusto", new String[0]);
            colunaPrecoCusto.setVisivel(true);
            colunaPrecoCusto.setTamanho(100);
            colunaPrecoCusto.setDescricao("Custo");
            colunas.add(colunaPrecoCusto);
        } else {
            colunas.add(new ColunaSQL("precoCusto", "Custo", 100, true));
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            subQuery = new USelect("formacaoprecoproduto", "pt");
            subQuery.add(new ColunaSQL("precoultimacompra", "precoultimacompra"));
            subQuery.add((ColunaSQL)new Referencia("idproduto", "prod"));
            subQuery.add((ColunaSQL)new Referencia("idfilial", "filial"));
            subQuery.add(new Condicao("prod", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
            subQuery.add(new Condicao("filial", Operador.IGUAL, sessao.getFilial().getId()));
            colunaPrecoUltimaCompra = new ColunaSQL(new Coalesce(subQuery, "precoultimacompraproduto"), "precoUltimaCompra", new String[0]);
            colunaPrecoUltimaCompra.setVisivel(true);
            colunaPrecoUltimaCompra.setTamanho(170);
            colunaPrecoUltimaCompra.setDescricao("Pre\u00e7o de \u00faltima compra");
            colunas.add(colunaPrecoUltimaCompra);
        } else {
            colunas.add(new ColunaSQL("precoUltimaCompra", "Pre\u00e7o de \u00faltima compra", 170, true));
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            subQuery = new USelect("formacaoprecoproduto", "pt");
            subQuery.add(new ColunaSQL("dataultimacompra", "dataultimacompra"));
            subQuery.add((ColunaSQL)new Referencia("idproduto", "prod"));
            subQuery.add((ColunaSQL)new Referencia("idfilial", "filial"));
            subQuery.add(new Condicao("prod", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
            subQuery.add(new Condicao("filial", Operador.IGUAL, sessao.getFilial().getId()));
            ColunaSQL colunaDataUltimaCompra = new ColunaSQL(new Coalesce(subQuery, "dataultimacompra"), "dataultimacompra", new String[0]);
            colunaDataUltimaCompra.setVisivel(true);
            colunaDataUltimaCompra.setTamanho(170);
            colunaDataUltimaCompra.setDescricao("Data da \u00faltima compra");
            colunas.add(colunaDataUltimaCompra);
        } else {
            colunas.add(new ColunaSQL("dataultimacompra", "Data da \u00faltima compra", 170, true));
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            subQuery = new USelect("formacaoprecoproduto", "cm");
            subQuery.add(new ColunaSQL("customedio", "customedio"));
            subQuery.add((ColunaSQL)new Referencia("idproduto", "prod"));
            subQuery.add((ColunaSQL)new Referencia("idfilial", "filial"));
            subQuery.add(new Condicao("prod", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
            subQuery.add(new Condicao("filial", Operador.IGUAL, sessao.getFilial().getId()));
            colunaPrecoUltimaCompra = new ColunaSQL(new Coalesce(subQuery, "customedioproduto"), "custoMedio", new String[0]);
            colunaPrecoUltimaCompra.setVisivel(true);
            colunaPrecoUltimaCompra.setTamanho(100);
            colunaPrecoUltimaCompra.setDescricao("Custo m\u00e9dio");
            colunas.add(colunaPrecoUltimaCompra);
        } else {
            colunas.add(new ColunaSQL("custoMedio", "Custo m\u00e9dio", 100, true));
        }
        colunas.add(new ColunaSQL("casasDecimais", "Casas decimais", 0, false));
        colunas.add(new ColunaSQL("casasDecimaisPrecoCusto", "Casas decimais custo", 0, false));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimaisunidade", null, 0, false, new String[]{"fk_produto_unidademedida"}));
        colunas.add(new ColunaSQL("pesavel", "Pes\u00e1vel", 80, true));
        colunas.add(new ColunaSQL("tributacao", "Tributa\u00e7\u00e3o", 100, true));
        colunas.add(new ColunaSQL("ncm", "NCM", 80, true));
        colunas.add(new ColunaSQL("iat", "IAT", 40, true, IAT.class));
        colunas.add(new ColunaSQL("ippt", "IPPT", 60, true, IPPT.class));
        colunas.add(new ColunaSQL("kit", "Kit", 60, true));
        colunas.add(new ColunaSQL("possuiVariacao", "Possui grade", 110, true));
        colunas.add(new ColunaSQL("possuiLote", "Possui lote", 110, true));
        colunas.add(new ColunaSQL("numeroSerie", "N\u00ba S\u00e9rie", 110, true));
        GridBuilder grid = new GridBuilder(ProdutoRN.getInstance().getTabela(), colunas, "cad_".concat(this.rn.getTabela()));
        grid.addReferenciaDefault(new Referencia("tipo", "tipo"));
        grid.addCodicaoDefault(new Condicao("tipo", Operador.IGUAL, TipoRegistroProduto.PRODUTO.getId()));
        grid.addReferenciaDefault(new Referencia("nome"));
        grid.addOrdemDefault(new Ordem("nome"));
        grid.addReferenciaDefault(new Referencia("preco", "precoproduto"));
        grid.addReferenciaDefault(new Referencia("precocusto", "precocustoproduto"));
        grid.addReferenciaDefault(new Referencia("precoultimacompra", "precoultimacompraproduto"));
        grid.addReferenciaDefault(new Referencia("customedio", "customedioproduto"));
        grid.addReferenciaDefault(new Referencia("produtoNovo"));
        grid.addReferencia(new Referencia("inativo", "produtoInativo"));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRODUTO_EMPRESA)) {
            Long[] idEmpresa = FilialRN.getInstance().buscaEmpresaPerfilUsuario(SessaoUtil.getSessao());
            USelect produtoEmpresa = new USelect("produtoempresa");
            produtoEmpresa.add(new ColunaSQL("idproduto"));
            produtoEmpresa.add((ColunaSQL)new Referencia("idempresa", "idempresa"));
            produtoEmpresa.add(new Condicao("idempresa", Operador.CONTIDO_EM, idEmpresa));
            grid.addCodicaoDefault(new Condicao("id", Operador.CONTIDO_EM, produtoEmpresa));
        }
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCusto(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCustoAquisicao(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPreco(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelDataUltimaCompra(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPrecoUltimaCompra(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCustoMedio(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCustoMedioInicial(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPercentualLucro(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPercentualMarkup(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelICMSEntradaComporPrecoAntigo(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelEan(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPromocaoVigente(sessao));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCusto(sessao));
        if (ModuloManager.getInstance().isAtivo(Modulo.PRODUCAO)) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIsPossuiFichaTecnica(sessao));
        }
        if (ModuloManager.getInstance().isAtivo(Modulo.ECOMMERCE) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.OUTROS_ECOMMERCE)) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIsImagemEcommerce(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelEnviaEcommerce(sessao));
            this.adicionarColunasCustomizaveisProdutoEcommerce(sessao, grid, "datahoraultimaatualizacao");
            this.adicionarColunasCustomizaveisProdutoEcommerce(sessao, grid, "codigoprodutoecommerce");
            this.adicionarColunasCustomizaveisProdutoEcommerce(sessao, grid, "status");
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRODUTO_EMPRESA)) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelNomeEmpresa(sessao));
        }
        if (!FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GESTAO_CUSTO_PRECO)) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCmvAtual(sessao));
        }
        if (ClassificacaoTributariaIbsCbsRN.getInstance().habilitarIbsCbs(sessao.getFilial())) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsNome(sessao, IbsCbsCustomizavel.PRODUTO_SERVICO));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsCodigo(sessao, IbsCbsCustomizavel.PRODUTO_SERVICO));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsCst(sessao, IbsCbsCustomizavel.PRODUTO_SERVICO));
        }
        grid.setTratarPesquisaRapida((TratarPesquisaRapida)new ProdutoPesquisaRapida());
        return grid;
    }

    private void adicionarColunasCustomizaveisProdutoEcommerce(Sessao sessao, GridBuilder<?> grid, String campo) {
        List listaConfiguracaoEcommerce = ConfiguracaoEcommerceCommonRN.getInstance().buscarLista();
        if (Util.listNullOrEmpty((List)listaConfiguracaoEcommerce)) {
            return;
        }
        for (ConfiguracaoEcommerce configuracaoEcommerce : listaConfiguracaoEcommerce) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelProdutoEcommerce(sessao, configuracaoEcommerce, campo));
        }
    }

    protected void prepareGrid() throws UnicoMensagemUsuarioException {
        super.prepareGrid();
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridGrupoProduto());
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridLimiteEstoque());
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridEmpresa());
    }

    public List<Coluna> getColunasCustomizaveis() {
        return ProdutoRN.getInstance().getColunaGridCustomozavelProdutoWW(SessaoUtil.getSessao());
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        int idxQtdMinima = this.getIndexColuna("quantidademinima", colunas);
        int idxQtdMaxima = this.getIndexColuna("quantidademaxima", colunas);
        int idxPromocaoVigente = this.getIndexColuna("promocaoVigente", colunas);
        int idxStatusSaldo = this.getIndexColuna("statusSaldo", colunas);
        int idxStatusSaldoFilial = this.getIndexColuna("statusSaldoFilial", colunas);
        int idxStatusSaldoGeral = this.getIndexColuna("statusSaldoGeral", colunas);
        int idxSaldo = this.getIndexColuna("saldo", colunas);
        int idxSaldoFilial = this.getIndexColuna("saldoFilial", colunas);
        int idxSaldoGeral = this.getIndexColuna("saldoGeral", colunas);
        for (Object[] registro : dados) {
            StatusSaldoEstoqueProduto statusSaldo;
            BigDecimal saldo;
            Object promocaoVigente;
            BigDecimal quantidadeMinima = idxQtdMinima > 0 ? this.getValor(registro[idxQtdMinima]) : null;
            BigDecimal quantidadeMaxima = idxQtdMaxima > 0 ? this.getValor(registro[idxQtdMaxima]) : null;
            Object object = promocaoVigente = idxPromocaoVigente > 0 ? registro[idxPromocaoVigente] : null;
            if (idxSaldo > -1) {
                saldo = this.getValor(registro[idxSaldo]);
                statusSaldo = ProdutoRN.getInstance().getStatusSaldoEstoqueProduto(saldo, quantidadeMinima, quantidadeMaxima, promocaoVigente, null);
                Object object2 = registro[idxStatusSaldo] = statusSaldo != null ? statusSaldo.name() : StatusSaldoEstoqueProduto.ZERO.name();
            }
            if (idxSaldoFilial > -1) {
                saldo = this.getValor(registro[idxSaldoFilial]);
                statusSaldo = ProdutoRN.getInstance().getStatusSaldoEstoqueProduto(saldo, quantidadeMinima, quantidadeMaxima, promocaoVigente, null);
                Object object3 = registro[idxStatusSaldoFilial] = statusSaldo != null ? statusSaldo.name() : StatusSaldoEstoqueProduto.ZERO.name();
            }
            if (idxSaldoGeral <= -1) continue;
            saldo = this.getValor(registro[idxSaldoGeral]);
            statusSaldo = ProdutoRN.getInstance().getStatusSaldoEstoqueProduto(saldo, quantidadeMinima, quantidadeMaxima, promocaoVigente, null);
            registro[idxStatusSaldoGeral] = statusSaldo != null ? statusSaldo.name() : StatusSaldoEstoqueProduto.ZERO.name();
        }
    }

    private BigDecimal getValor(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Integer) {
            return new BigDecimal((Integer)object);
        }
        if (object instanceof Long) {
            return new BigDecimal((Long)object);
        }
        return null;
    }
}

