/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.formacaopreco;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.InativoFilial;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPreco;
import br.intelidata.commons.domain.pojo.FormacaoPrecoProduto;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.PercentuaisComposicaoPrecoProduto;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.SaldoEstoque;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.ModoCalculoPreco;
import br.intelidata.commons.domain.pojo.enuns.OrigemCusto;
import br.intelidata.commons.domain.regranegocio.FamiliaProdutoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.estoque.regranegocio.SaldoEstoqueRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoRN;
import br.intelidata.commons.modulo.preco.regranegocio.PrecificacaoRN;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.FormacaoPrecoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.formacaopreco.ReplicarFormacaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.formacaopreco.SaldoRebaixaWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/formacoes-preco-produto"})
public class FormacaoPrecoProdutoCrudController
extends SimpleController {
    private final FuncionalidadeService funcionalidadeService;
    private final FormacaoPrecoService formacaoPrecoService;

    public FormacaoPrecoProdutoCrudController(FuncionalidadeService funcionalidadeService, FormacaoPrecoService formacaoPrecoService) {
        this.funcionalidadeService = funcionalidadeService;
        this.formacaoPrecoService = formacaoPrecoService;
    }

    @RequestMapping(value={"/precos-produto"})
    @DBAutoCommit
    public List<FormacaoPrecoProduto> buscarPrecosCadastroProduto(@RequestParam Long idProduto) {
        List precosFiliais = null;
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        if (produto != null) {
            precosFiliais = FormacaoPrecoProdutoRN.getInstance().buscarPrecosProduto(produto.getId());
            precosFiliais.removeIf(precoFilial -> InativoFilial.isFilialInativa((Filial)FilialRN.getInstance().buscarQualquerFilialPorId(precoFilial.getIdFilial())));
            Filial filial = SessaoUtil.getSessao().getFilial();
            Optional<FormacaoPrecoProduto> filterFilialContexto = precosFiliais.stream().filter(precoFilial -> filial.getId().equals(precoFilial.getIdFilial())).findFirst();
            if (!filterFilialContexto.isPresent()) {
                FormacaoPrecoProduto formacaoPrecoProduto = new FormacaoPrecoProduto();
                formacaoPrecoProduto.setIdFilial(filial.getId());
                formacaoPrecoProduto.setNomeFilial(filial.getNome());
                formacaoPrecoProduto.setPreco(produto.getPreco());
                precosFiliais.add(formacaoPrecoProduto);
            }
        }
        return precosFiliais;
    }

    @RequestMapping(value={"/formacao"})
    @DBAutoCommit
    public FormacaoPreco buscarFormacaoPreco(@RequestParam Long idProduto, @RequestParam(required=false) Long idFilial) throws UnicoMensagemUsuarioException {
        FamiliaProduto familia;
        Sessao sessao = SessaoUtil.getSessao();
        idFilial = Util.longNullOuZero((Long)idFilial) ? sessao.getIdFilial() : idFilial;
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(idFilial);
        FormacaoPreco formacaoPreco = this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL) ? (!Util.longNullOuZero((Long)idFilial) ? FormacaoPrecoRN.getInstance().getFormacaoPrecoPorFilialProduto(sessao.getFilial(), idFilial, idProduto) : FormacaoPrecoRN.getInstance().getFormacaoPrecoPorFilialProduto(sessao, idProduto)) : FormacaoPrecoRN.getInstance().getFormacaoPrecoPorProduto(sessao, idProduto);
        formacaoPreco.getProduto().setCasasDecimaisUN(Integer.valueOf(UnidademedidaRN.getInstance().getCasasDecimais(formacaoPreco.getProduto().getIdUnidadeMedida())));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            if (formacaoPreco.getProduto().getId() != null) {
                FormacaoPrecoProduto precoProduto = FormacaoPrecoProdutoRN.getInstance().buscarFormacaoPrecoPorProdutoFilial(formacaoPreco.getProduto().getId(), idFilial);
                if (precoProduto != null) {
                    formacaoPreco.setCustoAtualProduto(precoProduto.getPrecoCusto());
                    formacaoPreco.setPrecoVendaAtual(precoProduto.getPreco());
                } else {
                    formacaoPreco.setPrecoVendaAtual(formacaoPreco.getProduto().getPreco());
                }
            }
        } else if (formacaoPreco.getProduto() != null) {
            formacaoPreco.setPrecoVendaAtual(formacaoPreco.getProduto().getPreco());
            if (!Util.longNullOuZero((Long)formacaoPreco.getProduto().getId())) {
                Map precoCusto = ProdutoRN.getInstance().buscarValoresPorID(formacaoPreco.getProduto().getId(), new String[]{"precocusto"});
                formacaoPreco.setCustoAtualProduto((BigDecimal)precoCusto.get("precocusto"));
            }
        }
        formacaoPreco.setModoCalculoPreco(this.getModoCalculoPreco(sessao));
        boolean isManterPrecoCalcularMargem = PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 816);
        if (isManterPrecoCalcularMargem) {
            if (formacaoPreco.getModoCalculoPreco().equals((Object)ModoCalculoPreco.MARGEM_CONTRIBUICAO)) {
                formacaoPreco.setPercentualLucroCalculado(formacaoPreco.getPercentualLucroAjustado());
            } else {
                formacaoPreco.setPercentualLucroCalculado(formacaoPreco.getPercentualMarkupAjustado());
            }
        }
        if (ModoCalculoPreco.MARKUP.equals((Object)formacaoPreco.getModoCalculoPreco()) && !Util.bigDecimalNullOrZero((BigDecimal)formacaoPreco.getPercentualMarkupAjustado())) {
            formacaoPreco.setPercentualMarkupCalculado(formacaoPreco.getPercentualMarkupAjustado());
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.FAMILIA_PRODUTO) && !Util.longNullOuZero((Long)formacaoPreco.getProduto().getIdFamilia()) && (familia = (FamiliaProduto)FamiliaProdutoCommonRN.getInstance().buscarPorId(formacaoPreco.getProduto().getIdFamilia())) != null) {
            formacaoPreco.setFamilia(familia.getNome());
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRECO_MININO_VENDA)) {
            PercentuaisComposicaoPrecoProduto composicaoPrecoProduto = PrecificacaoRN.getInstance().localizarPercentuaisComposicaoPreco(formacaoPreco.getProduto().getId(), filial);
            if (formacaoPreco.getModoCalculoPreco().equals((Object)ModoCalculoPreco.MARGEM_CONTRIBUICAO)) {
                formacaoPreco.setPercentualCalculadoPrecoMinimo(composicaoPrecoProduto.getLucroBrutoMinimo());
                formacaoPreco.setPercentualCalculadoPrecoMaximo(composicaoPrecoProduto.getLucroBrutoMaximo());
            } else {
                formacaoPreco.setPercentualCalculadoPrecoMinimo(composicaoPrecoProduto.getPercentualMarkupMinimo());
                formacaoPreco.setPercentualCalculadoPrecoMaximo(composicaoPrecoProduto.getPercentualMarkupMaximo());
            }
            formacaoPreco.setPrecoMinimoCalculado(PrecificacaoRN.getInstance().calcularPrecoMinimo(formacaoPreco, composicaoPrecoProduto, formacaoPreco.getModoCalculoPreco()));
            formacaoPreco.setPrecoMaximoCalculado(PrecificacaoRN.getInstance().calcularPrecoMaximo(formacaoPreco, composicaoPrecoProduto, formacaoPreco.getModoCalculoPreco()));
            formacaoPreco.setPermiteEditarPrecoMaximoMinimo(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 798));
        }
        formacaoPreco.setManterPrecoVendaRecalcularMargem(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 816));
        FormacaoPrecoRN.getInstance().calcularCustoCompra(formacaoPreco, formacaoPreco.getTipoValorCalculoCusto());
        FormacaoPrecoRN.getInstance().calcularPreco(formacaoPreco);
        if (!isManterPrecoCalcularMargem) {
            FormacaoPrecoRN.getInstance().aplicaPrecoCalculado(formacaoPreco);
        }
        FormacaoPrecoRN.getInstance().calcularLucroMarkupAjustado(formacaoPreco, formacaoPreco.getPrecoVendaAjustado());
        if (EmbalagemRN.getInstance().possuiEmbalagemVenda(idProduto)) {
            formacaoPreco.setEmbalagens(EmbalagemRN.getInstance().buscarEmbalagensVendaPorIdProduto(idProduto));
        }
        if (this.isProgramarPreco()) {
            formacaoPreco.setDataProgramada(DataHoraFactory.getData());
        }
        return formacaoPreco;
    }

    @RequestMapping(value={"/aplicar-preco"})
    @DBTransaction
    public String aplicarPreco(@RequestBody FormacaoPreco formacaoPreco) throws UnicoMensagemUsuarioException {
        String produtoKit;
        boolean isProgramarPreco;
        this.formacaoPrecoService.validarFormacaoPreco(formacaoPreco);
        formacaoPreco.setIdProduto(formacaoPreco.getProduto().getId());
        if (formacaoPreco.isAplicarPrecoCalculado()) {
            FormacaoPrecoRN.getInstance().aplicaPrecoCalculado(formacaoPreco);
        }
        FormacaoPreco formacaoPrecoAtual = this.buscarFormacaoPreco(formacaoPreco.getProduto().getId(), formacaoPreco.getIdFilial());
        boolean isAlterouCusto = FormacaoPrecoRN.getInstance().isCustoAlterado(formacaoPreco, SessaoUtil.getSessao().getFilial());
        if (isAlterouCusto) {
            formacaoPreco.setOrigemCusto(OrigemCusto.USUARIO);
            String usuario = SessaoUtil.getSessao().getUsuario().getCodigo() + " - " + SessaoUtil.getSessao().getUsuario().getNome();
            formacaoPreco.setCustoAlteradoPor(usuario);
        }
        boolean isPrecoAlteradoPautas = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO) ? FormacaoPrecoRN.getInstance().isPrecoAlteradoPorPauta(formacaoPreco.getPautasPreco(), formacaoPrecoAtual.getPautasPreco()) : formacaoPreco.getPrecoVendaAjustadoPauta1().compareTo(formacaoPrecoAtual.getPrecoVendaAjustadoPauta1()) != 0 || formacaoPreco.getPrecoVendaAjustadoPauta2().compareTo(formacaoPrecoAtual.getPrecoVendaAjustadoPauta2()) != 0 || formacaoPreco.getPrecoVendaAjustadoPauta3().compareTo(formacaoPrecoAtual.getPrecoVendaAjustadoPauta3()) != 0 || formacaoPreco.getPrecoVendaAjustadoPauta4().compareTo(formacaoPrecoAtual.getPrecoVendaAjustadoPauta4()) != 0;
        boolean alterouPreco = formacaoPreco.getPrecoVendaAjustado().compareTo(formacaoPrecoAtual.getPrecoVendaAjustado()) != 0;
        boolean alterouCusto = formacaoPreco.getPrecoUltimaCompra().compareTo(formacaoPrecoAtual.getPrecoUltimaCompra()) != 0;
        boolean bl = isProgramarPreco = this.isProgramarPreco() && alterouPreco;
        if (alterouPreco || alterouCusto || isPrecoAlteradoPautas) {
            formacaoPreco.setPrecoAlterado(true);
        }
        formacaoPreco.setPercentualMarkupMargemMinimo(formacaoPreco.getPercentualCalculadoPrecoMinimo());
        formacaoPreco.setPercentualMarkupMargemMaximo(formacaoPreco.getPercentualCalculadoPrecoMaximo());
        formacaoPreco.setPercentualLucroAtual(formacaoPreco.getPercentualLucroAjustado());
        formacaoPreco.setPercentualLucroCalculado(formacaoPreco.getPercentualLucroAjustado());
        if (!ListMapUtil.listNullOrEmpty((List)formacaoPreco.getEmbalagens())) {
            EmbalagemRN.getInstance().gravarEmbalagens(1, formacaoPreco.getEmbalagens(), SessaoUtil.getSessao());
        }
        ProdutoRN.getInstance().aplicarAlteracaoPreco(SessaoUtil.getSessao(), formacaoPreco.getIdFilial(), formacaoPreco, formacaoPreco.getDataProgramada(), true, isProgramarPreco, this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL));
        String mensagem = "";
        if (!PropriedadeRN.getInstance().isProgramacaoReajustePreco(SessaoUtil.getSessao().getFilial()) && !Util.stringNullOrEmpty((String)(produtoKit = KitRN.getInstance().getDescricaoKitsPorIdComponente(formacaoPreco.getIdProduto()))) && (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 243) || PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 244))) {
            ProdutoRN.getInstance().alterarPrecoKitPaiPorProdutoComponente(SessaoUtil.getSessao(), formacaoPreco.getProduto().getId());
            mensagem = "PRC19 - O produto " + formacaoPreco.getProduto().getNome() + " pertence aos kits: <br>" + produtoKit + "<br>Como o pre\u00e7o foi alterado tamb\u00e9m ser\u00e1 alterado o pre\u00e7o dos kits \u00e0 que ele pertence.";
        }
        if (isProgramarPreco && PropriedadeRN.getInstance().isProgramacaoReajustePreco(SessaoUtil.getSessao().getFilial())) {
            mensagem = "PRC20 - O pre\u00e7o foi programado para o produto. ";
        }
        return mensagem;
    }

    @RequestMapping(value={"/aplicar-fornecedor"})
    @DBTransaction
    public String aplicarFornecedor(@RequestBody ReplicarFormacaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.formacaoPrecoService.validarFormacaoPreco(wrapper.getFormacaoPreco());
        if (wrapper.getFormacaoPreco().isAplicarPrecoCalculado()) {
            FormacaoPrecoRN.getInstance().aplicaPrecoCalculado(wrapper.getFormacaoPreco());
        }
        wrapper.getFormacaoPreco().setIdProduto(wrapper.getFormacaoPreco().getProduto().getId());
        Entidade fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(wrapper.getFormacaoPreco().getProduto().getIdFornecedor());
        if (fornecedor != null) {
            FormacaoPreco formacaoPrecoAtual = this.buscarFormacaoPreco(wrapper.getFormacaoPreco().getProduto().getId(), wrapper.getFormacaoPreco().getIdFilial());
            boolean isAlterouCusto = FormacaoPrecoRN.getInstance().isCustoAlterado(wrapper.getFormacaoPreco(), SessaoUtil.getSessao().getFilial());
            if (isAlterouCusto) {
                wrapper.getFormacaoPreco().setOrigemCusto(OrigemCusto.USUARIO);
                String usuario = SessaoUtil.getSessao().getUsuario().getCodigo() + " - " + SessaoUtil.getSessao().getUsuario().getNome();
                wrapper.getFormacaoPreco().setCustoAlteradoPor(usuario);
            }
            boolean isProgramarPreco = this.isProgramarPreco() && wrapper.getFormacaoPreco().getPrecoVendaAjustado().compareTo(formacaoPrecoAtual.getPrecoVendaAjustado()) != 0;
            boolean isProgramarPrecoProdutoBase = isProgramarPreco && wrapper.getFormacaoPreco().getPrecoVendaAjustado().compareTo(formacaoPrecoAtual.getPrecoVendaAjustado()) != 0;
            ProdutoRN.getInstance().atualizarPrecosPorFornecedor(SessaoUtil.getSessao(), wrapper.getFormacaoPreco(), wrapper.getFormacaoPreco().getDataProgramada(), wrapper.isReplicarCusto(), isProgramarPrecoProdutoBase, isProgramarPreco);
            EmbalagemRN.getInstance().gravarEmbalagens(1, wrapper.getFormacaoPreco().getEmbalagens(), SessaoUtil.getSessao());
            return "PRC9 - ".concat(isProgramarPreco ? "O pre\u00e7o dos produtos foram programados." : "Produtos atualizados com sucesso.");
        }
        throw new UnicoMensagemUsuarioException("WWW165", "Fornecedor n\u00e3o encontrado.");
    }

    @RequestMapping(value={"/aplicar-grupo"})
    @DBTransaction
    public String aplicarGrupo(@RequestBody ReplicarFormacaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.formacaoPrecoService.validarFormacaoPreco(wrapper.getFormacaoPreco());
        if (wrapper.getFormacaoPreco().isAplicarPrecoCalculado()) {
            FormacaoPrecoRN.getInstance().aplicaPrecoCalculado(wrapper.getFormacaoPreco());
        }
        wrapper.getFormacaoPreco().setIdProduto(wrapper.getFormacaoPreco().getProduto().getId());
        HierarquiaGrupoProduto grupoProduto = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(wrapper.getFormacaoPreco().getProduto().getIdHierarquia());
        if (grupoProduto != null) {
            FormacaoPreco formacaoPrecoAtual = this.buscarFormacaoPreco(wrapper.getFormacaoPreco().getProduto().getId(), wrapper.getFormacaoPreco().getIdFilial());
            boolean isAlterouCusto = FormacaoPrecoRN.getInstance().isCustoAlterado(wrapper.getFormacaoPreco(), SessaoUtil.getSessao().getFilial());
            if (isAlterouCusto) {
                wrapper.getFormacaoPreco().setOrigemCusto(OrigemCusto.USUARIO);
                String usuario = SessaoUtil.getSessao().getUsuario().getCodigo() + " - " + SessaoUtil.getSessao().getUsuario().getNome();
                wrapper.getFormacaoPreco().setCustoAlteradoPor(usuario);
            }
            boolean isProgramarPreco = this.isProgramarPreco() && wrapper.getFormacaoPreco().getPrecoVendaAjustado().compareTo(formacaoPrecoAtual.getPrecoVendaAjustado()) != 0;
            boolean isProgramarPrecoProdutoBase = isProgramarPreco && wrapper.getFormacaoPreco().getPrecoVendaAjustado().compareTo(formacaoPrecoAtual.getPrecoVendaAjustado()) != 0;
            ProdutoRN.getInstance().atualizarPrecosPorHierarquia(SessaoUtil.getSessao(), wrapper.getFormacaoPreco(), wrapper.getFormacaoPreco().getDataProgramada(), wrapper.isReplicarCusto(), isProgramarPrecoProdutoBase, isProgramarPreco);
            EmbalagemRN.getInstance().gravarEmbalagens(1, wrapper.getFormacaoPreco().getEmbalagens(), SessaoUtil.getSessao());
            return "PRC13 - ".concat(isProgramarPreco ? "O pre\u00e7o dos produtos foram programados." : "Produtos atualizados com sucesso.");
        }
        throw new UnicoMensagemUsuarioException("WWW166", "Grupo n\u00e3o encontrado.");
    }

    @RequestMapping(value={"/aplicar-familia"})
    @DBTransaction
    public String aplicarFamilia(@RequestBody ReplicarFormacaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        FamiliaProduto familia;
        this.formacaoPrecoService.validarFormacaoPreco(wrapper.getFormacaoPreco());
        if (wrapper.getFormacaoPreco().isAplicarPrecoCalculado()) {
            FormacaoPrecoRN.getInstance().aplicaPrecoCalculado(wrapper.getFormacaoPreco());
        }
        if ((familia = (FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(wrapper.getFormacaoPreco().getProduto().getIdFamilia())) != null) {
            wrapper.getFormacaoPreco().setIdProduto(wrapper.getFormacaoPreco().getProduto().getId());
            FormacaoPreco formacaoPrecoAtual = this.buscarFormacaoPreco(wrapper.getFormacaoPreco().getProduto().getId(), wrapper.getFormacaoPreco().getIdFilial());
            boolean isPrecoAlteradoPauta = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO) ? FormacaoPrecoRN.getInstance().isPrecoAlteradoPorPauta(formacaoPrecoAtual.getProduto(), wrapper.getFormacaoPreco().getIdFilial(), wrapper.getFormacaoPreco().getPautasPreco()) : wrapper.getFormacaoPreco().getPrecoVendaAjustadoPauta1().compareTo(formacaoPrecoAtual.getProduto().getPrecoPauta1()) != 0 || wrapper.getFormacaoPreco().getPrecoVendaAjustadoPauta2().compareTo(formacaoPrecoAtual.getProduto().getPrecoPauta2()) != 0 || wrapper.getFormacaoPreco().getPrecoVendaAjustadoPauta3().compareTo(formacaoPrecoAtual.getProduto().getPrecoPauta3()) != 0 || wrapper.getFormacaoPreco().getPrecoVendaAjustadoPauta4().compareTo(formacaoPrecoAtual.getProduto().getPrecoPauta4()) != 0;
            boolean precoAlterado = wrapper.getFormacaoPreco().getPrecoVendaAjustado().compareTo(formacaoPrecoAtual.getPrecoVendaAjustado()) != 0 || isPrecoAlteradoPauta;
            boolean isProgramarPreco = this.isProgramarPreco() && precoAlterado;
            ProdutoRN.getInstance().atualizaPrecosPorFamilia(SessaoUtil.getSessao(), wrapper.getFormacaoPreco(), wrapper.getFormacaoPreco().getDataProgramada(), wrapper.isReplicarCusto(), isProgramarPreco, this.funcionalidadeService.isAtiva(Funcionalidade.PROGRAMAR_PRECO) && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 348));
            EmbalagemRN.getInstance().gravarEmbalagens(1, wrapper.getFormacaoPreco().getEmbalagens(), SessaoUtil.getSessao());
            return "PRC45 - ".concat(isProgramarPreco ? "O pre\u00e7o dos produtos foram programados." : "Produtos atualizados com sucesso.");
        }
        throw new UnicoMensagemUsuarioException("WWW167", "Familia n\u00e3o encontrada");
    }

    @RequestMapping(value={"/saldo-produto-rebaixa"})
    @DBAutoCommit
    public SaldoRebaixaWrapper getSaldoRebaixa(@RequestParam Long idFilial, @RequestParam Long idProduto) {
        SaldoEstoque saldoEstoque = SaldoEstoqueRN.getInstance().buscarSaldoEstoque(idFilial, idProduto, 0);
        BigDecimal saldo = saldoEstoque != null ? saldoEstoque.getQuantidade() : BigDecimal.ZERO;
        int decimais = UnidademedidaRN.getInstance().getCasasDecimais((Long)ProdutoRN.getInstance().buscarValoresPorID(idProduto, new String[]{"idunidademedida"}).get("idunidademedida"));
        return new SaldoRebaixaWrapper(saldo, decimais);
    }

    @RequestMapping(value={"/desconto-preco-unitario"}, method={RequestMethod.POST})
    @DBAutoCommit
    public BigDecimal calcularDescontoSobrePrecoUnitario(@RequestBody FormacaoPreco formacaoPreco, @RequestParam BigDecimal valor) {
        return FormacaoPrecoRN.getInstance().calcularDescontoSobrePrecoUnitario(formacaoPreco, valor);
    }

    @RequestMapping(value={"/lucro-markup"}, method={RequestMethod.POST})
    @DBAutoCommit
    public FormacaoPreco calcularLucroMarkupAjustado(@RequestBody FormacaoPreco formacaoPreco, @RequestParam BigDecimal valor) {
        FormacaoPrecoRN.getInstance().calcularLucroMarkupAjustado(formacaoPreco, valor);
        return formacaoPreco;
    }

    @RequestMapping(value={"/calcular-preco"}, method={RequestMethod.POST})
    @DBAutoCommit
    public BigDecimal recalculaPrecoEmbalagem(@RequestBody FormacaoPreco formacaoPreco, @RequestParam BigDecimal lucro, @RequestParam BigDecimal fator) {
        lucro = lucro.setScale(2, 6);
        fator = fator.setScale(2, 6);
        formacaoPreco.setPercentualLucroAjustado(lucro);
        BigDecimal valorGerado = PrecificacaoRN.getInstance().calcularPrecoPeloPercentualDefinido(formacaoPreco, lucro);
        return valorGerado.multiply(fator).setScale(formacaoPreco.getCasasDecimaisPreco(), RoundingMode.HALF_EVEN);
    }

    private boolean isProgramarPreco() {
        return this.funcionalidadeService.isAtiva(Funcionalidade.PROGRAMAR_PRECO) && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 348);
    }

    private ModoCalculoPreco getModoCalculoPreco(Sessao sessao) throws UnicoMensagemUsuarioException {
        String modoCalculoPreco = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 203);
        if (!ModoCalculoPreco.MARKUP.getId().toString().equals(modoCalculoPreco) && !ModoCalculoPreco.MARGEM_CONTRIBUICAO.getId().toString().equals(modoCalculoPreco)) {
            PropriedadeRN.getInstance().setPropriedade(sessao, 203, ModoCalculoPreco.MARGEM_CONTRIBUICAO.getId().toString());
        }
        return (ModoCalculoPreco)EnumUtils.getPorId(ModoCalculoPreco.class, (Object)PropriedadeRN.getInstance().getPropriedadeInt(sessao.getFilial(), 203));
    }
}

