/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.ipiestado;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.ProdutoIPIPorEstado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.EnquadramentoIPIRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoIPIPorEstadoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ipi-estados"})
public class ProdutoIpiEstadoCrudController
extends CrudController<ProdutoIPIPorEstado, ProdutoIPIPorEstadoRN> {
    public ProdutoIpiEstadoCrudController() {
        super((AbstractRegraNegocio)ProdutoIPIPorEstadoRN.getInstance(), ProdutoIPIPorEstado::new);
        this.dependsOn("idProduto");
    }

    protected void beforeSave(ProdutoIPIPorEstado produtoIPIPorEstado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarAoGravar(produtoIPIPorEstado);
    }

    public GridBuilder<ProdutoIPIPorEstadoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idProduto", "idProduto", 0, false));
        colunas.add(new ColunaSQL("idEstado", "idEstado", 0, false));
        colunas.add(new ColunaSQL("idIncentivoFiscal", "idIncentivoFiscal", 0, false));
        colunas.add(new ColunaSQL("idEstadoOrigem", "idEstadoOrigem", 0, false));
        colunas.add(new ColunaSQL("idIncentivoFiscalOrigem", "idIncentivoFiscalOrigem", 0, false));
        colunas.add(new ColunaSQL("idEnquadramentoIPI", "idEnquadramentoIPI", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoEstadoOrigem", "UF origem", 30, true, new String[]{"fk_produtoipi_estado_origem"}));
        colunas.add(new ColunaSQL("nome", "nomeIncentivoFiscalOrigem", "Incentivo origem", 30, true, new String[]{"fk_prodipi_incentfiscal_origem"}));
        colunas.add(new ColunaSQL("codigo", "codigoEstado", "UF destino", 30, true, new String[]{"fk_produtoipi_estado"}));
        colunas.add(new ColunaSQL("nome", "nomeIncentivoFiscal", "Incentivo destino", 30, true, new String[]{"fk_produtoipi_incentivofiscal"}));
        colunas.add(new ColunaSQL("cstIpi", "CST IPI", 200, true));
        colunas.add(new ColunaSQL("descricao", "enquadramentoIPI", "Enquadramento IPI", 30, true, new String[]{"fk_produto_enqipi"}));
        colunas.add(new ColunaSQL("modoCalculo", "Modo de c\u00e1lculo", 30, true));
        colunas.add(new ColunaSQL("percentualIpi", "% IPI", 10, true));
        return new GridBuilder(ProdutoIPIPorEstadoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "ipi-estados";
    }

    private void validarAoGravar(ProdutoIPIPorEstado produtoIpiPorEstado) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)produtoIpiPorEstado.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WWW41", "Produto n\u00e3o informado.");
        }
        if (NumberUtil.longNullOuZero((Long)produtoIpiPorEstado.getIdEstadoOrigem()) && NumberUtil.longNullOuZero((Long)produtoIpiPorEstado.getIdIncentivoFiscalOrigem())) {
            throw new UnicoMensagemUsuarioException("WPRD165", "Por favor, informe o estado ou a Zona Franca/ALC de origem! ");
        }
        if (NumberUtil.longNullOuZero((Long)produtoIpiPorEstado.getIdEstado()) && NumberUtil.longNullOuZero((Long)produtoIpiPorEstado.getIdIncentivoFiscal())) {
            throw new UnicoMensagemUsuarioException("WPRD166", "Por favor, informe o estado ou a Zona Franca/ALC de destino! ");
        }
        if (produtoIpiPorEstado.getCstIpi() == null) {
            throw new UnicoMensagemUsuarioException("WPRD167", "Por favor, informe o Cst do IPI! ");
        }
        if (produtoIpiPorEstado.getModoCalculo() == null) {
            throw new UnicoMensagemUsuarioException("WPRD168", "Por favor, informe o modo de c\u00e1lculo do IPI! ");
        }
        if (NumberUtil.longNullOuZero((Long)produtoIpiPorEstado.getIdEnquadramentoIPI())) {
            throw new UnicoMensagemUsuarioException("WPRD221", "Por favor, informe o enquadramento do IPI!");
        }
        EnquadramentoIPIRN.getInstance().validarEnquadramentoCSTIPI(produtoIpiPorEstado.getCstIpi(), produtoIpiPorEstado.getIdEnquadramentoIPI());
        List produtosIpi = ProdutoIPIPorEstadoRN.getInstance().buscarPorProduto(produtoIpiPorEstado.getIdProduto());
        for (ProdutoIPIPorEstado ipi : produtosIpi) {
            if (produtoIpiPorEstado.equals((Object)ipi)) continue;
            boolean estadoIgual = !NumberUtil.longNullOuZero((Long)ipi.getIdEstado()) && ipi.getIdEstado().equals(produtoIpiPorEstado.getIdEstado());
            boolean incentivoFiscalIgual = !NumberUtil.longNullOuZero((Long)ipi.getIdIncentivoFiscal()) && ipi.getIdIncentivoFiscal().equals(produtoIpiPorEstado.getIdIncentivoFiscal());
            boolean estadoOrigemIgual = !NumberUtil.longNullOuZero((Long)ipi.getIdEstadoOrigem()) && ipi.getIdEstadoOrigem().equals(produtoIpiPorEstado.getIdEstadoOrigem());
            boolean incentivoFiscalOrigemIgual = !NumberUtil.longNullOuZero((Long)ipi.getIdIncentivoFiscalOrigem()) && ipi.getIdIncentivoFiscalOrigem().equals(produtoIpiPorEstado.getIdIncentivoFiscalOrigem());
            boolean tipoCstIgual = ipi.getCstIpi() != null && produtoIpiPorEstado.getCstIpi() != null && ipi.getCstIpi().isSaida() == produtoIpiPorEstado.getCstIpi().isSaida();
            if (!tipoCstIgual || !estadoIgual && !incentivoFiscalIgual || !estadoOrigemIgual && !incentivoFiscalOrigemIgual) continue;
            throw new UnicoMensagemUsuarioException("WWW415", "Estado ou Zona Franca/ALC j\u00e1 configurada para Cst de " + (ipi.getCstIpi().isSaida() ? " sa\u00edda!" : "entrada!"));
        }
    }
}

