/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.produtosimilar;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.ProdutoSimilar;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoSimilarRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/produtos-similares"})
public class ProdutoSimilarCrudController
extends CrudController<ProdutoSimilar, ProdutoSimilarRN> {
    private final FuncionalidadeService funcionalidadeService;

    public ProdutoSimilarCrudController(FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)ProdutoSimilarRN.getInstance(), ProdutoSimilar::new);
        this.funcionalidadeService = funcionalidadeService;
    }

    protected GridBuilder<ProdutoSimilarRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idProduto", "idProduto", 0, false));
        colunas.add(new ColunaSQL("idProdutoFilho", "idProdutoFilho", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigo", "C\u00f3digo", 80, true, new String[]{"fk_produtosimilar_prod_filho"}));
        colunas.add(new ColunaSQL("nome", "nome", "Nome", 150, true, new String[]{"fk_produtosimilar_prod_filho"}));
        colunas.add(new ColunaSQL("unidadeMedida", "unidade", "Unidade", 5, true, new String[]{"fk_produtosimilar_prod_filho"}));
        colunas.add(new ColunaSQL("preco", "preco", "Pre\u00e7o", 50, true, new String[]{"fk_produtosimilar_prod_filho"}));
        colunas.add(new ColunaSQL("ean", "ean", "C\u00f3digo de barras", 80, true, new String[]{"fk_produtosimilar_prod_filho"}));
        colunas.add(new ColunaSQL("observacao", "observacao", "Observa\u00e7\u00e3o", 150, true, new String[]{"fk_produtosimilar_prod_filho"}));
        return new GridBuilder(ProdutoSimilarRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ProdutoSimilar produtoSimilar, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)produtoSimilar.getIdProduto()) || NumberUtil.longNullOuZero((Long)produtoSimilar.getIdProdutoFilho())) {
            throw new UnicoMensagemUsuarioException("WWW46", "Produto n\u00e3o informado.");
        }
        if (produtoSimilar.getIdProduto().equals(produtoSimilar.getIdProdutoFilho())) {
            throw new UnicoMensagemUsuarioException("WPRD163", "N\u00e3o \u00e9 poss\u00edvel relacionar um produto \u00e0 ele mesmo.");
        }
        List produtos = ProdutoSimilarRN.getInstance().buscarListaPorProduto(produtoSimilar.getIdProduto());
        boolean produtoExistente = produtos.stream().anyMatch(p -> p.getIdProdutoFilho().equals(produtoSimilar.getIdProdutoFilho()) && (NumberUtil.longNullOuZero((Long)produtoSimilar.getId()) || !produtoSimilar.getId().equals(p.getId())));
        if (produtoExistente) {
            throw new UnicoMensagemUsuarioException("WPRD164", "Produto j\u00e1 incluso.");
        }
    }

    protected String getCacheId() {
        return "produtos-similares";
    }

    @RequestMapping(value={"/existe-na-base"})
    @DBAutoCommit
    public boolean existeProdutoSimilar() {
        return ((ProdutoSimilarRN)this.rn).existeProdutoSimilar() && this.funcionalidadeService.isAtiva(Funcionalidade.PRODUTO_SIMILAR);
    }

    @RequestMapping(value={"/buscar-lista"})
    @DBAutoCommit
    public List<ProdutoSimilar> buscarLista(@RequestParam Long idProduto) {
        return ((ProdutoSimilarRN)this.rn).buscarListaAtivaPorProduto(SessaoUtil.getSessao(), idProduto);
    }
}

