/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.programacaopreco;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPreco;
import br.intelidata.commons.domain.pojo.IndicadorFilial;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProgramacaoAlteracaoPreco;
import br.intelidata.commons.domain.pojo.ProgramacaoAlteracaoPrecoItem;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.ModoCalculoPreco;
import br.intelidata.commons.domain.pojo.enuns.StatusProgramacaoAlteracaoPreco;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ProgramacaoAlteracaoPrecoCommonRN;
import br.intelidata.commons.domain.regranegocio.ProgramacaoAlteracaoPrecoItemCommonRN;
import br.intelidata.commons.domain.regranegocio.ProgramacaoAlteracaoPrecoItemEmbalagemRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PerfilFilialRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoItemRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoRN;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.programacaopreco.FiltroGridFilial;
import br.intelidata.uniplusweb.web.rest.app.crud.programacaopreco.ProgramacaoPrecoWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/programacao-preco"})
@SubMenuMapping(MENU="SubMenuEstoqueGeral", NOME="Programa\u00e7\u00e3o de altera\u00e7\u00e3o de pre\u00e7o", ROTA="/estoques/programacao-preco", PROGRAMA=312, ICONE="icon-date")
public class ProgramacaoPrecoCrudController
extends CrudController<ProgramacaoAlteracaoPreco, ProgramacaoAlteracaoPrecoRN> {
    @Autowired
    public ProgramacaoPrecoCrudController() {
        super((AbstractRegraNegocio)ProgramacaoAlteracaoPrecoRN.getInstance(), ProgramacaoAlteracaoPreco::new, true, true);
    }

    protected GridBuilder<ProgramacaoAlteracaoPrecoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 80, true));
        colunas.add(new ColunaSQL("dataprogramada", "Data programada", 150, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 120, true));
        colunas.add(new ColunaSQL("nome", "usuarioAlterou", "Alterado por", 200, true, new String[]{"fk_programacaoaltpreco_alt"}));
        colunas.add(new ColunaSQL("nome", "usuarioConferencia", "Conferido por", 200, true, new String[]{"fk_programacaoaltpreco_conf"}));
        colunas.add(new ColunaSQL("nome", "usuarioLiberacao", "Liberado por", 200, true, new String[]{"fk_programacaoaltpreco_lib"}));
        colunas.add(new ColunaSQL("dataprogramada", "dataprogramadafiltro", "Data programada", 0, false, new String[0]));
        colunas.add(new ColunaSQL("status", "statusfiltro", "Status", 0, false, new String[0]));
        colunas.add(new ColunaSQL("idFilial", "ID Filial", 0, false));
        GridBuilder grid = new GridBuilder(ProgramacaoAlteracaoPrecoRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("dataprogramada"));
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            grid.addReferencia(new Referencia("idfilial", "idfilial"));
            Sessao sessao = SessaoUtil.getSessao();
            Filial filial = sessao.getFilial();
            if (filial.getIndicadorFilial() == IndicadorFilial.FILIAL) {
                grid.addCondicao(new Condicao("idfilial", Operador.IGUAL, filial.getId()));
            } else {
                List filiais = PerfilFilialRN.getInstance().buscaListaFilialPorIdPerfil(sessao.getUsuario().getIdPerfil());
                if (!Util.listNullOrEmpty((List)filiais)) {
                    grid.addCondicao(new Condicao("idfilial", Operador.CONTIDO_EM, (AbstractPojo[])filiais.toArray(new Filial[0])));
                }
            }
        }
        return grid;
    }

    protected void prepareGrid() throws UnicoMensagemUsuarioException {
        super.prepareGrid();
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridFilial());
    }

    protected void beforeRead(ProgramacaoAlteracaoPreco programacao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (modo != 0) {
            List listaItens = ProgramacaoAlteracaoPrecoItemRN.getInstance().buscarListaPorIdProgramacao(programacao.getId());
            if (!Util.listNullOrEmpty((List)listaItens)) {
                Sessao sessao = SessaoUtil.getSessao();
                for (ProgramacaoAlteracaoPrecoItem item : listaItens) {
                    if (sessao.getFilial().getId().equals(programacao.getIdFilial())) {
                        item.setFilial(sessao.getFilial().getNome());
                        continue;
                    }
                    Filial filial = (Filial)FilialRN.getInstance().buscarPorId(programacao.getIdFilial());
                    if (filial == null) continue;
                    item.setFilial(filial.getNome());
                }
            }
            programacao.setItens(listaItens);
            programacao.setIdsProgramacoesRelacionadas(ProgramacaoAlteracaoPrecoCommonRN.getInstance().buscarIdsProgramacaoRelacionadas(SessaoUtil.getSessao(), programacao.getId()));
            programacao.setIdsItensProgramacaoRelacionada(ProgramacaoAlteracaoPrecoCommonRN.getInstance().buscarIdsItesProgramacao(programacao.getId()));
        }
    }

    protected void beforeUpdate(ProgramacaoAlteracaoPreco programacao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (programacao.isConferencia()) {
            programacao.setIdUsuarioConferencia(SessaoUtil.getSessao().getUsuario().getId());
            programacao.setDataConferencia(DataHoraFactory.getData());
            programacao.setStatus(StatusProgramacaoAlteracaoPreco.CONFERIDA);
            ProgramacaoAlteracaoPrecoItemRN.getInstance().validaItensConferencia(programacao.getId());
        }
    }

    protected void beforeSave(ProgramacaoAlteracaoPreco programacao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        programacao.setLancamentoManual(true);
        if (ListMapUtil.listNullOrEmpty((List)programacao.getItens())) {
            throw new UnicoMensagemUsuarioException("WPRC26", "N\u00e3o existem itens para esse documento.");
        }
    }

    @RequestMapping(value={"/buscar-status"})
    @DBAutoCommit
    public StatusProgramacaoAlteracaoPreco buscarStatus(@RequestParam Long id) {
        return (StatusProgramacaoAlteracaoPreco)EnumUtils.getPorId(StatusProgramacaoAlteracaoPreco.class, (Object)((ProgramacaoAlteracaoPrecoRN)this.rn).buscarValorPorID(id, "status"));
    }

    @RequestMapping(value={"/validar-excluir-programacao"})
    @DBAutoCommit
    public String validarExcluirProgramacao(@RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        List programacaoAlteracaoPrecos = ProgramacaoAlteracaoPrecoRN.getInstance().buscarListaPorIds(ids);
        StatusProgramacaoAlteracaoPreco status = ((ProgramacaoAlteracaoPreco)programacaoAlteracaoPrecos.get(0)).getStatus();
        this.validaStatusProgramacaoAlteracaoPreco(programacaoAlteracaoPrecos);
        if (status.isPermiteCancelar()) {
            return "Tem certeza que deseja cancelar " + (programacaoAlteracaoPrecos.size() > 1 ? "as programa\u00e7\u00f5es de altera\u00e7\u00e3o de pre\u00e7o selecionadas?" : "a programa\u00e7\u00e3o de altera\u00e7\u00e3o de pre\u00e7o selecionada?");
        }
        return "Tem certeza que deseja excluir " + (programacaoAlteracaoPrecos.size() > 1 ? "as programa\u00e7\u00f5es de altera\u00e7\u00e3o de pre\u00e7o selecionadas?" : "a programa\u00e7\u00e3o de altera\u00e7\u00e3o de pre\u00e7o selecionada?");
    }

    @RequestMapping(value={"/excluir-programacao"})
    @DBTransaction
    public void excluirProgramacao(@RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        List programacaoAlteracaoPrecos = ProgramacaoAlteracaoPrecoRN.getInstance().buscarListaPorIds(ids);
        StatusProgramacaoAlteracaoPreco status = ((ProgramacaoAlteracaoPreco)programacaoAlteracaoPrecos.get(0)).getStatus();
        Sessao sessao = SessaoUtil.getSessao();
        if (status.isPermiteCancelar()) {
            for (ProgramacaoAlteracaoPreco programacao : programacaoAlteracaoPrecos) {
                ProgramacaoAlteracaoPrecoRN.getInstance().cancelar(programacao, sessao);
            }
        } else {
            ProgramacaoAlteracaoPrecoItemCommonRN.getInstance().excluirPorIdsProgramacao(sessao, ids);
            ProgramacaoAlteracaoPrecoRN.getInstance().excluirLista(sessao, programacaoAlteracaoPrecos);
        }
    }

    @PostMapping(value={"/conferir"})
    @DBTransaction
    public void conferir(@RequestBody ProgramacaoPrecoWrapper wrapper) throws UnicoMensagemUsuarioException {
        for (Long idProgramacao : wrapper.getIdsProgramacao()) {
            if (Util.longNullOuZero((Long)idProgramacao)) continue;
            ProgramacaoAlteracaoPreco programacao = (ProgramacaoAlteracaoPreco)ProgramacaoAlteracaoPrecoRN.getInstance().buscarPorId(idProgramacao);
            if (!StatusProgramacaoAlteracaoPreco.AGENDADO.equals((Object)programacao.getStatus())) {
                throw new UnicoMensagemUsuarioException("WPRC77", "A programa\u00e7\u00e3o de altera\u00e7\u00e3o de pre\u00e7o " + programacao.getDescricao() + " n\u00e3o foi conferida pois n\u00e3o est\u00e1 com status 'Agendado'.");
            }
            ProgramacaoAlteracaoPrecoRN.getInstance().mudarStatusParaConferido(SessaoUtil.getSessao(), programacao);
        }
    }

    @PostMapping(value={"/liberar"})
    @DBTransaction
    public void liberar(@RequestBody ProgramacaoPrecoWrapper wrapper) throws UnicoMensagemUsuarioException {
        for (Long idProgramacao : wrapper.getIdsProgramacao()) {
            ProgramacaoAlteracaoPreco programacao = (ProgramacaoAlteracaoPreco)ProgramacaoAlteracaoPrecoRN.getInstance().buscarPorId(idProgramacao);
            if (!StatusProgramacaoAlteracaoPreco.CONFERIDA.equals((Object)programacao.getStatus())) {
                throw new UnicoMensagemUsuarioException("WPRC28", "Somente programa\u00e7\u00e3o conferida pode ser liberada.");
            }
            if (programacao.getDataProgramada().isAfter(DataHoraFactory.getData())) {
                throw new UnicoMensagemUsuarioException("WPRC29", "N\u00e3o \u00e9 poss\u00edvel liberar pre\u00e7os fora da data programada.");
            }
            ProgramacaoAlteracaoPrecoRN.getInstance().liberarPreco(SessaoUtil.getSessao(), programacao);
        }
    }

    @PostMapping(value={"/liberar-sem-conferir"})
    @DBTransaction
    public void liberarSemConferir(@RequestBody ProgramacaoPrecoWrapper wrapper) throws UnicoMensagemUsuarioException {
        List programacoesPreco = wrapper.getIdsProgramacao().stream().map(arg_0 -> ((ProgramacaoAlteracaoPrecoRN)ProgramacaoAlteracaoPrecoRN.getInstance()).buscarPorId(arg_0)).filter(p -> p != null && p.getDataProgramada() != null).collect(Collectors.toList());
        Sessao sessao = SessaoUtil.getSessao();
        programacoesPreco.sort(Comparator.comparing(ProgramacaoAlteracaoPreco::getDataProgramada));
        for (ProgramacaoAlteracaoPreco programacao : programacoesPreco) {
            if (!programacao.getStatus().in(new AbstractEnum[]{StatusProgramacaoAlteracaoPreco.CONFERIDA, StatusProgramacaoAlteracaoPreco.AGENDADO})) {
                throw new UnicoMensagemUsuarioException("WPRC74", "Somente programa\u00e7\u00e3o agendada ou conferida pode ser liberada para a programa\u00e7\u00e3o de pre\u00e7o " + programacao.getDescricao() + ".");
            }
            if (programacao.getDataProgramada().isAfter(DataHoraFactory.getData())) {
                throw new UnicoMensagemUsuarioException("WPRC75", "N\u00e3o \u00e9 poss\u00edvel liberar pre\u00e7os fora da data programada para a programa\u00e7\u00e3o de pre\u00e7o " + programacao.getDescricao() + ".");
            }
            programacao.setIdUsuarioConferencia(sessao.getUsuario().getId());
            ProgramacaoAlteracaoPrecoRN.getInstance().liberarPreco(sessao, programacao);
        }
    }

    private void validaStatusProgramacaoAlteracaoPreco(List<ProgramacaoAlteracaoPreco> programacoesPreco) throws UnicoMensagemUsuarioException {
        StatusProgramacaoAlteracaoPreco primeiroStatus = programacoesPreco.get(0).getStatus();
        for (ProgramacaoAlteracaoPreco programacao : programacoesPreco) {
            if (!programacao.getStatus().isPermiteExcluir() && !programacao.getStatus().isPermiteCancelar()) {
                throw new UnicoMensagemUsuarioException("WPRC82", "\u00c9 permitido cancelar ou excluir apenas programa\u00e7\u00f5es de altera\u00e7\u00e3o de pre\u00e7o com status conferido ou agendado");
            }
            if (primeiroStatus.equals((Object)programacao.getStatus())) continue;
            throw new UnicoMensagemUsuarioException("WPRC81", "Selecione apenas programa\u00e7\u00f5es de altera\u00e7\u00e3o de pre\u00e7o com o mesmo status!");
        }
    }

    @RequestMapping(value={"/formacao-para-programacao-item"})
    @DBAutoCommit
    public ProgramacaoAlteracaoPrecoItem formacaoParaItem(@RequestBody FormacaoPreco formacaoPreco, @RequestParam BigDecimal qtdEtiquetas) {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(formacaoPreco.getIdProduto());
        BigDecimal precoAnterior = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRECO_POR_FILIAL) ? FormacaoPrecoProdutoRN.getInstance().getPrecoProduto(formacaoPreco.getIdFilial(), produto.getId()) : produto.getPreco();
        return ProgramacaoAlteracaoPrecoItemRN.getInstance().getItemProgramacaoAlteracaoPreco(formacaoPreco, precoAnterior, qtdEtiquetas, null);
    }

    @RequestMapping(value={"/programacao-item-para-formacao"})
    @DBAutoCommit
    public FormacaoPreco itemParaFormacao(@RequestBody ProgramacaoAlteracaoPrecoItem item, @RequestParam Long idFilial) {
        Sessao sessao = SessaoUtil.getSessao();
        FormacaoPreco formacaoPreco = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRECO_POR_FILIAL) ? FormacaoPrecoRN.getInstance().getFormacaoPrecoPorFilialProduto(sessao.getFilial(), idFilial, item.getIdProduto()) : FormacaoPrecoRN.getInstance().getFormacaoPrecoPorProduto(sessao, item.getIdProduto());
        FormacaoPrecoRN.getInstance().calcularValoresCustoPorPrecoUltimaCompra(sessao, formacaoPreco, item.getPrecoUltimaCompra(), false, false, false);
        if (item.getModoCalculoPreco() == ModoCalculoPreco.MARKUP) {
            formacaoPreco.setPercentualMarkupCalculado(item.getPercentualMarkup());
            formacaoPreco.setPercentualMarkupAjustado(item.getPercentualMarkupAjustado());
        } else {
            formacaoPreco.setPercentualIcmsSaida(item.getPercentualIcmsSaida());
            formacaoPreco.setPercentualDespesasVariaveisVenda(item.getPercentualIpiSaida());
            formacaoPreco.setPercentualCustoIndireto(item.getPercentualCustoIndireto());
            formacaoPreco.setPercentualOutrosImpostosPreco(item.getPercentualOutrosImpostosPreco());
            formacaoPreco.setPercentualComissao(item.getPercentualComissao());
            formacaoPreco.setPercentualPisCofinsSaida(item.getPercentualPisCofinsSaida());
            formacaoPreco.setPercentualLucroCalculado(item.getPercentualLucro());
            formacaoPreco.setPercentualLucroAjustado(item.getPercentualLucroAjustado());
        }
        formacaoPreco.setPrecoVendaAjustado(item.getPrecoVendaAjustado());
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            formacaoPreco.setPautasPreco(ProgramacaoAlteracaoPrecoItemRN.getInstance().getListaPautasProgramacao(item.getPautasPreco()));
        } else {
            formacaoPreco.setPrecoVendaAjustadoPauta1(item.getPrecoVendaAjustadoPauta1());
            formacaoPreco.setPrecoVendaAjustadoPauta2(item.getPrecoVendaAjustadoPauta2());
            formacaoPreco.setPrecoVendaAjustadoPauta3(item.getPrecoVendaAjustadoPauta3());
            formacaoPreco.setPrecoVendaAjustadoPauta4(item.getPrecoVendaAjustadoPauta4());
            formacaoPreco.setQuantidadePauta1(item.getQuantidadePauta1());
            formacaoPreco.setQuantidadePauta2(item.getQuantidadePauta2());
            formacaoPreco.setQuantidadePauta3(item.getQuantidadePauta3());
            formacaoPreco.setQuantidadePauta4(item.getQuantidadePauta4());
            formacaoPreco.setPercentualAjustadoPauta1(item.getPercentualpauta1());
            formacaoPreco.setPercentualAjustadoPauta2(item.getPercentualpauta2());
            formacaoPreco.setPercentualAjustadoPauta3(item.getPercentualpauta3());
            formacaoPreco.setPercentualAjustadoPauta4(item.getPercentualpauta4());
        }
        formacaoPreco.setPrecoMinimoVenda(item.getPrecoMinimoVenda());
        formacaoPreco.setPercentualPrecoMinimoVenda(item.getPercentualPrecoMinimoVenda());
        formacaoPreco.setEmbalagens(ProgramacaoAlteracaoPrecoItemEmbalagemRN.getInstance().itensParaEmbalagensPorIdProduto(item.getIdProduto(), item.getEmbalagens()));
        FormacaoPrecoRN.getInstance().calcularLucroMarkupAjustado(formacaoPreco, formacaoPreco.getPrecoVendaAjustado());
        return formacaoPreco;
    }

    @RequestMapping(value={"/validar-se-exclui-programacao-item"})
    @DBAutoCommit
    public String validarSeExcluiItemOutrasProgramacoes(@RequestBody ProgramacaoPrecoWrapper wrapper) {
        Filial filial = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRECO_POR_FILIAL) ? (Filial)FilialRN.getInstance().buscarPorId(wrapper.getIdFilial()) : SessaoUtil.getSessao().getFilial();
        List listaItemProgramacaoExistente = ProgramacaoAlteracaoPrecoItemCommonRN.getInstance().buscaProgramacaoPorProdutoNasFiliaisNaData(wrapper.getDataProgramada(), wrapper.getIdProduto(), filial);
        if (!Util.listNullOrEmpty((List)listaItemProgramacaoExistente)) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(wrapper.getIdProduto());
            String infoPogramacoes = listaItemProgramacaoExistente.stream().map(m -> m.getIdProgramacao().toString()).collect(Collectors.joining(","));
            return "O produto " + produto.getCodigo() + " esta presente nas programa\u00e7\u00f5es " + infoPogramacoes + " com a mesma data. Deseja excluir?";
        }
        return null;
    }

    @RequestMapping(value={"/exclui-programacao-item"})
    @DBTransaction
    public void excluiItemOutrasProgramacoes(@RequestBody ProgramacaoPrecoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Filial filial = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRECO_POR_FILIAL) ? (Filial)FilialRN.getInstance().buscarPorId(wrapper.getIdFilial()) : SessaoUtil.getSessao().getFilial();
        List listaItemProgramacaoExistente = ProgramacaoAlteracaoPrecoItemCommonRN.getInstance().buscaProgramacaoPorProdutoNasFiliaisNaData(wrapper.getDataProgramada(), wrapper.getIdProduto(), filial);
        if (!Util.listNullOrEmpty((List)listaItemProgramacaoExistente)) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(wrapper.getIdProduto());
            for (ProgramacaoAlteracaoPrecoItem f : listaItemProgramacaoExistente) {
                ProgramacaoAlteracaoPrecoItemRN.getInstance().excluirPorIdProgramacaoIdItem(SessaoUtil.getSessao(), f.getIdProgramacao(), produto.getId());
            }
        }
    }

    @RequestMapping(value={"/historico-programacao-produto"})
    @DBAutoCommit
    public List<MapResultSet> buscarHistoricoProduto(@RequestBody ProgramacaoPrecoWrapper wrapper) {
        Sessao sessao = SessaoUtil.getSessao();
        Long idFilial = wrapper.getIdFilial();
        if (NumberUtil.longNullOuZero((Long)idFilial)) {
            idFilial = sessao.getFilial().getId();
        }
        return ProgramacaoAlteracaoPrecoItemRN.getInstance().buscarHistoricoPorProduto(sessao, wrapper.getDataProgramadaInicio(), wrapper.getDataProgramadaFim(), wrapper.getIdProduto(), idFilial);
    }

    @RequestMapping(value={"/verificar-mensagem-produto-kit"})
    @DBAutoCommit
    public String verificarMensagemProdutoKit(@RequestParam Long idProduto) {
        Sessao sessao = SessaoUtil.getSessao();
        String produtoKit = KitRN.getInstance().getDescricaoKitsPorIdComponente(idProduto);
        String nomeProduto = "" + ProdutoRN.getInstance().buscarValorPorID(idProduto, "nome");
        if (!Util.stringNullOrEmpty((String)produtoKit) && (PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 243) || PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 244))) {
            return "O produto " + nomeProduto + " pertence aos kits:<br>" + produtoKit + "<br>Como o pre\u00e7o foi alterado tamb\u00e9m ser\u00e1 alterado o pre\u00e7o dos kits \u00e0 que ele pertence.";
        }
        return null;
    }

    protected String getCacheId() {
        return "programacao-preco";
    }
}

