/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.recursoexterno;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.importacao.ImportacaoArquivo;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.tools.regranegocio.ImportacaoArquivoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.recursoexterno.ParamsRecursoExterno;
import br.intelidata.uniplusweb.web.rest.app.crud.recursoexterno.RecursoExternoJob;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/recursos-externos"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", ICONE="icon-trabalharcom", NOME="Recursos externos", ROTA="/ferramentas/recursos-externos", PROGRAMA=1458)
public class RecursoExternoCrudController
extends CrudController<ImportacaoArquivo, ImportacaoArquivoRN>
implements ICreateTask {
    private final TaskManager taskManager;
    private final TenantService tenantService;

    public RecursoExternoCrudController(TaskManager taskManager, TenantService tenantService) {
        super((AbstractRegraNegocio)ImportacaoArquivoRN.getInstance(), ImportacaoArquivo::new);
        this.taskManager = taskManager;
        this.tenantService = tenantService;
    }

    public TipoJob getTipoJob() {
        return TipoJob.RECURSOS_EXTERNOS;
    }

    public Class<? extends AbstractJob> job() {
        return RecursoExternoJob.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    protected String getCacheId() {
        return "recursos-externos";
    }

    protected GridBuilder<ImportacaoArquivoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("arquivo", "Arquivo", 0, true));
        colunas.add(new ColunaSQL("versao", "Vers\u00e3o", 100, true));
        colunas.add(new ColunaSQL("ultimaVerificacao", "\u00daltima verifica\u00e7\u00e3o", 250, true));
        colunas.add(new ColunaSQL("ultimaAtualizacao", "\u00daltima atualiza\u00e7\u00e3o", 250, true));
        GridBuilder grid = new GridBuilder(ImportacaoArquivoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("arquivo"));
        return grid;
    }

    @RequestMapping(value={"/atualizar-recursos-externos"})
    @DBTransaction
    public void atualizarRecursosExternos() throws UnicoMensagemUsuarioException {
        this.createTask((Object)new ParamsRecursoExterno());
    }

    @RequestMapping(value={"/forcar-atualizacao"})
    @DBTransaction
    public void forcarAtualizacaoRecursoExterno(@RequestParam(value="id") Long id) throws UnicoMensagemUsuarioException {
        this.createTask((Object)new ParamsRecursoExterno(id));
    }
}

