/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.seguranca.ipaccess;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.domain.pojo.IpAccess;
import br.intelidata.commons.domain.pojo.enuns.TypeIpAccess;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.IpAccessRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/white-list"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliarSeguranca", NOME="IPs liberados", ICONE="icon-funcoes-auxiliares", ROTA="/cadastros/white-list", PROGRAMA=1506)
public class WhiteListCrudController
extends CrudController<IpAccess, IpAccessRN> {
    public WhiteListCrudController() {
        super((AbstractRegraNegocio)IpAccessRN.getInstance(), IpAccess::new);
    }

    protected String getCacheId() {
        return "white-list";
    }

    protected GridBuilder<IpAccessRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("ip", "IP", 0, true));
        colunas.add(new ColunaSQL("date", "Data/hora", 0, true));
        colunas.add(new ColunaSQL("type", "Tipo", 100, false, TypeIpAccess.class));
        GridBuilder grid = new GridBuilder(IpAccessRN.getInstance().getTabela(), colunas);
        grid.addCodicaoDefault(new Condicao("type", Operador.IGUAL, TypeIpAccess.WHITE.getId().intValue()));
        return grid;
    }
}

