/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.serie;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.Serie;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.SerieRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/series"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarModeloImpressao", NOME="Modelo nota fiscal", ROTA="/cadastros/series", PROGRAMA=17)
public class SerieCrudController
extends CrudController<Serie, SerieRN> {
    public SerieCrudController() {
        super((AbstractRegraNegocio)SerieRN.getInstance(), Serie::new, true, true);
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<Serie> getCombo(@RequestParam(required=false, defaultValue="true") boolean mostrarInativos) {
        return SerieRN.getInstance().getComboWeb(SessaoUtil.getSessao(), mostrarInativos);
    }

    @RequestMapping(value={"/combo-propriedades"})
    @DBAutoCommit
    public List<Serie> getComboPropriedadeWeb() {
        return SerieRN.getInstance().getComboPropriedadeWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/combo-nfce"})
    @DBAutoCommit
    public List<Serie> getComboNfce() {
        List series = SerieRN.getInstance().buscarSeriesPorTipoWeb(SessaoUtil.getSessao().getIdFilial(), false, false);
        List<Serie> seriesNfces = series.stream().filter(e -> e.getIdfilial().equals(SessaoUtil.getSessao().getIdFilial()) && e.getCodigo().equals(ModeloNotaFiscal.NOTA_FISCAL_CONSUMIDOR_ELETRONICA.getId())).collect(Collectors.toList());
        seriesNfces.sort(Comparator.comparing(Serie::getModelo));
        return seriesNfces;
    }

    @RequestMapping(value={"/combo-inutilizacao"})
    @DBAutoCommit
    public List<Serie> getComboInutilizacao() {
        return SerieRN.getInstance().getComboInutilizacaoWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/combo-inutilizacao-nfse"})
    @DBAutoCommit
    public List<Serie> getComboInutilizacaoNfse() {
        return SerieRN.getInstance().getComboInutilizacaoNfseWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/proximo-numero-nf"})
    @DBAutoCommit
    public String getProximoNumeroNotaFiscal(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        BigDecimal sequencial = SerieRN.getInstance().getProximoNumeroNotaFiscal(id, SessaoUtil.getSessao().getFilial().getId());
        return StringUtil.formataNumero((BigDecimal)sequencial, (String)"000000", (int)6);
    }

    @RequestMapping(value={"/combo-nfe"})
    @DBAutoCommit
    public List<Serie> buscarSerieNfe() {
        return SerieRN.getInstance().buscarSeriesPorTipoWeb(SessaoUtil.getSessao().getIdFilial(), false, true);
    }

    @RequestMapping(value={"/combo-nfse"})
    @DBAutoCommit
    public List<Serie> buscarSerieNfse() {
        return SerieRN.getInstance().buscarSeriesPorTipoWeb(SessaoUtil.getSessao().getIdFilial(), true, false);
    }

    protected GridBuilder<SerieRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idfilial", "idfilial", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("modelo", "S\u00e9rie", 0, true));
        colunas.add(new ColunaSQL("sequencialnotafiscal", "Pr\u00f3ximo n\u00famero de nota fiscal", 0, true));
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        GridBuilder grid = new GridBuilder(SerieRN.getInstance().getTabela(), colunas);
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        return grid;
    }

    protected String getCacheId() {
        String idsFiliais = Stream.of(FilialRN.getInstance().getIdsFiliaisUsuario(SessaoUtil.getSessao())).map(Object::toString).collect(Collectors.joining(","));
        return "series".concat("_").concat("_FILIAIS=(").concat(idsFiliais).concat(")");
    }
}

