/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.systax;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.regranegocio.SystaxProdutoCommonRN;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.systax.JobSystax;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JobSystax
extends AbstractPrepareJob {
    private TipoJob tipoJob;

    public JobSystax(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void execute() throws Exception {
        this.tipoJob = (TipoJob)EnumUtils.getPorId(TipoJob.class, (Object)Integer.parseInt(this.getJobMetadata().get("tipoJob").toString()));
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoJob[this.tipoJob.ordinal()]) {
            case 1: {
                String strIdsProdutos = this.getJobMetadata().get("idsProdutos").toString();
                List idsProdutos = Stream.of(strIdsProdutos.split("\\|")).map(Long::parseLong).collect(Collectors.toList());
                SystaxProdutoCommonRN.getInstance().atualizarProdutosSystax(SessaoUtil.getSessaoJob(), idsProdutos);
                break;
            }
            case 2: {
                SystaxProdutoCommonRN.getInstance().atualizarProdutosPendentesParaTributacao(SessaoUtil.getSessaoJob());
                break;
            }
            case 3: {
                SystaxProdutoCommonRN.getInstance().consultarProdutos(SessaoUtil.getSessaoJob());
                break;
            }
        }
    }

    public boolean abstractControlTransaction() {
        return false;
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao(TipoNotificacaoSimples.SUCCESS, this.tipoJob.getDescricao() + " realizada com sucesso.");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        String msg = "Falhou ao " + this.tipoJob.getDescricao();
        if (task.getExcecao() != null && task.getExcecao() instanceof UnicoMensagemUsuarioException) {
            msg = msg + ". " + ((UnicoMensagemUsuarioException)((Object)task.getExcecao())).getMensagemSemCodigo();
        }
        return new Notificacao(TipoNotificacaoSimples.ERROR, msg);
    }
}

