/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.systax.configuracao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.systax.SystaxConfiguracao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.SystaxConfiguracaoCommonRN;
import br.intelidata.commons.modulo.integracao.integracaosystax.regranegocio.SystaxConfiguracaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracao-systax"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliar", NOME="Configura\u00e7\u00e3o Systax", ROTA="/ferramentas/configuracao-systax", ICONE="icon icon-trabalharcom", PROGRAMA=1376)
public class ConfiguracaoSystaxCrudController
extends SimpleCrudController<SystaxConfiguracao, SystaxConfiguracaoRN> {
    public ConfiguracaoSystaxCrudController(TaskManager taskManager) {
        super((AbstractRegraNegocio)SystaxConfiguracaoRN.getInstance());
    }

    @DBAutoCommit
    public SystaxConfiguracao get(Long parentId) throws UnicoMensagemUsuarioException {
        Long idEmpresa = SessaoUtil.getSessao().getFilial().getIdEmpresa();
        if (Util.longNullOuZero((Long)idEmpresa)) {
            throw new UnicoMensagemUsuarioException("WINT46", "Empresa n\u00e3o encontrada!");
        }
        SystaxConfiguracao systaxConfiguracao = SystaxConfiguracaoCommonRN.getInstance().buscarPorEmpresa(idEmpresa);
        if (systaxConfiguracao == null) {
            systaxConfiguracao = new SystaxConfiguracao();
            systaxConfiguracao.setIdEmpresa(idEmpresa);
        }
        return systaxConfiguracao;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody SystaxConfiguracao systaxConfiguracao) throws UnicoMensagemUsuarioException {
        systaxConfiguracao.setIdEmpresa(SessaoUtil.getSessao().getFilial().getIdEmpresa());
        if (Util.longNullOuZero((Long)systaxConfiguracao.getId())) {
            SystaxConfiguracaoRN.getInstance().gravar(0, (AbstractPojo)systaxConfiguracao, SessaoUtil.getSessao());
        } else {
            SystaxConfiguracaoRN.getInstance().gravar(1, (AbstractPojo)systaxConfiguracao, SessaoUtil.getSessao());
        }
        return systaxConfiguracao.getId();
    }
}

