/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipocobranca;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.TipoCobranca;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoCobrancaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-cobranca"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Tipos de cobran\u00e7a", ROTA="/financeiros/tipos-cobranca", PROGRAMA=49)
public class TipoCobrancaCrudController
extends CrudController<TipoCobranca, TipoCobrancaRN> {
    public TipoCobrancaCrudController() {
        super((AbstractRegraNegocio)TipoCobrancaRN.getInstance(), TipoCobranca::new);
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<TipoCobranca> getCombo() {
        return TipoCobrancaRN.getInstance().getComboWeb();
    }

    @RequestMapping(value={"/documento-financeiro"})
    @DBAutoCommit
    public List<TipoCobranca> getComboPorTipoDocumento(@RequestParam Long idTipoDocumento) {
        return TipoCobrancaRN.getInstance().getComboPorIdTipoDocumentoFinanceiroWeb(idTipoDocumento);
    }

    public GridBuilder<TipoCobrancaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 150, true));
        colunas.add(new ColunaSQL("descricao", "Nome", 0, true));
        colunas.add(new ColunaSQL("descricao", "descricaoDocumento", "Tipo documento financeiro", 0, true, new String[]{"fk_tipocobranca_tipdocfin"}));
        return new GridBuilder(TipoCobrancaRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "tipos-cobranca";
    }
}

