/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipocomissao.familia;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.TipoComissaoFamilia;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.comissao.regranegocio.TipoComissaoFamiliaRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-comissao-familia"})
public class TipoComissaoFamiliaCrudController
extends CrudController<TipoComissaoFamilia, TipoComissaoFamiliaRN> {
    public TipoComissaoFamiliaCrudController() {
        super((AbstractRegraNegocio)TipoComissaoFamiliaRN.getInstance(), TipoComissaoFamilia::new);
        this.dependsOn("idTipoComissao");
    }

    protected GridBuilder<TipoComissaoFamiliaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idTipoComissao", "idTipoComissao", 0, false));
        colunas.add(new ColunaSQL("idFamilia", "idFamilia", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoFamilia", "Grupo", 30, true, new String[]{"fk_tipcomfam_hier"}));
        colunas.add(new ColunaSQL("nome", "nomeFamilia", "Grupo", 30, true, new String[]{"fk_tipcomfam_hier"}));
        colunas.add(new ColunaSQL("comissao", "% Comiss\u00e3o", 50, true));
        colunas.add(new ColunaSQL("comissaoAVista", "% Comiss\u00e3o \u00e0 vista", 50, true));
        colunas.add(new ColunaSQL("comissaoAPrazo", "% Comiss\u00e3o a prazo", 50, true));
        colunas.add(new ColunaSQL("comissaoQuitacao", "% Comiss\u00e3o na quita\u00e7\u00e3o", 50, true));
        return new GridBuilder(TipoComissaoFamiliaRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "tipos-comissao-familia";
    }

    protected void beforeSave(TipoComissaoFamilia tipoComissaoFamilia, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)tipoComissaoFamilia.getIdTipoComissao())) {
            throw new UnicoMensagemUsuarioException("WWW522", "Comiss\u00e3o n\u00e3o informada.");
        }
        if (NumberUtil.longNullOuZero((Long)tipoComissaoFamilia.getIdFamilia())) {
            throw new UnicoMensagemUsuarioException("WCMS46", "Fam\u00edlia do produto n\u00e3o informada! Verifique.");
        }
        if (this.familiaExiste(tipoComissaoFamilia.getIdTipoComissao(), tipoComissaoFamilia.getId(), tipoComissaoFamilia.getIdFamilia())) {
            throw new UnicoMensagemUsuarioException("WCMS48", "Fam\u00edlia do produto j\u00e1 existe na lista! Verifique.");
        }
    }

    private boolean familiaExiste(Long idTipoComissao, Long id, Long idFamilia) {
        return TipoComissaoFamiliaRN.getInstance().buscarComissaoPorTipoComissaoFamilia(idTipoComissao, idFamilia) != null && (NumberUtil.longNullOuZero((Long)id) || !((TipoComissaoFamilia)TipoComissaoFamiliaRN.getInstance().buscarPorId(id)).getIdFamilia().equals(idFamilia));
    }
}

