/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipocomissao.pauta;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.TipoComissaoPauta;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PautaPreco;
import br.intelidata.commons.domain.regranegocio.TipoComissaoPautaHierarquiaCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoComissaoPautaProdutoCommonRN;
import br.intelidata.commons.modulo.comissao.regranegocio.TipoComissaoPautaRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-comissao-pauta"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Pautas Tipos de comiss\u00e3o", ROTA="/financeiros/tipos-comissao/:idTipoComissao/tipos-comissao-pauta", PROGRAMA=56, CUSTOM_ACTION=true)
public class TipoComissaoPautaCrudController
extends CrudController<TipoComissaoPauta, TipoComissaoPautaRN> {
    public TipoComissaoPautaCrudController() {
        super((AbstractRegraNegocio)TipoComissaoPautaRN.getInstance(), TipoComissaoPauta::new, false);
        this.dependsOn("idTipoComissao");
    }

    protected GridBuilder<TipoComissaoPautaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idTipoComissao", "idTipoComissao", 0, false));
        colunas.add(new ColunaSQL("pauta", "C\u00f3digo", 120, true));
        ColunaSQL colunaDescricaoPauta = new ColunaSQL("descricaoPauta", "Pauta", 0, true);
        colunaDescricaoPauta.setVirtual(true);
        colunaDescricaoPauta.setValor("");
        colunas.add(colunaDescricaoPauta);
        colunas.add(new ColunaSQL("comissao", "% Comiss\u00e3o", 150, true));
        colunas.add(new ColunaSQL("comissaoAVista", "% Comiss\u00e3o \u00e0 vista", 150, true));
        colunas.add(new ColunaSQL("comissaoAPrazo", "% Comiss\u00e3o a prazo", 150, true));
        colunas.add(new ColunaSQL("comissaoQuitacao", "% Comiss\u00e3o na quita\u00e7\u00e3o", 180, true));
        return new GridBuilder(TipoComissaoPautaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeDelete(TipoComissaoPauta tipoComissaoPauta) {
        TipoComissaoPautaProdutoCommonRN.getInstance().excluirProdutosPorTipoComissaoPauta(SessaoUtil.getSessao(), tipoComissaoPauta.getId());
        TipoComissaoPautaHierarquiaCommonRN.getInstance().excluirHierarquiasPorTipoComissaoPauta(SessaoUtil.getSessao(), tipoComissaoPauta.getId());
    }

    protected void beforeSave(TipoComissaoPauta tipoComissaoPauta, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)tipoComissaoPauta.getIdTipoComissao())) {
            throw new UnicoMensagemUsuarioException("WWW87", "Comiss\u00e3o n\u00e3o informada.");
        }
        if (tipoComissaoPauta.getPauta() == null || tipoComissaoPauta.getPauta() < 0L) {
            throw new UnicoMensagemUsuarioException("WCMS32", "Pauta de pre\u00e7o n\u00e3o informada! Verifique.");
        }
        if (this.pautaExiste(tipoComissaoPauta.getIdTipoComissao(), tipoComissaoPauta.getId(), tipoComissaoPauta.getPauta())) {
            throw new UnicoMensagemUsuarioException("WCMS33", "Pauta j\u00e1 existe na lista! Verifique.");
        }
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(dado -> {
            int idx = this.getIndexColuna("descricaoPauta", colunas);
            int idxCodigoPauta = this.getIndexColuna("pauta", colunas);
            dado[idx] = PautaPreco.getInstance().getDescricaoPautaPreco(SessaoUtil.getSessao(), (Long)dado[idxCodigoPauta]);
        });
    }

    protected String getCacheId() {
        return "tipos-comissao-pauta";
    }

    private boolean pautaExiste(Long idTipoComissao, Long id, Long pauta) {
        return TipoComissaoPautaRN.getInstance().buscarComissaoPorTipoComissaoPauta(idTipoComissao, pauta) != null && (NumberUtil.longNullOuZero((Long)id) || !((TipoComissaoPauta)TipoComissaoPautaRN.getInstance().buscarPorId(id)).getPauta().equals(pauta));
    }
}

