/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipocomissao.pauta.produto;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.TipoComissaoPautaProduto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.comissao.regranegocio.TipoComissaoPautaProdutoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-comissao-pauta-produto"})
public class TipoComissaoPautaProdutoCrudController
extends CrudController<TipoComissaoPautaProduto, TipoComissaoPautaProdutoRN> {
    public TipoComissaoPautaProdutoCrudController() {
        super((AbstractRegraNegocio)TipoComissaoPautaProdutoRN.getInstance(), TipoComissaoPautaProduto::new);
        this.dependsOn("idTipoComissaoPauta");
    }

    protected GridBuilder<TipoComissaoPautaProdutoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idTipoComissaoPauta", "idTipoComissaoPauta", 0, false));
        colunas.add(new ColunaSQL("idProduto", "idProduto", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoProduto", "Cod. Produto", 30, true, new String[]{"fk_tipcompautprod_prod"}));
        colunas.add(new ColunaSQL("nome", "nomeProduto", "Produto", 30, true, new String[]{"fk_tipcompautprod_prod"}));
        colunas.add(new ColunaSQL("comissao", "% Comiss\u00e3o", 50, true));
        colunas.add(new ColunaSQL("comissaoAVista", "% Comiss\u00e3o \u00e0 vista", 50, true));
        colunas.add(new ColunaSQL("comissaoAPrazo", "% Comiss\u00e3o a prazo", 50, true));
        colunas.add(new ColunaSQL("comissaoQuitacao", "% Comiss\u00e3o na quita\u00e7\u00e3o", 50, true));
        return new GridBuilder(TipoComissaoPautaProdutoRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(TipoComissaoPautaProduto tipoComissaoPautaProduto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)tipoComissaoPautaProduto.getIdTipoComissaoPauta())) {
            throw new UnicoMensagemUsuarioException("WWW89", "Pauta de comiss\u00e3o n\u00e3o informada.");
        }
        if (NumberUtil.longNullOuZero((Long)tipoComissaoPautaProduto.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WCMS34", "Produto n\u00e3o informado! Verifique.");
        }
        if (this.produtoExiste(tipoComissaoPautaProduto.getIdTipoComissaoPauta(), tipoComissaoPautaProduto.getId(), tipoComissaoPautaProduto.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WCMS35", "Produto j\u00e1 existe na lista! Verifique.");
        }
    }

    protected String getCacheId() {
        return "tipos-comissao-pauta-produto";
    }

    private boolean produtoExiste(Long idTipoComissaoPauta, Long id, Long idProduto) {
        return TipoComissaoPautaProdutoRN.getInstance().buscarComissaoPorTipoComissaoPautaProduto(idTipoComissaoPauta, idProduto) != null && (NumberUtil.longNullOuZero((Long)id) || !((TipoComissaoPautaProduto)TipoComissaoPautaProdutoRN.getInstance().buscarPorId(id)).getIdProduto().equals(idProduto));
    }
}

