/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipodocumentofinanceiro;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.MicroFuncionalidade;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.TipoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.LocalUsoTipoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoIntegracaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoUsoTipoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoRetaguarda;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.TipoDocumentoFinanceiroCondicaoPagamentoCommonRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoDocumentoFinanceiroRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-documentos-financeiro"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Tipos de documentos financeiro", ROTA="/financeiros/tipos-documentos-financeiro", PROGRAMA=24)
public class TipoDocumentoFinanceiroCrudController
extends CrudController<TipoDocumentoFinanceiro, TipoDocumentoFinanceiroRN> {
    private final ResponseEntityService responseEntityService;
    private final ModuloService moduloService;
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public TipoDocumentoFinanceiroCrudController(ResponseEntityService responseEntityService, ModuloService moduloService, FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)TipoDocumentoFinanceiroRN.getInstance(), TipoDocumentoFinanceiro::new, true, true);
        this.responseEntityService = responseEntityService;
        this.moduloService = moduloService;
        this.funcionalidadeService = funcionalidadeService;
    }

    @RequestMapping(value={"/filtrar-documentos-a-receber"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> filtrarPorTipoReceber(@RequestParam(defaultValue="6", required=false) int limit, @RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="false") boolean adicionarTipoDocAVista) {
        return TipoDocumentoFinanceiroRN.getInstance().buscaTiposDocumentosReceberWeb(SessaoUtil.getSessao(), query, adicionarTipoDocAVista, limit);
    }

    @RequestMapping(value={"/filtrar-acao-por-local/tipo-uso"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarTipoAcaoPorLocalTipoUso(@RequestParam(required=false) String nameLocalUso, @RequestParam(required=false) String nameTipoUso) {
        LocalUsoTipoDocumentoFinanceiro localUso = null;
        if (!StringUtil.stringNullOrEmpty((String)nameLocalUso)) {
            localUso = Enum.valueOf(LocalUsoTipoDocumentoFinanceiro.class, nameLocalUso);
        }
        TipoUsoTipoDocumentoFinanceiro tipoUso = null;
        if (!StringUtil.stringNullOrEmpty((String)nameTipoUso)) {
            tipoUso = Enum.valueOf(TipoUsoTipoDocumentoFinanceiro.class, nameTipoUso);
        }
        List acoes = localUso != null && tipoUso != null ? TipoAcaoFinanceiro.getListaOpcoes((LocalUsoTipoDocumentoFinanceiro)localUso, (TipoUsoTipoDocumentoFinanceiro)tipoUso) : Stream.of(TipoAcaoFinanceiro.values()).collect(Collectors.toList());
        if (!this.funcionalidadeService.isAtiva(Funcionalidade.TROCA_ENDOSSO)) {
            acoes.remove(TipoAcaoFinanceiro.TROCA_ENDOSSO);
        }
        if (!this.funcionalidadeService.isAtiva(Funcionalidade.DEVOLUCAO_FINANCEIRO)) {
            acoes.remove(TipoAcaoFinanceiro.DEVOLUCAO);
        }
        if (!this.funcionalidadeService.isAtiva(Funcionalidade.ADIANTAMENTO)) {
            acoes.remove(TipoAcaoFinanceiro.ADIANTAMENTO_CLIENTE);
            acoes.remove(TipoAcaoFinanceiro.ADIANTAMENTO_FORNECEDOR);
            acoes.remove(TipoAcaoFinanceiro.PAGAMENTO_ADIANTAMENTO_CLIENTE);
            acoes.remove(TipoAcaoFinanceiro.PAGAMENTO_ADIANTAMENTO_FORNECEDOR);
        }
        String strJson = acoes.stream().map(acao -> new StringBuilder("{\"id\":").append(JsonUtil.escapeQuote((String)acao.name())).append(", \"descricao\":").append(JsonUtil.escapeQuote((String)acao.getDescricao())).append("}")).collect(Collectors.joining(","));
        return this.responseEntityService.createJSONResponse("[" + strJson + "]");
    }

    @RequestMapping(value={"/filtrar-por-integracao"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> filtrarPorIntegracao(@RequestParam(required=false) TipoIntegracaoFinanceiro integracao, @RequestParam(value="query", required=false) String textoPesquisado, @RequestParam(defaultValue="6", required=false) int limit) {
        return TipoDocumentoFinanceiroRN.getInstance().getComboPorIntegracaoWeb(SessaoUtil.getSessao(), integracao, textoPesquisado, limit);
    }

    @RequestMapping(value={"/buscar-todos-por-integracao"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> buscarTodosPorIntegracao(@RequestParam(required=false) TipoIntegracaoFinanceiro integracao) {
        return TipoDocumentoFinanceiroRN.getInstance().getListaPorIntegracaoWeb(SessaoUtil.getSessao(), integracao);
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> combo(@RequestParam(value="query", required=false) String textoPesquisado, @RequestParam(defaultValue="6", required=false) int limit) {
        return TipoDocumentoFinanceiroRN.getInstance().getComboWeb(SessaoUtil.getSessao(), textoPesquisado, limit);
    }

    @RequestMapping(value={"/combo-conhecimento"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> comboConhecimento(@RequestParam(value="query", required=false) String textoPesquisado, @RequestParam(defaultValue="6", required=false) int limit) {
        return TipoDocumentoFinanceiroRN.getInstance().getComboConhecimentoWeb(SessaoUtil.getSessao(), textoPesquisado, limit);
    }

    @RequestMapping(value={"/combo-remessa-bancaria"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> comboReceberRemessaBancaria(@RequestParam(value="query", required=false) String textoPesquisado, @RequestParam(defaultValue="6", required=false) int limit) {
        return TipoDocumentoFinanceiroRN.getInstance().getComboTipoDocumentoReceberRemessaBancariaWeb(SessaoUtil.getSessao(), textoPesquisado, limit);
    }

    @RequestMapping(value={"/por-tipo"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> filtrarPorTipoFinanceiro(@RequestParam TipoFinanceiro tipoFinanceiro, @RequestParam(required=false) Long idTipoDocumento) {
        List documentos = tipoFinanceiro.equals((Object)TipoFinanceiro.PAGAR) ? TipoDocumentoFinanceiroRN.getInstance().getComboTipoDocumentoPagarWeb(SessaoUtil.getSessao(), idTipoDocumento) : TipoDocumentoFinanceiroRN.getInstance().getComboTipoDocumentoReceberWeb(SessaoUtil.getSessao(), idTipoDocumento);
        return documentos;
    }

    @RequestMapping(value={"/formas-pgmto"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> buscarFormaPagamento(@RequestParam TipoFinanceiro tipoFinanceiro) {
        List documentos = tipoFinanceiro.equals((Object)TipoFinanceiro.PAGAR) ? TipoDocumentoFinanceiroRN.getInstance().getComboFormaPagamentoPagarWeb(SessaoUtil.getSessao()) : TipoDocumentoFinanceiroRN.getInstance().getComboFormaPagamentoReceberWeb(SessaoUtil.getSessao());
        return documentos;
    }

    @RequestMapping(value={"/formas-pgmto-contas-correntes"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> buscarFormaPagamentoContaCorrente(@RequestParam(required=false) String query, @RequestParam(required=false) Integer limit) {
        return TipoDocumentoFinanceiroRN.getInstance().getComboFormaPagamentoContaCorrenteWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/tipos-a-pagar"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> getComboTipoDocumentoPagarWeb() {
        return TipoDocumentoFinanceiroRN.getInstance().getComboTipoDocumentoPagarWeb(SessaoUtil.getSessao(), null);
    }

    @RequestMapping(value={"/tipos-a-receber"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> getComboTipoDocumentoReceberWeb() {
        return TipoDocumentoFinanceiroRN.getInstance().getComboTipoDocumentoReceberWeb(SessaoUtil.getSessao(), null);
    }

    @RequestMapping(value={"/filtrar-por-tipo-retaguarda"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> buscarListaPorTipoRetaguarda(@RequestParam TipoRetaguarda tipo) {
        Sessao sessao = SessaoUtil.getSessao();
        if (ModuloManager.getInstance().isMicroFuncionalidadeAtiva(MicroFuncionalidade.LOCALUSO_TIPOUSO_NO_TIPODOCUMENTOFINANCEIRO)) {
            if (tipo.equals((Object)TipoRetaguarda.GERAR_CONTAS_PAGAR)) {
                return TipoDocumentoFinanceiroRN.getInstance().getComboTipoDocumentoPagarWeb(sessao, null);
            }
            return TipoDocumentoFinanceiroRN.getInstance().getComboTipoDocumentoReceberWeb(sessao, null);
        }
        return TipoDocumentoFinanceiroRN.getInstance().getSelectComboAcaoWeb(sessao, new TipoAcaoFinanceiro[]{TipoAcaoFinanceiro.RECEBER, TipoAcaoFinanceiro.CARTEIRA_DIGITAL, TipoAcaoFinanceiro.RECEBER_CARTAO_DEBITO, TipoAcaoFinanceiro.RECEBER_CARTAO_CREDITO, TipoAcaoFinanceiro.CHEQUE, TipoAcaoFinanceiro.CHEQUE_TERCEIRO, TipoAcaoFinanceiro.ADIANTAMENTO_CLIENTE, TipoAcaoFinanceiro.DEVOLUCAO});
    }

    @RequestMapping(value={"/tipo-cartao"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> buscarListaTipoCartao() {
        return TipoDocumentoFinanceiroRN.getInstance().getTipoCartaoWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/combo-gnre"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> buscarListaTipoGnre() {
        return TipoDocumentoFinanceiroRN.getInstance().getSelectComboGnreWeb(SessaoUtil.getSessao());
    }

    protected void read(TipoDocumentoFinanceiro tipoDocumentoFinanceiro, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CONDICAO_PAGAMENTO_POR_TIPO_DOCUMENTO)) {
            tipoDocumentoFinanceiro.setListaCondicoesPagamento(TipoDocumentoFinanceiroCondicaoPagamentoCommonRN.getInstance().buscarListaPorTipoDocumento(tipoDocumentoFinanceiro.getId()));
        }
    }

    protected void beforeUpdate(TipoDocumentoFinanceiro tipoDocumentoFinanceiro, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!ModuloManager.getInstance().isAtivo(Modulo.COMISSAO) && !FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.NEGOCIACAO) && tipoDocumentoFinanceiro.getId() < 0L) {
            throw new UnicoMensagemUsuarioException("WFIN139", "Tipo de documento financeiro n\u00e3o pode ser alterado");
        }
    }

    protected void beforeDelete(TipoDocumentoFinanceiro tipoDocumentoFinanceiro) throws UnicoMensagemUsuarioException {
        if (tipoDocumentoFinanceiro.getId() < 0L) {
            throw new UnicoMensagemUsuarioException("WFIN140", "Tipo de documento financeiro n\u00e3o pode ser excluido");
        }
    }

    protected GridBuilder<TipoDocumentoFinanceiroRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        if (this.moduloService.isMicroFuncionalidadeAtiva(MicroFuncionalidade.LOCALUSO_TIPOUSO_NO_TIPODOCUMENTOFINANCEIRO)) {
            colunas.add(new ColunaSQL("localUso", "Local de uso", 200, true, LocalUsoTipoDocumentoFinanceiro.class));
            colunas.add(new ColunaSQL("tipoUso", "Tipo de uso", 280, true, TipoUsoTipoDocumentoFinanceiro.class));
        }
        colunas.add(new ColunaSQL("acao", "A\u00e7\u00e3o", 280, true, TipoAcaoFinanceiro.class));
        if (this.moduloService.isAtivo(Modulo.COMISSAO)) {
            colunas.add(new ColunaSQL("baixaGeraComissao", "Baixa gera comiss\u00e3o", 150, true, EnumSimNao.class));
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.NEGOCIACAO)) {
            colunas.add(new ColunaSQL("utilizadoEmNegociacao", "Utilizado em negocia\u00e7\u00e3o", 200, true, EnumSimNao.class));
        }
        GridBuilder grid = new GridBuilder(TipoDocumentoFinanceiroRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("id"));
        return grid;
    }

    protected String getCacheId() {
        return "tipos-documentos-financeiro";
    }
}

