/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.ListenerProgresso;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.ItemCriticaImportacaoXmlNfe;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.CategoriaEventoSistema;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.pafecf.Finalizador;
import br.intelidata.commons.domain.regranegocio.HierarquiaGrupoProdutoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EventoSistemaRN;
import br.intelidata.commons.modulo.pdv.regranegocio.FinalizadorRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importacao.ImportacaoAtoCotepeOperacaoController;
import br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importacao.ImportacaoAtoCotepeWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importacao.ImportacaoCriticaAtoCotepeWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importacao.MeioPagamentoAtoCotepeWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importacao.Progresso;
import br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importacao.TipoFiltroAtoCotepe;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import unipaf.importacao.ImportacaoAtoCotepeModel;
import unipaf.importacao.ImportacaoAtoCotepeRN;
import unipaf.importacao.ImportacaoAtoCotepeTDMAux;
import unipaf.importacao.ValidacaoProdutoAtoCotepe;

@RestController
@RequestMapping(value={"/api/importacoes-operacoes-atocotepe"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Importa\u00e7\u00e3o de opera\u00e7\u00f5es", ROTA="/pdvs/importacoes-operacoes-atocotepe", PROGRAMA=533)
public class ImportacaoAtoCotepeOperacaoController {
    private final ResponseEntityService responseEntityService;

    public ImportacaoAtoCotepeOperacaoController(ResponseEntityService responseEntityService) {
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/processar-arquivo"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    @DBTransaction
    public ImportacaoCriticaAtoCotepeWrapper processarArquivo(@RequestPart(value="file") MultipartFile multipartFile, @RequestPart(value="configuracoes") ImportacaoAtoCotepeWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (TipoFiltroAtoCotepe.COO.equals((Object)wrapper.getTipoFiltro()) && NumberUtil.longNullOuZero((Long)wrapper.getCoo())) {
            throw new UnicoMensagemUsuarioException("WWW538", "Informe um COO para filtrar ou selecione outro tipo de filtro.");
        }
        byte[] arquivo = this.getArquivo(multipartFile);
        new ImportacaoAtoCotepeTDMAux().getAtoCotepeCabecalho((InputStream)new ByteArrayInputStream(arquivo), wrapper.getEncode(), true);
        Malote malote = new Malote("atocotepe", arquivo);
        ImportacaoAtoCotepeModel model = this.getModel(wrapper);
        ValidacaoProdutoAtoCotepe validacaoProduto = new ValidacaoProdutoAtoCotepe(model, wrapper.getEncode());
        validacaoProduto.setFile(false);
        validacaoProduto.leArquivo(malote, "");
        List listaCriticas = validacaoProduto.getListCriticas();
        listaCriticas.sort((o1, o2) -> {
            String acaoCritica1 = o1.getAcaoEscolhida().getDescricao();
            String acaoCritica2 = o2.getAcaoEscolhida().getDescricao();
            int comparaAcao = acaoCritica2.compareTo(acaoCritica1);
            if (comparaAcao != 0) {
                return comparaAcao;
            }
            String tipoCritica1 = o1.getTipoCriticaImportacaoXmlNfe().getDescricao();
            String tipoCritica2 = o2.getTipoCriticaImportacaoXmlNfe().getDescricao();
            return tipoCritica1.compareTo(tipoCritica2);
        });
        ImportacaoCriticaAtoCotepeWrapper importacao = new ImportacaoCriticaAtoCotepeWrapper(listaCriticas, validacaoProduto.getMeiosPagamento().stream().map(MeioPagamentoAtoCotepeWrapper::new).collect(Collectors.toList()));
        importacao.setAtoCotepeWrapper(wrapper);
        return importacao;
    }

    @RequestMapping(value={"/importar"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    @DBAutoCommit
    public ResponseEntity<byte[]> importar(@RequestPart(value="file") MultipartFile multipartFile, @RequestPart(value="wrapper") ImportacaoCriticaAtoCotepeWrapper wrapper) throws UnicoMensagemUsuarioException {
        ImportacaoAtoCotepeModel model = this.getModel(wrapper.getAtoCotepeWrapper());
        byte[] arquivo = this.getArquivo(multipartFile);
        Malote malote = new Malote("atocotepe", arquivo);
        ValidacaoProdutoAtoCotepe validacaoProduto = new ValidacaoProdutoAtoCotepe(model, wrapper.getAtoCotepeWrapper().getEncode());
        validacaoProduto.setFile(false);
        validacaoProduto.leArquivo(malote, "");
        if (wrapper.getMeiosPagamento().stream().anyMatch(m -> NumberUtil.longNullOuZero((Long)m.getIdFinalizador()))) {
            throw new UnicoMensagemUsuarioException("WWW540", "Existem meios de pagamentos que n\u00e3o foram relacionados! Verifique.");
        }
        Map mapProdutos = model.getMapProdutos();
        Map mapUnidadeMedida = model.getMapUnidades();
        Map mapEmbalagem = model.getMapEmbalagem();
        Map mapMeiosPagamento = model.getMapMeiosPagamento();
        wrapper.getMeiosPagamento().forEach(m -> {
            Finalizador cfr_ignored_0 = (Finalizador)mapMeiosPagamento.put(m.getMeioPagamentoEcf(), FinalizadorRN.getInstance().buscarPorId(m.getIdFinalizador()));
        });
        this.mapearCriticas(wrapper, mapProdutos, mapUnidadeMedida, mapEmbalagem);
        if (model.isAtualizarCupomDivergente()) {
            EventoSistemaRN.getInstance().gravaEvento(SessaoUtil.getSessao(), false, CategoriaEventoSistema.IMPORTACAO_ATO_COTEPE, "Importa\u00e7\u00e3o das opera\u00e7\u00f5es do arquivo ATO COTEPE sobrescrevendo as opera\u00e7\u00f5es da base.");
        }
        model.setMapProdutos(mapProdutos);
        model.setMapUnidades(mapUnidadeMedida);
        model.setMapEmbalagem(mapEmbalagem);
        model.setMapMeiosPagamento(mapMeiosPagamento);
        Remessa retorno = ImportacaoAtoCotepeRN.getInstance().importa(new Remessa(malote), model, true, model.getEncoding(), false);
        if (retorno != null) {
            Object result = retorno.getMalote().get("pdf");
            byte[] pdf = result instanceof File ? Util.file2ByteArray((File)((File)result)) : (byte[])result;
            return this.responseEntityService.createPDFResponse(pdf, "Erros importa\u00e7\u00e3o Ato Cotepe");
        }
        return null;
    }

    private ImportacaoAtoCotepeModel getModel(ImportacaoAtoCotepeWrapper wrapper) {
        ImportacaoAtoCotepeModel model = new ImportacaoAtoCotepeModel();
        model.setPdv(wrapper.getPdv().intValue());
        model.setSessao(SessaoUtil.getSessao());
        model.setIncidenciaDescontoIss(wrapper.getIncidenciaDescontoIss().getId().intValue());
        model.setAssociarPorReferencia(wrapper.isReferencia());
        model.setGerarCodigoProdutoNaoCadastrado(wrapper.isGerarCodigo());
        model.setAtualizarCupomDivergente(wrapper.isAtualizaCupom());
        model.setDataInicial(wrapper.getPeriodoInicial() != null ? wrapper.getPeriodoInicial() : wrapper.getPeriodoInicialArquivo());
        model.setDataFinal(wrapper.getPeriodoFinal() != null ? wrapper.getPeriodoFinal() : wrapper.getPeriodoFinalArquivo());
        model.setCooFiltro(wrapper.getCoo());
        model.setTipoFiltro(wrapper.getTipoFiltro().getId().intValue());
        model.setEncoding(wrapper.getEncode());
        model.setProgresso((ListenerProgresso)new Progresso());
        return model;
    }

    private byte[] getArquivo(MultipartFile multipartFile) throws UnicoMensagemUsuarioException {
        byte[] arquivo;
        try {
            arquivo = multipartFile.getBytes();
        }
        catch (IOException ex) {
            throw new UnicoMensagemUsuarioException("WWW539", "N\u00e3o foi posss\u00edvel importar o arquivo. Por favor verifique a integridade do arquivo.");
        }
        return arquivo;
    }

    private void mapearCriticas(ImportacaoCriticaAtoCotepeWrapper wrapper, Map<String, Produto> mapProdutos, Map<String, Unidademedida> mapUnidadeMedida, Map<String, Embalagem> mapEmbalagem) throws UnicoMensagemUsuarioException {
        for (ItemCriticaImportacaoXmlNfe item : wrapper.getListaCritica()) {
            switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoAcaoImportacaoXml[item.getAcaoEscolhida().ordinal()]) {
                case 1: {
                    this.associar(item, mapProdutos, mapUnidadeMedida);
                    break;
                }
                case 2: {
                    this.cadastrar(wrapper, item, mapProdutos, mapUnidadeMedida, mapEmbalagem);
                    break;
                }
                case 3: {
                    throw new UnicoMensagemUsuarioException("WWW541", "Exitem criticas de itens a serem ajustadas! Verifique.");
                }
            }
        }
    }

    private void associar(ItemCriticaImportacaoXmlNfe itemCritica, Map<String, Produto> mapProdutos, Map<String, Unidademedida> mapUnidadeMedida) {
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoCriticaImportacaoXmlNfe[itemCritica.getTipoCriticaImportacaoXmlNfe().ordinal()]) {
            case 1: {
                Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(itemCritica.getIdAssociado());
                mapProdutos.put(itemCritica.getChave(), produto);
                break;
            }
            case 2: {
                Unidademedida unidade = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(itemCritica.getIdAssociado());
                mapUnidadeMedida.put(itemCritica.getChave(), unidade);
                break;
            }
        }
    }

    private void cadastrar(ImportacaoCriticaAtoCotepeWrapper wrapper, ItemCriticaImportacaoXmlNfe itemCritica, Map<String, Produto> mapProdutos, Map<String, Unidademedida> mapUnidadeMedida, Map<String, Embalagem> mapEmbalagem) {
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoCriticaImportacaoXmlNfe[itemCritica.getTipoCriticaImportacaoXmlNfe().ordinal()]) {
            case 1: {
                Produto produto = new Produto();
                if (wrapper.getAtoCotepeWrapper().isGerarCodigo()) {
                    produto.setCodigo("");
                } else {
                    produto.setCodigo(itemCritica.getChave());
                }
                if (Util.isApenasNumeros((String)itemCritica.getChave())) {
                    if (Util.getCodigoBarrasValido((String)itemCritica.getChave())) {
                        produto.setEan(itemCritica.getChave());
                        produto.setCodigo("");
                    } else {
                        produto.setReferencia(itemCritica.getChave());
                    }
                } else {
                    produto.setReferencia(itemCritica.getChave());
                }
                HierarquiaGrupoProduto grupo = (HierarquiaGrupoProduto)new HierarquiaGrupoProdutoCommonRN().buscarPorId(itemCritica.getIdGrupo());
                produto.setNome(itemCritica.getDescricaoProdutoAlterada());
                produto.setPreco(itemCritica.getPrecoAlterado());
                produto.setCasasDecimais(itemCritica.getCasasDecimaisPreco());
                produto.setIdHierarquia(itemCritica.getIdGrupo());
                produto.setUnidadeMedida(itemCritica.getDescricaoUnidadeMedida());
                produto.setTributacao(itemCritica.getTributacao());
                produto.setRegistroImportado(true);
                produto.setIdNcm(grupo.getIdNcm());
                produto.setIdCest(grupo.getIdCest());
                produto.setSituacaoTributaria(grupo.getCstICMS());
                produto.setSituacaoTributariaEntrada(grupo.getSituacaoTributariaEntrada());
                produto.setSituacaoTributariaSN(grupo.getCstSNICMS());
                produto.setSituacaoTributariaSNEntrada(grupo.getSituacaoTributariaSNEntrada());
                produto.setSituacaoTributariaIPI(grupo.getSituacaoTributariaIPI());
                produto.setModoCalculoIPI(grupo.getModoCalculoIPI());
                produto.setPercentualIPISaida(grupo.getIpi());
                produto.setSituacaoTributariaIPIEntrada(grupo.getSituacaoTributariaIPIEntrada());
                produto.setModoCalculoIPIEntrada(grupo.getModoCalculoIPIEntrada());
                produto.setIpiEntrada(grupo.getIpiEntrada());
                produto.setCstPis(grupo.getCstPis());
                produto.setCstCofins(grupo.getCstCofins());
                produto.setAliquotaPis(grupo.getAliquotaPis());
                produto.setAliquotaCofins(grupo.getAliquotaCofins());
                produto.setCstPisEntrada(grupo.getCstPisEntrada());
                produto.setCstCofinsEntrada(grupo.getCstCofinsEntrada());
                produto.setAliquotaPisEntrada(grupo.getAliquotaPisEntrada());
                produto.setAliquotaCofinsEntrada(grupo.getAliquotaCofinsEntrada());
                produto.setAliquotaIcmsInterna(itemCritica.getAliquota());
                if (!Util.stringNullOrEmpty((String)itemCritica.getTributacao())) {
                    if (itemCritica.getTributacao().contains("S")) {
                        produto.setTipo(TipoRegistroProduto.SERVICO);
                    } else {
                        produto.setTipo(TipoRegistroProduto.PRODUTO);
                    }
                }
                mapProdutos.put(itemCritica.getChave(), produto);
                break;
            }
            case 2: {
                Unidademedida unidade = new Unidademedida();
                unidade.setCodigo(itemCritica.getChave());
                unidade.setNome(itemCritica.getDescricaoUnidadeMedida());
                unidade.setCasasdecimais(Integer.valueOf(itemCritica.getCasasDecimaisUnidadeMedida()));
                mapUnidadeMedida.put(itemCritica.getChave(), unidade);
                break;
            }
            case 3: {
                Long idProduto = !Util.longNullOuZero((Long)itemCritica.getIdOriginal()) ? itemCritica.getIdOriginal() : itemCritica.getIdAssociado();
                Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
                Embalagem emb = new Embalagem();
                emb.setIdProduto(idProduto);
                emb.setCodigoProduto(produto.getCodigo());
                emb.setCodigoBarras("");
                emb.setFatorConversao(itemCritica.getFatorConversaoUnidadeMedida());
                emb.setIdUnidadeMedida(itemCritica.getUnidadeMedidaAlterada().getId());
                emb.setTipoEmbalagem(TipoEmbalagem.COMPRA);
                mapEmbalagem.put(itemCritica.getChave(), emb);
                break;
            }
        }
    }
}

