/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.placeholder;

import br.intelidata.api.b2c.service.placeholder.PlaceHolderMapService;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.placeholder.ParamsJobWrapper;
import java.io.File;
import java.util.Scanner;

public class PlaceHolderJob
extends AbstractPrepareJob {
    private final PlaceHolderMapService placeHolderMapService = (PlaceHolderMapService)BeanUtil.getBean((String)"placeHolderMapService");
    private StringBuilder erros;

    public PlaceHolderJob(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    public void execute() throws Exception {
        ParamsJobWrapper paramsJobWrapper = (ParamsJobWrapper)JsonUtil.fromJson((String)this.getParameters(), ParamsJobWrapper.class);
        if (paramsJobWrapper == null) {
            throw new UnicoMensagemUsuarioException("WWW605", "Par\u00e2metros n\u00e3o definidos.");
        }
        this.erros = this.placeHolderMapService.get(paramsJobWrapper.getServico().toString()).processarDiretorio(paramsJobWrapper.getDiretorio(), paramsJobWrapper.getParametrosPlaceHolder());
        if (this.erros.length() > 0) {
            UViewer uViewer = new UViewer(SaidaRelatorio.PDF, "Imagens n\u00e3o processadas", new int[]{10});
            uViewer.inicioRelatorio();
            uViewer.inicioTitulo();
            uViewer.escreveTitulo("Imagem criticada", false);
            uViewer.fimTitulo();
            Scanner scanner = new Scanner(this.erros.toString());
            while (scanner.hasNextLine()) {
                uViewer.inicioLinha();
                uViewer.escreveColuna(scanner.nextLine());
                uViewer.fimLinha();
            }
            uViewer.fimRelatorio();
            this.addMensagemRetorno("Algumas imagens n\u00e3o foram processadas, consulte o arquivo.");
            Remessa remessa = uViewer.getRemessa();
            if (remessa != null) {
                this.saveFile((File)remessa.getMalote().getMapArquivos().get("pdf"));
            }
        }
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao(this.erros.length() == 0 ? "Todas as imagens foram processadas com sucesso." : "Algumas imagens n\u00e3o foram processadas, consulte o arquivo.");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("N\u00e3o foi poss\u00edvel processar as imagens.");
    }
}

