/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.transacaofinanceira;

import br.intelidata.api.b2c.payment.service.PaymentService;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.IntermediadorMarketplace;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.b2c.TransacaoFinanceira;
import br.intelidata.commons.domain.pojo.enuns.ParceiroIntegracao;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.TransacaoFinanceiraEntidade;
import br.intelidata.commons.domain.pojo.enuns.TransacaoFinanceiraMeioPagamento;
import br.intelidata.commons.domain.pojo.enuns.TransacaoFinanceiraStatus;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.b2c.ConfiguracaoShopRN;
import br.intelidata.commons.domain.regranegocio.b2c.TransacaoFinanceiraRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.IntermediadorMarketplaceRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.transacaofinanceira.TransacaoFinanceiraPix;
import java.util.Collections;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/transacoes-financeiras"})
public class TransacaoFinanceiraCrudController
extends CrudController<TransacaoFinanceira, TransacaoFinanceiraRN> {
    private final PaymentService<?> paymentService;

    public TransacaoFinanceiraCrudController(@Lazy PaymentService<?> paymentService) {
        super((AbstractRegraNegocio)TransacaoFinanceiraRN.getInstance(), TransacaoFinanceira::new);
        this.paymentService = paymentService;
    }

    @PostMapping(value={"/estornar"})
    @DBTransaction
    public void estornarTransacao(@RequestBody Long idTransacaoFinanceira) throws UnicoMensagemUsuarioException {
        TransacaoFinanceira transacaoFinanceira = (TransacaoFinanceira)TransacaoFinanceiraRN.getInstance().buscarPorId(idTransacaoFinanceira);
        if (transacaoFinanceira == null) {
            throw new UnicoMensagemUsuarioException("WWW586", "Transa\u00e7\u00e3o financeira n\u00e3o encontrada.");
        }
        if (TransacaoFinanceiraStatus.isEstornado((TransacaoFinanceiraStatus)transacaoFinanceira.getStatus())) {
            throw new UnicoMensagemUsuarioException("WWW587", "A transa\u00e7\u00e3o j\u00e1 cancelada/estornada.");
        }
        Pedido pedido = PedidoRN.getInstance().buscarPorTransacaoFinanceira(transacaoFinanceira.getId());
        if (!pedido.getStatus().equals((Object)StatusDAV.AGUARDANDO_PAGAMENTO) && !pedido.getStatus().equals((Object)StatusDAV.AGUARDANDO_FATURAMENTO)) {
            throw new UnicoMensagemUsuarioException("WWW592", "O pedido precisa estar com status 'Aguardando pagamento' ou 'Aguardando faturamento'.");
        }
        boolean isTransacaoPropria = transacaoFinanceira.getEntidade().equals((Object)TransacaoFinanceiraEntidade.PROPRIO);
        boolean meioPagamentoDefault = transacaoFinanceira.getMeioPagamento().equals((Object)TransacaoFinanceiraMeioPagamento.DEFAULT);
        if (!isTransacaoPropria && !meioPagamentoDefault) {
            this.paymentService.getPayment().cancelarTransacao(transacaoFinanceira);
        }
        Sessao sessao = SessaoUtil.getSessao();
        pedido.setIdTransacaoFinanceira(null);
        pedido.setStatus(StatusDAV.AGUARDANDO_PAGAMENTO);
        PedidoRN.getInstance().alterar((AbstractPojo)pedido, sessao);
        FinanceiroDadoRN.getInstance().cancelaFinanceiroTransacaoFinanceira(sessao, transacaoFinanceira, pedido.getIdCliente());
        if (isTransacaoPropria || meioPagamentoDefault) {
            transacaoFinanceira.setStatus(TransacaoFinanceiraStatus.ESTORNADO);
            TransacaoFinanceiraRN.getInstance().alterar((AbstractPojo)transacaoFinanceira, sessao);
        }
    }

    @RequestMapping(value={"/pertence-uniplusshop"})
    @DBAutoCommit
    public boolean pertenceUnilusSHop(@RequestParam Long idTransacaoFinanceira) {
        IntermediadorMarketplace intermediadorMarketplace;
        TransacaoFinanceira transacaoFinanceira = (TransacaoFinanceira)TransacaoFinanceiraRN.getInstance().buscarPorId(idTransacaoFinanceira);
        if (transacaoFinanceira != null && (intermediadorMarketplace = (IntermediadorMarketplace)IntermediadorMarketplaceRN.getInstance().buscarPorId(transacaoFinanceira.getIdIntermediadorMarketplace())) != null) {
            return ParceiroIntegracao.UNIPLUS_SHOP.equals((Object)intermediadorMarketplace.getParceiroIntegracao());
        }
        return false;
    }

    @PostMapping(value={"/aprovar-pix"})
    @DBTransaction
    public void aprovarPagamentoPIX(@RequestBody TransacaoFinanceiraPix transacaoFinanceiraPix) throws UnicoMensagemUsuarioException {
        TransacaoFinanceira transacaoFinanceira = (TransacaoFinanceira)TransacaoFinanceiraRN.getInstance().buscarPorId(transacaoFinanceiraPix.getIdTransacao());
        if (transacaoFinanceira == null) {
            throw new UnicoMensagemUsuarioException("WWW614", "Transa\u00e7\u00e3o financeira n\u00e3o encontrada.");
        }
        if (TransacaoFinanceiraStatus.isEstornado((TransacaoFinanceiraStatus)transacaoFinanceira.getStatus())) {
            throw new UnicoMensagemUsuarioException("WWW615", "A transa\u00e7\u00e3o j\u00e1 cancelada/estornada.");
        }
        if (!transacaoFinanceira.getMeioPagamento().equals((Object)TransacaoFinanceiraMeioPagamento.PIX)) {
            throw new UnicoMensagemUsuarioException("WWW616", "N\u00e3o foi utilizado PIX como meio de pagamento nesse pedido.");
        }
        Pedido pedido = PedidoRN.getInstance().buscarPorTransacaoFinanceira(transacaoFinanceira.getId());
        if (!pedido.getStatus().equals((Object)StatusDAV.AGUARDANDO_PAGAMENTO)) {
            throw new UnicoMensagemUsuarioException("WWW617", "O pedido precisa estar com status 'Aguardando pagamento'.");
        }
        if (transacaoFinanceiraPix.getDataPagamento().isAfter(DataHoraFactory.getData())) {
            throw new UnicoMensagemUsuarioException("WWW624", "A data de pagamento n\u00e3o pode ser maior que a data atual.");
        }
        Sessao sessao = SessaoUtil.getSessao();
        transacaoFinanceira.setStatus(TransacaoFinanceiraStatus.APROVADO);
        transacaoFinanceira.setIdUsuarioAprovacao(sessao.getIdUsuario());
        transacaoFinanceira.setDataHoraAprovacao(DataHoraFactory.getDataHora());
        TransacaoFinanceiraRN.getInstance().alterar((AbstractPojo)transacaoFinanceira, sessao);
        FinanceiroDadoRN.getInstance().geraPixTransacaoFinanceiraShop(sessao, transacaoFinanceira, pedido, ConfiguracaoShopRN.getInstance().buscarConfiguracao().getIdContaCorrente(), transacaoFinanceiraPix.getDataPagamento());
        pedido.setStatus(StatusDAV.AGUARDANDO_FATURAMENTO);
        PedidoRN.getInstance().alterar((AbstractPojo)pedido, sessao);
    }

    protected String getCacheId() {
        return "transacoes-financeiras";
    }

    protected GridBuilder<TransacaoFinanceiraRN> getGridBuilder() {
        return new GridBuilder(TransacaoFinanceiraRN.getInstance().getTabela(), Collections.emptyList());
    }

    protected void beforeRead(TransacaoFinanceira transacaoFinanceira, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeRead((AbstractPojo)transacaoFinanceira, modo, parentId);
        if (transacaoFinanceira != null) {
            if (transacaoFinanceira.getEntidade().isCarteiraDigital()) {
                transacaoFinanceira.setDescricaoPagamento("Carteira Digital - " + transacaoFinanceira.getEntidade().getDescricao());
            } else if (TransacaoFinanceiraMeioPagamento.DEFAULT.equals((Object)transacaoFinanceira.getMeioPagamento())) {
                transacaoFinanceira.setDescricaoPagamento(transacaoFinanceira.getNomeFinalizador());
            } else {
                transacaoFinanceira.setDescricaoPagamento(transacaoFinanceira.getMeioPagamento().getDescricao());
            }
        }
    }

    @RequestMapping(value={"/verificar-financeiro-proprio"})
    @DBAutoCommit
    public boolean isFinanceiroProprio(@RequestParam Long idTransacaoFinanceira) {
        TransacaoFinanceira transacaoFinanceira = (TransacaoFinanceira)TransacaoFinanceiraRN.getInstance().buscarPorId(idTransacaoFinanceira);
        return transacaoFinanceira != null && transacaoFinanceira.isFinanceiroProprio();
    }
}

