/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.contrato.agendamento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ContratoVendaAgendamento;
import br.intelidata.commons.domain.pojo.enuns.TipoAgendamentoContratoVenda;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.intelidata.regranegocio.ContratoVendaAgendamentoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contratos-agendados"})
public class ContratoAgendamentoCrudController
extends CrudController<ContratoVendaAgendamento, ContratoVendaAgendamentoRN> {
    private final ConnectionOAuth2Service oAuth2Service;

    public ContratoAgendamentoCrudController(ConnectionOAuth2Service oAuth2Service) {
        super((AbstractRegraNegocio)ContratoVendaAgendamentoRN.getInstance(), ContratoVendaAgendamento::new);
        this.dependsOn("idContrato");
        this.oAuth2Service = oAuth2Service;
    }

    @RequestMapping(value={"/executar"})
    @DBTransaction
    public void executarAgendamento(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        ContratoVendaAgendamento contratoVendaAgendamento = (ContratoVendaAgendamento)ContratoVendaAgendamentoRN.getInstance().buscarPorId(id);
        if (contratoVendaAgendamento == null || contratoVendaAgendamento.isAplicado() || contratoVendaAgendamento.isCancelado()) {
            throw new UnicoMensagemUsuarioException("WWW228", "N\u00e3o \u00e9 poss\u00edvel executar esta opera\u00e7\u00e3o para o agendamento selecionado.");
        }
        ContratoVendaAgendamentoRN.getInstance().executarAgendamento(SessaoUtil.getSessao(), contratoVendaAgendamento);
        if (TipoAgendamentoContratoVenda.ENCERRAMENTO.equals((Object)contratoVendaAgendamento.getTipo())) {
            this.oAuth2Service.put("validar-paf-encerrar-contrato/" + contratoVendaAgendamento.getIdContrato(), null, Void.class);
        }
    }

    @RequestMapping(value={"/cancelar"})
    @DBTransaction
    public void cancelarAgendamento(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        ContratoVendaAgendamento contratoVendaAgendamento = (ContratoVendaAgendamento)ContratoVendaAgendamentoRN.getInstance().buscarPorId(id);
        if (contratoVendaAgendamento == null || contratoVendaAgendamento.isAplicado() || contratoVendaAgendamento.isCancelado()) {
            throw new UnicoMensagemUsuarioException("WWW229", "N\u00e3o \u00e9 poss\u00edvel executar esta opera\u00e7\u00e3o para o agendamento selecionado.");
        }
        ContratoVendaAgendamentoRN.getInstance().cancelarAgendamento(SessaoUtil.getSessao(), contratoVendaAgendamento);
    }

    protected String getCacheId() {
        return "contratos-agendados";
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        for (Object[] registro : dados) {
            Timestamp time = (Timestamp)registro[this.getIndexColuna("executarEm", colunas)];
            registro[this.getIndexColuna((String)"executarEm", colunas)] = Util.localDateTime2LocalDate((LocalDateTime)time.toLocalDateTime());
        }
    }

    protected GridBuilder<ContratoVendaAgendamentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nome", "usuarioSite", "Usu\u00e1rio site cadastro", 250, true, new String[]{"fk_contvendagend_ususite"}));
        colunas.add(new ColunaSQL("nome", "usuarioGnio", "Usu\u00e1rio sistema cadastro", 250, true, new String[]{"fk_contvendagend_usuario"}));
        colunas.add(new ColunaSQL("tipo", "Tipo", 120, true));
        colunas.add(new ColunaSQL("dataHoraRegistro", "Data cadastro", 120, true));
        colunas.add(new ColunaSQL("executarEm", "Data do bloqueio/encerramento", 200, true));
        colunas.add(new ColunaSQL("aplicado", "Aplicado", 100, true, EnumSimNao.class));
        colunas.add(new ColunaSQL("cancelado", "Cancelado", 100, true, EnumSimNao.class));
        colunas.add(new ColunaSQL("nome", "usuarioSiteCancelamento", "Usu\u00e1rio site cancelamento", 250, true, new String[]{"fk_contvendagend_usitecanc"}));
        colunas.add(new ColunaSQL("nome", "usuarioCancelamento", "Usu\u00e1rio G-nio cancelamento", 250, true, new String[]{"fk_contvendagend_usucanc"}));
        colunas.add(new ColunaSQL("dataHoraRegistroCancelamento", "Data cancelamento", 140, true));
        GridBuilder grid = new GridBuilder(((ContratoVendaAgendamentoRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idContrato"));
        grid.addReferenciaDefault(new Referencia("dataHoraRegistro"));
        grid.setOrdemDefault(new Ordem("dataHoraRegistro", true));
        return grid;
    }
}

