/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.pdv.comunicacao.sat;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.UnicoCrypt;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.web.rest.app.intelidata.pdv.comunicacao.ClientResponseWrapper;
import br.intelidata.uniplusweb.web.rest.app.intelidata.pdv.comunicacao.ResponseEntityWrapper;
import br.intelidata.uniplusweb.web.rest.app.intelidata.pdv.comunicacao.sat.AssinaturaAssociacaoSATWrapper;
import java.util.HashMap;
import org.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/assinaturas-sat"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Gerar assinatura de associa\u00e7\u00e3o do SAT", ROTA="/intelidata/assinaturas-sat", PROGRAMA=9000009)
public class AssinaturaAssociacaoSATSimpleController
extends SimpleController {
    private static final String PATH = "https://canal.intelidata.inf.brenviarassinaturasat";
    private ConnectionOAuth2Service oAuth2Service;

    public AssinaturaAssociacaoSATSimpleController(ConnectionOAuth2Service oAuth2Service) {
        this.oAuth2Service = oAuth2Service;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBAutoCommit
    public String gerarAssinatura(@RequestBody AssinaturaAssociacaoSATWrapper wrapper) throws UnicoMensagemUsuarioException {
        ResponseEntityWrapper entity;
        ClientResponseWrapper responseWrapper;
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(wrapper.getIdEntidade());
        if (entidade == null) {
            throw new UnicoMensagemUsuarioException("WWW230", "Revenda n\u00e3o encontrada.");
        }
        HashMap<String, String> send = new HashMap<String, String>();
        send.put("cnpj", wrapper.getCnpj());
        send.put("razaoSocial", wrapper.getRazaoSocial());
        send.put("email", entidade.getEmailTecnico());
        JSONObject elem = JSONUtil.getJSONObject(send);
        ResponseEntity response = this.oAuth2Service.post("enviarassinaturasat", elem, ClientResponseWrapper.class);
        if (response.getStatusCode() == HttpStatus.OK && (responseWrapper = (ClientResponseWrapper)response.getBody()) != null && (entity = (ResponseEntityWrapper)JsonUtil.fromJson((String)responseWrapper.getResponse().getEntity(), ResponseEntityWrapper.class)) != null) {
            return UnicoCrypt.decript((String)entity.getMensagem());
        }
        throw new UnicoMensagemUsuarioException("WWW236", "N\u00e3o foi poss\u00edvel consultar o servidor.");
    }
}

