/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.usuariosite;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.UsuarioSite;
import br.intelidata.commons.domain.pojo.UsuarioSiteRole;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.intelidata.regranegocio.UsuarioSiteRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.UsuarioSiteRoleRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/usuarios-site"})
public class UsuarioSiteCrudController
extends CrudController<UsuarioSite, UsuarioSiteRN> {
    private final ConnectionOAuth2Service oAuth2Service;

    public UsuarioSiteCrudController(ConnectionOAuth2Service oAuth2Service) {
        super((AbstractRegraNegocio)UsuarioSiteRN.getInstance(), UsuarioSite::new);
        this.dependsOn("idRevenda");
        this.oAuth2Service = oAuth2Service;
    }

    protected String getCacheId() {
        return "usuarios-site";
    }

    protected GridBuilder<UsuarioSiteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nome", "revendaNome", "Revenda", 250, true, new String[]{"fk_ususite_revenda"}));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("email", "E-mail", 0, true));
        GridBuilder grid = new GridBuilder(((UsuarioSiteRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idRevenda"));
        grid.setOrdemDefault(new Ordem("nome"));
        return grid;
    }

    protected void beforeRead(UsuarioSite usuarioSite, int modo, Optional<Long> parentId) {
        List roles = UsuarioSiteRoleRN.getInstance().buscarListaPorIdUsuarioSite(usuarioSite.getId());
        if (!ListMapUtil.listNullOrEmpty((List)roles)) {
            for (UsuarioSiteRole usuarioSiteRole : roles) {
                if (usuarioSiteRole.getNome().equalsIgnoreCase("ROLE_COMERCIAL")) {
                    usuarioSite.setComercial(true);
                    continue;
                }
                if (usuarioSiteRole.getNome().equalsIgnoreCase("ROLE_TECNICO")) {
                    usuarioSite.setTecnico(true);
                    continue;
                }
                if (usuarioSiteRole.getNome().equalsIgnoreCase("ROLE_ADMIN")) {
                    usuarioSite.setAdministrativo(true);
                    continue;
                }
                if (usuarioSiteRole.getNome().equalsIgnoreCase("ROLE_INTELIDATA")) {
                    usuarioSite.setIntelidata(true);
                    continue;
                }
                if (!usuarioSiteRole.getNome().equalsIgnoreCase("ROLE_CONTADOR")) continue;
                usuarioSite.setContador(true);
            }
        }
    }

    @DBTransaction
    public Long create(@RequestBody UsuarioSite usuarioSite, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        usuarioSite.setPassword(Integer.toString(new Random().nextInt(1000000000)));
        this.gravarUsuario(usuarioSite);
        this.gravarAuditoriaRegistro(null, (AbstractPojo)usuarioSite, 0);
        return 0L;
    }

    @DBTransaction
    public Long update(@RequestBody UsuarioSite usuarioSite, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.gravarAuditoriaRegistro(usuarioSite.getId(), (AbstractPojo)usuarioSite, 1);
        this.gravarUsuario(usuarioSite);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return 0L;
    }

    private void gravarUsuario(UsuarioSite usuarioSite) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)usuarioSite.getId())) {
            usuarioSite.setDataCriacao(DataHoraFactory.getDataHora());
            usuarioSite.setRole(this.getRolesPorUsuarioSite(usuarioSite));
        } else {
            usuarioSite.setDataAtualizacao(DataHoraFactory.getDataHora());
        }
        if (NumberUtil.longNullOuZero((Long)usuarioSite.getIdRevenda())) {
            throw new UnicoMensagemUsuarioException("WWW237", usuarioSite.isContador() ? "Contador n\u00e3o informado." : "Revenda n\u00e3o informada.");
        }
        if (!StringUtil.emailValido((String)usuarioSite.getEmail())) {
            throw new UnicoMensagemUsuarioException("WWW238", "E-mail inv\u00e1lido");
        }
        UsuarioSite usuarioEmail = UsuarioSiteRN.getInstance().buscarPorEmail(usuarioSite.getEmail());
        if (usuarioEmail != null && !usuarioEmail.getId().equals(usuarioSite.getId())) {
            throw new UnicoMensagemUsuarioException("WWW239", "E-mail j\u00e1 utilizado por outro usu\u00e1rio");
        }
        this.gravar(usuarioSite);
    }

    private List<UsuarioSiteRole> getRolesPorUsuarioSite(UsuarioSite usuarioSite) {
        ArrayList<UsuarioSiteRole> roles = new ArrayList<UsuarioSiteRole>();
        if (usuarioSite.isAdministrativo()) {
            roles.add(new UsuarioSiteRole("ROLE_ADMIN"));
        }
        if (usuarioSite.isComercial()) {
            roles.add(new UsuarioSiteRole("ROLE_COMERCIAL"));
        }
        if (usuarioSite.isTecnico()) {
            roles.add(new UsuarioSiteRole("ROLE_TECNICO"));
        }
        if (usuarioSite.isIntelidata()) {
            roles.add(new UsuarioSiteRole("ROLE_INTELIDATA"));
        }
        if (usuarioSite.isContador()) {
            roles.add(new UsuarioSiteRole("ROLE_CONTADOR"));
        }
        return roles;
    }

    private void gravar(UsuarioSite usuarioSite) throws UnicoMensagemUsuarioException {
        HashMap<String, Object> send = new HashMap<String, Object>();
        send.put("nome", usuarioSite.getNome());
        send.put("ativo", usuarioSite.isAtivo() ? 1 : 0);
        send.put("email", usuarioSite.getEmail());
        send.put("password", usuarioSite.getPassword());
        send.put("revenda", usuarioSite.getIdRevenda());
        send.put("pedirSenhaAoConfirmar", usuarioSite.isPedirSenhaAoConfirmar());
        send.put("administrativo", usuarioSite.isAdministrativo());
        send.put("comercial", usuarioSite.isComercial());
        send.put("tecnico", usuarioSite.isTecnico());
        send.put("intelidata", usuarioSite.isIntelidata());
        send.put("contador", usuarioSite.isContador());
        send.put("podeComprar", usuarioSite.isPodeComprar());
        send.put("podeVerContratos", usuarioSite.isPodeVerContratos());
        send.put("podeVerHistorico", usuarioSite.isPodeVerHistorico());
        send.put("podeVerEstoque", usuarioSite.isPodeVerEstoque());
        send.put("podeConfigUniplusWeb", usuarioSite.isPodeConfigUniplusWeb());
        send.put("cadastrandoPeloRetaguarda", true);
        JSONObject elem = JSONUtil.getJSONObject(send);
        ResponseEntity responseEntity = Util.longNullOuZero((Long)usuarioSite.getId()) ? this.oAuth2Service.post("usuario", elem, Void.class) : this.oAuth2Service.put("usuario/" + usuarioSite.getId(), elem, Void.class);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new UnicoMensagemUsuarioException("WWW310", "Retorno diferente de Ok, Verificar requisi\u00e7\u00e3o.");
        }
    }
}

