/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.venda.avaliacaorevenda;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.AvaliacaoCriterio;
import br.intelidata.commons.domain.pojo.AvaliacaoRevenda;
import br.intelidata.commons.domain.pojo.CriterioAvaliacao;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.AvaliacaoCriterioRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.AvaliacaoRevendaRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.CriterioAvaliacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/avaliacoes-revenda"})
public class AvaliacaoRevendaCrudController
extends SimpleCrudController<AvaliacaoRevenda, AvaliacaoRevendaRN> {
    @Autowired
    public AvaliacaoRevendaCrudController() {
        super((AbstractRegraNegocio)AvaliacaoRevendaRN.getInstance());
    }

    @DBAutoCommit
    public AvaliacaoRevenda get(Long parentId) {
        AvaliacaoRevenda avaliacaoRevenda = AvaliacaoRevendaRN.getInstance().buscarPorIdRevenda(parentId);
        if (avaliacaoRevenda == null) {
            avaliacaoRevenda = new AvaliacaoRevenda();
            avaliacaoRevenda.setIdRevenda(parentId);
        }
        List criterios = CriterioAvaliacaoRN.getInstance().buscarLista();
        criterios.sort(Comparator.comparing(CriterioAvaliacao::getOrdemClassificacao));
        avaliacaoRevenda.setCriterios(criterios);
        avaliacaoRevenda.setIdsCriteriosAvaliacao(AvaliacaoCriterioRN.getInstance().buscarPorIdRevenda(parentId).stream().map(AvaliacaoCriterio::getIdCriterioAvaliacao).collect(Collectors.toList()));
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(parentId);
        avaliacaoRevenda.setIdClassificacaoAtual(entidade.getIdClassificacaoCliente());
        Usuario avaliador = !NumberUtil.longNullOuZero((Long)avaliacaoRevenda.getIdAvaliador()) ? UsuarioRN.getInstance().buscarPorId(avaliacaoRevenda.getIdAvaliador()) : SessaoUtil.getSessao().getUsuario();
        avaliacaoRevenda.setNomeAvaliador(avaliador.getNome());
        Map valores = ContratoVendaRN.getInstance().buscarDadosParaAvaliacaoPorRevenda(parentId);
        avaliacaoRevenda.setQuantidadeContratoAberto(valores.getOrDefault("quantidade", 0));
        avaliacaoRevenda.setValorRecorrencia(valores.getOrDefault("valor", BigDecimal.ZERO));
        avaliacaoRevenda.setIdClassificacaoDisponivel(AvaliacaoRevendaRN.getInstance().calcularClassificacaoDisponivel(avaliacaoRevenda));
        return avaliacaoRevenda;
    }

    public void beforeSave(AvaliacaoRevenda avaliacao) {
        avaliacao.setIdAvaliador(SessaoUtil.getSessao().getIdUsuario());
        avaliacao.setDataUltimaAvaliacao(DataHoraFactory.getData());
    }

    @RequestMapping(value={"/calcular"}, method={RequestMethod.POST})
    @DBAutoCommit
    public Long calcularClassificacaoDisponivel(@RequestBody AvaliacaoRevenda avaliacao) {
        return AvaliacaoRevendaRN.getInstance().calcularClassificacaoDisponivel(avaliacao);
    }
}

