/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.centrocusto;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.financeiro.relatorio.CentroCustoRelatorio;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.centrocusto.CentroCustoReport;
import java.util.ArrayList;

public class CentroCustoReportExecuter
extends AbstractReporteExecute<CentroCustoReport> {
    public CentroCustoReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        CentroCustoReport fitaCaixa = (CentroCustoReport)this.fromJson(parametrosObj, CentroCustoReport.class);
        return this.executa(sessao, fitaCaixa);
    }

    public Remessa executa(Sessao sessao, CentroCustoReport parametros) throws UnicoMensagemUsuarioException {
        ArrayList<AbstractPojo> contas = new ArrayList<AbstractPojo>();
        if (!ListMapUtil.arrayNullOrEmpty((Object[])parametros.getIdsPlanoContas())) {
            for (Long idPlanoConta : parametros.getIdsPlanoContas()) {
                contas.add(HierarquiaPlanoContasRN.getInstance().buscarPorId(idPlanoConta));
            }
        }
        return new CentroCustoRelatorio().getRelatorio(parametros.getSaida(), parametros.getFiliais(), parametros.getEntradaInicio(), parametros.getEntradaFim(), parametros.getEmissaoInicio(), parametros.getEmissaoFim(), parametros.getVencimentoInicio(), parametros.getVencimentoFim(), parametros.getPagamentoInicio(), parametros.getPagamentoFim(), parametros.getIdCentroCusto(), contas, parametros.isDetalhado(), parametros.isMostrarDocumentosSubstituidos(), parametros.isVisualizarEmLinhas(), parametros.isMostrarCentroSemMovimentacao());
    }
}

