/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DRE;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DRECustoOperacional;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DREDespesaOperacional;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DREImposto;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DRERelatorio;
import br.intelidata.commons.modulo.vendas.regranegocio.DRERN;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre.Dre;

public class DreReportExecute
extends AbstractReporteExecute<Dre> {
    public DreReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        Dre parametros = (Dre)this.fromJson(parametrosObj, Dre.class);
        return this.executa(sessao, parametros);
    }

    public Remessa executa(Sessao sessao, Dre dre) throws UnicoMensagemUsuarioException {
        CustoMedioDiarioRN.getInstance().validarCustoMedio(dre.getTipoCalculoCusto(), dre.getPeriodoInicial(), dre.getPeriodoFinal(), dre.getFiliais());
        DRE dreGerado = DRERN.getInstance().montaDRE(SessaoUtil.getSessao(), dre.getFiliais(), dre.getPeriodoInicial(), dre.getPeriodoFinal(), null);
        dreGerado.carregarDados();
        for (DREDespesaOperacional despesa : dreGerado.getDespesasOperacionais().getListaDespesas()) {
            despesa.carregarPeriodos(dreGerado.getListaPeriodo());
        }
        for (DRECustoOperacional custo : dreGerado.getCustosOperacionais().getListaCustos()) {
            custo.carregarPeriodos(dreGerado.getListaPeriodo());
        }
        for (DREImposto imposto : dreGerado.getDeducoesReceitaBruta().getOutrosImpostos().getListaImpostos()) {
            imposto.carregarPeriodos(dreGerado.getListaPeriodo());
        }
        return new DRERelatorio().getRemessaDre(SessaoUtil.getSessao(), dreGerado, dre.getSaida(), dre.getFiliais(), dre.getPeriodoInicial(), dre.getPeriodoFinal(), false, false, false, false, false, false, false, false, false, false, false, false);
    }
}

