/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre2;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DRE2;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DRERelatorio2;
import br.intelidata.commons.modulo.vendas.regranegocio.DRE2RN;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre.Dre;

public class Dre2ReportExecute
extends AbstractReporteExecute<Dre> {
    public Dre2ReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        Dre parametros = (Dre)this.fromJson(parametrosObj, Dre.class);
        return this.executa(sessao, parametros);
    }

    public Remessa executa(Sessao sessao, Dre dre) throws UnicoMensagemUsuarioException {
        CustoMedioDiarioRN.getInstance().validarCustoMedio(dre.getTipoCalculoCusto(), dre.getPeriodoInicial(), dre.getPeriodoFinal(), dre.getFiliais());
        DRE2 dre2 = DRE2RN.getInstance().montaDRE(sessao, dre.getFiliais(), dre.getTipoCalculoCusto(), dre.getPeriodoInicial(), dre.getPeriodoFinal(), dre.isConsideraInativo(), dre.getTiposProduto(), dre.getModoCalculoDre(), null);
        dre2.setPossuiFilialSimplesNacional(dre.getFiliais().stream().anyMatch(Filial::isSimplesNacional));
        dre2.setPossuiFilialLucroRealPresumido(dre.getFiliais().stream().anyMatch(f -> !f.isSimplesNacional()));
        dre2.carregarDados();
        return new DRERelatorio2().getRemessaDre(dre2, dre.getSaida(), dre.getFiliais(), dre.getTipoCalculoCusto(), dre.getPeriodoInicial(), dre.getPeriodoFinal(), false, false, false, false, false, false, false, false, false);
    }
}

