/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.posicaofinanceiro;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.expedicao.Rota;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.RotaRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.BancoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.financeiro.relatorio.PosicaoFinanceiroRelatorio;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.posicaofinanceiro.PosicaoFinanceiro;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.posicaofinanceiro.TipoDocumentoRelatorioEnum;
import java.util.ArrayList;
import java.util.List;

public class PosicaoFinanceiroReportExecuter
extends AbstractReporteExecute<PosicaoFinanceiro> {
    public PosicaoFinanceiroReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        PosicaoFinanceiro posicaoFinanceiro = (PosicaoFinanceiro)this.fromJson(parametrosObj, PosicaoFinanceiro.class);
        return this.executa(sessao, posicaoFinanceiro);
    }

    public Remessa executa(Sessao sessao, PosicaoFinanceiro parametros) throws UnicoMensagemUsuarioException {
        ArrayList<AbstractPojo> filiais = new ArrayList<AbstractPojo>();
        for (Long id : parametros.getIdsFiliais()) {
            filiais.add(FilialRN.getInstance().buscarPorId(id));
        }
        boolean isPagar = parametros.getTipoDocumentoRelatorio().equalsIgnoreCase("P");
        Entidade cliente = !Util.longNullOuZero((Long)parametros.getIdCliente()) ? (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdCliente()) : null;
        Entidade vendedor = !Util.longNullOuZero((Long)parametros.getIdVendedor()) ? (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdVendedor()) : null;
        Banco banco = !Util.longNullOuZero((Long)parametros.getIdBanco()) ? (Banco)BancoRN.getInstance().buscarPorId(parametros.getIdBanco()) : null;
        Rota rota = !Util.longNullOuZero((Long)parametros.getIdRota()) ? (Rota)RotaRN.getInstance().buscarPorId(parametros.getIdRota()) : null;
        List planosContas = !Util.longNullOuZero((Long)parametros.getIdPlanoContas()) ? HierarquiaPlanoContasRN.getInstance().buscarHierarquiasFilhas(parametros.getIdPlanoContas()) : null;
        boolean statusQuitados = TipoDocumentoRelatorioEnum.QUITADOS.equals((Object)parametros.getTipoDocumento());
        boolean statusAbertos = TipoDocumentoRelatorioEnum.ABERTO.equals((Object)parametros.getTipoDocumento());
        List tiposDocumentos = null;
        if (parametros.isPosicaoCheque()) {
            tiposDocumentos = TipoDocumentoFinanceiroRN.getInstance().buscaTiposDocumentosComAcaoCheque();
        }
        return new PosicaoFinanceiroRelatorio().getRelatorio(parametros.getTipoDocumentoRelatorio(), parametros.getSaida(), parametros.getTituloRelatorio(), parametros.getDataRetroativa(), parametros.getColunaRetroativoPor(), filiais, tiposDocumentos, parametros.getModeloDocumento(), parametros.getEmissaoInicio(), parametros.getEmissaoFim(), parametros.getReferenciaInicio(), parametros.getReferenciaFim(), parametros.getDataVencimentoInicio(), parametros.getDataVencimentoFim(), parametros.getDataPagamentoInicio(), parametros.getDataPagamentoFim(), parametros.getDataBaixaInicio(), parametros.getDataBaixaFim(), parametros.getIdPlanoContas(), isPagar ? vendedor : cliente, isPagar ? cliente : vendedor, parametros.getIdTipoDocumento(), null, banco, planosContas, parametros.getDocumento(), parametros.getObs(), parametros.getAgencia(), parametros.getContaCorrente(), parametros.getCpfCnpjEmitente(), parametros.getNomeEmitente(), parametros.getValorInicial(), parametros.getValorFinal(), parametros.getSaldoInicial(), parametros.getSaldoFinal(), parametros.getPagoInicial(), parametros.getPagoFinal(), statusAbertos, statusQuitados, parametros.isSemAgrupar(), parametros.isAgruparEmissao(), parametros.isAgruparVencimento(), parametros.isAgruparCliente(), parametros.isAgruparVendedor(), parametros.isAgruparDocumento(), parametros.isIncluirProximasContas(), parametros.isIncluirEndereco(), parametros.isIncluirContasAnteriores(), parametros.isMostrarSubstituidos(), parametros.isOtimizarCliente(), parametros.isAgruparRota(), rota, parametros.isImprimirObs(), parametros.isAnalitico(), parametros.getContasCorrentes(), parametros.isCalcularJurosMultaDocumentosVencidos(), parametros.isAgruparPlanoContas(), parametros.isAgruparDataPagamento(), parametros.isAgruparFilial(), parametros.getIdListaEntidades());
    }
}

