/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.relatorioconfigurado;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JasperUtil;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.TipoExtensaoPlanilha;
import br.intelidata.commons.domain.pojo.enuns.TipoVariavelRelatorioConfigurado;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoWeb;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.SubRelatorioConfiguradoWeb;
import br.intelidata.commons.modulo.ferramentas.regranegocio.RelatorioConfiguradoWebRN;
import br.intelidata.commons.modulo.ferramentas.regranegocio.SubRelatorioConfiguradoWebRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.relatorio.RelatorioParametrosWrapper;
import br.intelidata.uniplusweb.web.rest.app.report.relatorioconfigurado.RelatorioConfigurado;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRFontNotFoundException;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class RelatorioConfiguradoReportExecuter
extends AbstractReporteExecute<RelatorioConfigurado> {
    public RelatorioConfiguradoReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametros) throws UnicoMensagemUsuarioException {
        RelatorioConfigurado relatorioConfigurado = (RelatorioConfigurado)this.fromJson(parametros, RelatorioConfigurado.class);
        assert (relatorioConfigurado != null);
        return this.executa(sessao, relatorioConfigurado);
    }

    public Remessa executa(Sessao sessao, RelatorioConfigurado wrapper) throws UnicoMensagemUsuarioException {
        RelatorioConfiguradoWeb relatorio = (RelatorioConfiguradoWeb)RelatorioConfiguradoWebRN.getInstance().buscarPorId(wrapper.getIdRelatorio());
        if (relatorio != null) {
            if (relatorio.isIreport()) {
                return this.gerarRelatorioIReport(wrapper, relatorio);
            }
            RelatorioParametrosWrapper parametros = (RelatorioParametrosWrapper)JsonUtil.fromJson((String)relatorio.getRelatorioSerializado(), RelatorioParametrosWrapper.class);
            if (parametros == null) {
                throw new UnicoMensagemUsuarioException("WWW286", "Os par\u00e2metros n\u00e3o foram configurados.");
            }
            return RelatorioConfiguradoWebRN.getInstance().gerarRelatorio(wrapper.getSaida(), relatorio, parametros.getColunas(), parametros.getReferencias(), parametros.getParametros(), parametros.getFiltros(), parametros.getOrdens(), wrapper.getParametros());
        }
        throw new UnicoMensagemUsuarioException("WWW287", "N\u00e3o foi poss\u00edvel localizar os par\u00e2metros do relat\u00f3rio.");
    }

    private Remessa gerarRelatorioIReport(RelatorioConfigurado wrapper, RelatorioConfiguradoWeb relatorio) throws UnicoMensagemUsuarioException {
        IConnectionHandler connectionHandler = (IConnectionHandler)BeanUtil.getBean((String)"connectionHandler");
        Map valores = wrapper.getParametros();
        this.converterValores(valores, relatorio);
        if (relatorio.getBytesRelatorio() == null) {
            throw new UnicoMensagemUsuarioException("WWW321", "O arquivo JRXML n\u00e3o foi definido. Verifique!");
        }
        Malote malote = new Malote();
        try {
            File file;
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)JRXmlLoader.load((InputStream)new ByteArrayInputStream(relatorio.getBytesRelatorio())));
            List subs = SubRelatorioConfiguradoWebRN.getInstance().buscarPorIdRelatorio(relatorio.getId());
            if (!ListMapUtil.listNullOrEmpty((List)subs)) {
                for (SubRelatorioConfiguradoWeb sub : subs) {
                    JasperReport jasperReportSubReport = JasperCompileManager.compileReport((JasperDesign)JRXmlLoader.load((InputStream)new ByteArrayInputStream(sub.getBytesRelatorio())));
                    valores.put(sub.getParametro(), jasperReportSubReport);
                }
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)valores, (Connection)connectionHandler.getConnection());
            String nome = StringUtil.removerAcentos((String)relatorio.getDescricao()).replace(" ", "_") + "_" + StringUtil.formataDataHora((Temporal)DataHoraFactory.getDataHora(), (String)"HH-mm-ss");
            if (wrapper.getSaidaRelatorio().equals((Object)SaidaRelatorio.HTML)) {
                file = File.createTempFile(nome, ".html");
                JasperExportManager.exportReportToHtmlFile((JasperPrint)jasperPrint, (String)file.getPath());
            } else if (wrapper.getSaidaRelatorio().equals((Object)SaidaRelatorio.EXCEL) || wrapper.getSaidaRelatorio().equals((Object)SaidaRelatorio.ARQUIVO_TEXTO_DELIMITADO) || wrapper.getSaidaRelatorio().equals((Object)SaidaRelatorio.ARQUIVO_TEXTO_FORMATADO)) {
                String extensao = wrapper.getSaidaRelatorio().equals((Object)SaidaRelatorio.EXCEL) ? wrapper.getExtensao().getExtensao() : ".txt";
                file = File.createTempFile(nome, extensao);
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    if (wrapper.getSaidaRelatorio().equals((Object)SaidaRelatorio.EXCEL)) {
                        if (TipoExtensaoPlanilha.XLSX.equals((Object)wrapper.getExtensao())) {
                            JasperUtil.exportarXLSX((JasperPrint)jasperPrint, (ByteArrayOutputStream)outputStream);
                        } else {
                            JasperUtil.exportarXLS((JasperPrint)jasperPrint, (ByteArrayOutputStream)outputStream);
                        }
                    } else {
                        JasperUtil.exportarTXT((JasperPrint)jasperPrint, (ByteArrayOutputStream)outputStream);
                    }
                    fileOutputStream.write(outputStream.toByteArray());
                    fileOutputStream.flush();
                }
            } else {
                file = File.createTempFile(nome, ".pdf");
                JasperUtil.exportarPDF((JasperPrint)jasperPrint, (String)file.getPath());
            }
            file.deleteOnExit();
            malote.incluiArquivo(wrapper.getSaidaRelatorio().getFormato(), file);
        }
        catch (JRFontNotFoundException fontEx) {
            Object fonte = "";
            Object[] split = fontEx.getMessage().split("\"");
            if (!ListMapUtil.arrayNullOrEmpty((Object[])split) && split.length > 1) {
                fonte = split[1];
            }
            throw new UnicoMensagemUsuarioException("WWW413", "A fonte " + (String)fonte + " n\u00e3o esta disponivel em ambiente linux, por favor considere troc\u00e1-la.", (Throwable)fontEx);
        }
        catch (IOException | JRException ex) {
            throw new UnicoMensagemUsuarioException("WWW414", "Erro ao gerar relat\u00f3rio!", ex);
        }
        return new Remessa(malote, wrapper.getExtensao());
    }

    private void converterValores(Map<String, Object> mapValores, RelatorioConfiguradoWeb relatorio) {
        RelatorioParametrosWrapper parametros = (RelatorioParametrosWrapper)JsonUtil.fromJson((String)relatorio.getRelatorioSerializado(), RelatorioParametrosWrapper.class);
        if (parametros != null && mapValores != null) {
            parametros.getParametros().stream().filter(parametro -> mapValores.containsKey(parametro.getParametro()) && parametro.getTipo() != null).forEach(parametro -> {
                Object valor = mapValores.get(parametro.getParametro());
                if (valor != null && !StringUtil.stringNullOrEmpty((String)valor.toString())) {
                    if (parametro.getTipo().equals((Object)TipoVariavelRelatorioConfigurado.DATA)) {
                        mapValores.put(parametro.getParametro(), DataHoraFactory.localDate2Date((LocalDate)Util.stringISO2LocalDateWeb((String)valor.toString())));
                    } else if (parametro.getTipo().equals((Object)TipoVariavelRelatorioConfigurado.DATA_HORA)) {
                        LocalDateTime dataHora = Util.stringISO2LocalDateTimeWeb((String)valor.toString());
                        Timestamp timestamp = Timestamp.valueOf(dataHora);
                        mapValores.put(parametro.getParametro(), timestamp);
                    } else if (parametro.getTipo().equals((Object)TipoVariavelRelatorioConfigurado.INTEIRO)) {
                        mapValores.put(parametro.getParametro(), Integer.parseInt(valor.toString()));
                    } else if (parametro.getTipo().equals((Object)TipoVariavelRelatorioConfigurado.LONG)) {
                        mapValores.put(parametro.getParametro(), Long.parseLong(valor.toString()));
                    } else if (parametro.getTipo().equals((Object)TipoVariavelRelatorioConfigurado.NUMERO)) {
                        mapValores.put(parametro.getParametro(), new BigDecimal(valor.toString()));
                    } else if (TipoVariavelRelatorioConfigurado.isCampoPrompt((String)parametro.getParametro()) && !parametro.getTipo().equals((Object)TipoVariavelRelatorioConfigurado.COMBO) && !parametro.getTipo().equals((Object)TipoVariavelRelatorioConfigurado.TEXTO) || parametro.getTipo().equals((Object)TipoVariavelRelatorioConfigurado.EMPRESA_FILIAL)) {
                        long id = Long.parseLong(valor.toString());
                        mapValores.put(parametro.getParametro(), NumberUtil.longNullOuZero((Long)id) ? null : Long.valueOf(id));
                    }
                }
            });
        }
    }
}

