/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.vendas.carteirapedidos;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.GradeValorRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.relatorio.CarteiraPedidosRelatorio;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.vendas.carteirapedidos.CarteiraPedidos;
import java.util.List;

public class CarteiraPedidosReportExecuter
extends AbstractReporteExecute<CarteiraPedidos> {
    public CarteiraPedidosReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        CarteiraPedidos carteira = (CarteiraPedidos)this.fromJson(parametrosObj, CarteiraPedidos.class);
        return this.executa(sessao, carteira);
    }

    public Remessa executa(Sessao sessao, CarteiraPedidos parametros) throws UnicoMensagemUsuarioException {
        Entidade cliente = !Util.longNullOuZero((Long)parametros.getIdCliente()) ? (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdCliente()) : null;
        Entidade vendedor = !Util.longNullOuZero((Long)parametros.getIdVendedor()) ? (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdVendedor()) : null;
        Entidade fornecedor = !Util.longNullOuZero((Long)parametros.getIdFornecedor()) ? (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdFornecedor()) : null;
        Produto produto = !Util.longNullOuZero((Long)parametros.getIdProduto()) ? (Produto)ProdutoRN.getInstance().buscarPorId(parametros.getIdProduto()) : null;
        List linhas = null;
        if (!ListMapUtil.listNullOrEmpty((List)parametros.getLinhas())) {
            linhas = GradeValorRN.getInstance().buscaPorIds(parametros.getLinhas());
        }
        List colunas = null;
        if (!ListMapUtil.listNullOrEmpty((List)parametros.getColunas())) {
            colunas = GradeValorRN.getInstance().buscaPorIds(parametros.getColunas());
        }
        if (parametros.isImprimirLucroBruto()) {
            parametros.setPaisagem(true);
        }
        return new CarteiraPedidosRelatorio().getRelatorio(sessao, parametros.getSaida(), parametros.getFiliais(), parametros.getInicio(), parametros.getFim(), parametros.getInicioEntrega(), parametros.getFimEntrega(), cliente, vendedor, fornecedor, produto, parametros.getIdTipoPedido(), parametros.getIdRota(), parametros.getIdPedido(), parametros.getStatus(), parametros.getAgrupamento(), parametros.isImprimirItens(), parametros.getIdHierarquia(), parametros.getOrdenacao(), parametros.getIdCondicaoPagamento(), parametros.getTipoRelatorio(), parametros.isImprimeInfoAdicionalItens(), parametros.isImprimirPesoPedidos(), parametros.isImprimirVariacoes(), parametros.isImprimirLucroBruto(), linhas, colunas, parametros.getTipoImpressao(), parametros.isImprimirEspacamentoAnotacoes(), parametros.getTipoEstoque());
    }
}

