/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.vendas.vendasporturno;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.relatorio.VendasPorTurnoRelatorio;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.vendas.vendasporturno.VendaPorTurno;
import java.util.HashMap;

public class VendaPorTurnoReportExecute
extends AbstractReporteExecute<VendaPorTurno> {
    public VendaPorTurnoReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        VendaPorTurno vendasServicoNoPeriodo = (VendaPorTurno)this.fromJson(parametrosObj, VendaPorTurno.class);
        return this.executa(sessao, vendasServicoNoPeriodo);
    }

    public Remessa executa(Sessao sessao, VendaPorTurno parametros) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(parametros.getIdProduto());
        HashMap<String, String> horas = new HashMap<String, String>();
        horas.put("primeiroTurnoHoraInicial", this.validarHora(parametros.getInicioPrimeiroTurno(), "In\u00edcio do primeiro turno"));
        horas.put("primeiroTurnoHoraFinal", this.validarHora(parametros.getFinalPrimeiroTurno(), "Fim do primeiro turno"));
        horas.put("segundoTurnoHoraInicial", this.validarHora(parametros.getInicioSegundoTurno(), "In\u00edcio do segundo turno"));
        horas.put("segundoTurnoHoraFinal", this.validarHora(parametros.getFinalSegundoTurno(), "Fim do segundo turno"));
        horas.put("terceiroTurnoHoraInicial", this.validarHora(parametros.getInicioTerceiroTurno(), "In\u00edcio do terceiro turno"));
        horas.put("terceiroTurnoHoraFinal", this.validarHora(parametros.getFinalTerceiroTurno(), "Fim do terceiro turno"));
        horas.put("quartoTurnoHoraInicial", this.validarHora(parametros.getInicioQuartoTurno(), "In\u00edcio do quarto turno"));
        horas.put("quartoTurnoHoraFinal", this.validarHora(parametros.getFinalQuartoTurno(), "Fim do quarto turno"));
        return new VendasPorTurnoRelatorio().getRelatorio(parametros.getSaida(), sessao.getFilial(), parametros.getDataInicio(), parametros.getDataFinal(), produto, parametros.getIdGrupoProduto(), parametros.getIdGrupoServico(), parametros.getModelo().getId().intValue(), horas);
    }

    private String validarHora(String strHora, String descricao) throws UnicoMensagemUsuarioException {
        if (strHora != null && strHora.contains(":")) {
            String hora = strHora.split(":")[0];
            String minuto = strHora.split(":")[1];
            if (Util.string2int((String)hora) > 0 || Util.string2int((String)minuto) > 0) {
                if (Util.string2int((String)hora) > 23) {
                    throw new UnicoMensagemUsuarioException("VND33", descricao + " inv\u00e1lido! Verifique.");
                }
                if (Util.string2int((String)minuto) > 59) {
                    throw new UnicoMensagemUsuarioException("VND34", descricao + " inv\u00e1lido! Verifique.");
                }
                return strHora;
            }
        }
        return "";
    }
}

