/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.util.widgets;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.WebWidgetConfig;
import br.intelidata.commons.domain.pojo.Widget;
import br.intelidata.commons.domain.pojo.WidgetDados;
import br.intelidata.commons.modulo.cadastros.regranegocio.WebWidgetConfigRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.WidgetDadosRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.WidgetRN;
import br.intelidata.uniplusweb.web.rest.BaseController;
import br.intelidata.uniplusweb.web.rest.app.util.widgets.WidgetsController;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.util.SerializationUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WidgetsController
extends BaseController {
    @RequestMapping(path={"/api/widgets"}, method={RequestMethod.GET})
    public List<WebWidgetConfig> getWebWidgetsUsuario() {
        Long idUsuario = SessaoUtil.getSessao().getIdUsuario();
        return WebWidgetConfigRN.getInstance().buscaPorIdUsuario(idUsuario);
    }

    @RequestMapping(path={"/api/widgets"}, method={RequestMethod.POST})
    public Long create(@RequestBody WebWidgetConfig webWidgetConfig) throws UnicoMensagemUsuarioException {
        Long idUsuario = SessaoUtil.getSessao().getIdUsuario();
        webWidgetConfig.setIdUsuario(idUsuario);
        Long result = WebWidgetConfigRN.getInstance().gravar(0, (AbstractPojo)webWidgetConfig, SessaoUtil.getSessao());
        return result;
    }

    @RequestMapping(path={"/api/widgets/{id}"}, method={RequestMethod.PUT})
    public Long update(@RequestBody WebWidgetConfig webWidgetConfig) throws UnicoMensagemUsuarioException {
        Long idUsuario = SessaoUtil.getSessao().getIdUsuario();
        webWidgetConfig.setIdUsuario(idUsuario);
        Long result = WebWidgetConfigRN.getInstance().gravar(1, (AbstractPojo)webWidgetConfig, SessaoUtil.getSessao());
        return result;
    }

    @RequestMapping(path={"/api/widgets/{id}"}, method={RequestMethod.DELETE})
    public Long delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        WebWidgetConfig webWidgetConfig = (WebWidgetConfig)WebWidgetConfigRN.getInstance().buscarPorId(id);
        if (webWidgetConfig == null) {
            throw new UnicoMensagemUsuarioException("WWW17", "Widget n\u00e3o encontrado");
        }
        Long idUsuario = SessaoUtil.getSessao().getIdUsuario();
        if (!webWidgetConfig.getIdUsuario().equals(idUsuario)) {
            throw new UnicoMensagemUsuarioException("WWW24", "Widget n\u00e3o autorizado");
        }
        WebWidgetConfigRN.getInstance().gravar(2, (AbstractPojo)webWidgetConfig, SessaoUtil.getSessao());
        return id;
    }

    @RequestMapping(path={"/api/widgets/app-widgets"})
    public ResponseEntity<String> getAppWidgets() {
        StringBuilder json = new StringBuilder();
        json.append("[");
        for (Widget widget : WidgetRN.getInstance().buscarLista()) {
            Object[][] dados;
            WidgetDados widgetDados = WidgetDadosRN.getInstance().buscarPorIdWidget(widget.getId());
            if (widgetDados == null || widgetDados.getDados() == null || (dados = (Object[][])SerializationUtils.deserialize((byte[])widgetDados.getDados())) == null || dados.length == 0) continue;
            if (json.length() > 1) {
                json.append(",");
            }
            json.append(this.getWidgetJSON(widget));
        }
        json.append("]");
        return this.createJSONResponse(json.toString());
    }

    @RequestMapping(path={"/api/widgets/app-widgets/{id}"})
    public ResponseEntity<String> getAppWidget(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        Widget widget = (Widget)WidgetRN.getInstance().buscarPorId(id);
        if (widget == null) {
            throw new UnicoMensagemUsuarioException("WWW16", "Widget n\u00e3o encontrado");
        }
        String json = this.getWidgetJSON(widget);
        return this.createJSONResponse(json.toString());
    }

    @RequestMapping(path={"/api/widgets/app-widgets/{id}/data"})
    public ResponseEntity<String> getAppWidgetData(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        Widget widget = (Widget)WidgetRN.getInstance().buscarPorId(id);
        if (widget == null) {
            throw new UnicoMensagemUsuarioException("WWW15", "Widget n\u00e3o encontrado");
        }
        WidgetDados widgetDados = WidgetDadosRN.getInstance().buscarPorIdWidget(widget.getId());
        if (widgetDados == null || widgetDados.getDados() == null) {
            return this.createJSONResponse("{}");
        }
        String json = "";
        Object[][] dados = (Object[][])SerializationUtils.deserialize((byte[])widgetDados.getDados());
        if (dados != null) {
            json = "{".concat(this.getJSONDados(dados)).concat("}");
        }
        return this.createJSONResponse(json.toString());
    }

    @RequestMapping(path={"/b2b/widgets"}, method={RequestMethod.POST})
    public boolean saveData(@RequestBody WidgetDados widgetDados) throws UnicoMensagemUsuarioException {
        Widget widgetGravado = widgetDados.getWidget();
        WidgetRN.getInstance().incluirOuAlterar(widgetGravado, null);
        WidgetDadosRN.getInstance().incluirOuAlterar(widgetGravado.getId(), widgetDados.getDados(), null);
        return true;
    }

    private String getWidgetJSON(Widget widget) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"id\"").append(":").append("\"" + widget.getId() + "\"");
        json.append(",\"titulo\"").append(":").append("\"" + widget.getTitulo() + "\"");
        json.append(",\"widget\"").append(":").append("\"" + widget.getTipo().getId() + "\"");
        json.append(",\"type\"").append(":").append("\"" + widget.getTipoGrafico().getId() + "\"");
        json.append(",").append(this.getWidgetLabels(widget));
        json.append("}");
        return json.toString();
    }

    private String getJSONDados(Object[][] dados) {
        int i;
        StringBuilder json = new StringBuilder();
        json.append("\"xAxis\"").append(":[");
        for (i = 0; i < dados.length; ++i) {
            json.append("\"" + dados[i][0] + "\"");
            if (i + 1 >= dados.length) continue;
            json.append(",");
        }
        json.append("]");
        json.append(",\"yAxis\"").append(":[");
        for (i = 0; i < dados.length; ++i) {
            json.append("\"" + dados[i][1] + "\"");
            if (i + 1 >= dados.length) continue;
            json.append(",");
        }
        json.append("]");
        return json.toString();
    }

    private String getWidgetLabels(Widget widget) {
        String labelJson = "\"xLabel\": \"{[x]}\", \"yLabel\": \"{[y]}\"";
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoWidget[widget.getTipo().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoGrafico[widget.getTipoGrafico().ordinal()]) {
                    case 1: {
                        labelJson = labelJson.replace("{[x]}", "Documento").replace("{[y]}", "Valor");
                        return labelJson;
                    }
                    case 2: {
                        labelJson = labelJson.replace("{[x]}", "Hor\u00e1rio").replace("{[y]}", "Valor");
                        return labelJson;
                    }
                }
                return null;
            }
            case 5: {
                switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoGrafico[widget.getTipoGrafico().ordinal()]) {
                    case 1: 
                    case 2: {
                        labelJson = labelJson.replace("{[x]}", "Tipo").replace("{[y]}", "Valor");
                        return labelJson;
                    }
                }
                return null;
            }
            case 6: {
                switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoGrafico[widget.getTipoGrafico().ordinal()]) {
                    case 3: {
                        labelJson = labelJson.replace("{[x]}", "Produtos").replace("{[y]}", "Quantidade");
                        return labelJson;
                    }
                }
                return null;
            }
            case 7: 
            case 8: {
                switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoGrafico[widget.getTipoGrafico().ordinal()]) {
                    case 2: 
                    case 4: {
                        labelJson = labelJson.replace("{[x]}", "Dia").replace("{[y]}", "Total");
                        return labelJson;
                    }
                }
                return null;
            }
            case 9: {
                switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoGrafico[widget.getTipoGrafico().ordinal()]) {
                    case 4: {
                        labelJson = labelJson.replace("{[x]}", "Hora").replace("{[y]}", "Valor");
                        return labelJson;
                    }
                    case 2: {
                        labelJson = labelJson.replace("{[x]}", "Hora").replace("{[y]}", "Valor");
                        return labelJson;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

