/*
 * Decompiled with CFR 0.152.
 */
package updater;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private static final String SERVICE = "UnipluswebServer";
    private static final boolean isLinux = System.getProperty("os.name", "").toLowerCase().startsWith("linux");
    private static Logger log;

    public static boolean startService() throws Exception {
        return Util.execCmd(isLinux ? "sudo systemctl start app.service" : "net start UnipluswebServer") == 0;
    }

    public static boolean stopService() throws Exception {
        Util.execCmd(isLinux ? "sudo systemctl stop app.service" : "net stop UnipluswebServer");
        return Util.esperaAte(SERVICE, false);
    }

    private static int execCmd(String cmdLine) throws Exception {
        return Util.execCmd(cmdLine, true);
    }

    private static int execCmd(String cmdLine, boolean esperar) throws Exception {
        log.info(cmdLine);
        Process process = Runtime.getRuntime().exec(cmdLine);
        StreamPumper outPumper = new StreamPumper(process.getInputStream());
        StreamPumper errPumper = new StreamPumper(process.getErrorStream());
        if (esperar) {
            outPumper.start();
            errPumper.start();
            process.waitFor();
            outPumper.join();
            errPumper.join();
            return process.exitValue();
        }
        return 0;
    }

    private static String execCmdStr(String cmdLine) throws Exception {
        Process process = Runtime.getRuntime().exec(cmdLine);
        StreamPumper outPumper = new StreamPumper(process.getInputStream());
        StreamPumper errPumper = new StreamPumper(process.getErrorStream());
        outPumper.start();
        errPumper.start();
        process.waitFor();
        outPumper.join();
        errPumper.join();
        return outPumper.buffer;
    }

    private static boolean esperaAte(String serviceName, boolean running) throws Exception {
        long inicio = System.currentTimeMillis();
        boolean sucesso = false;
        while (System.currentTimeMillis() - inicio < 30000L && !sucesso) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException localInterruptedException) {
                sucesso = false;
            }
            sucesso = Util.runningService(serviceName) == running;
        }
        return sucesso;
    }

    private static boolean runningService(String serviceName) throws Exception {
        if (isLinux) {
            String saida = Util.execCmdStr("sudo systemctl status app.service");
            return saida.indexOf("active (exited)") > -1;
        }
        String saida = Util.execCmdStr("sc query " + serviceName);
        return saida.indexOf("RUNNING") > -1;
    }

    public static boolean isIsLinux() {
        return isLinux;
    }

    public static void setLog(Logger log) {
        Util.log = log;
    }

    public static void salvarParametros(String param1, String param2) {
        try {
            Path path = Paths.get("web-updater.conf", new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, (param1 + Util.newLine()).getBytes(), StandardOpenOption.APPEND, StandardOpenOption.WRITE);
            if (param2 != null) {
                Files.write(path, (param2 + Util.newLine()).getBytes(), StandardOpenOption.APPEND, StandardOpenOption.WRITE);
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Erro ao salvar parametros", e);
        }
    }

    public static List<String> lerParametros() {
        try {
            Path path = Paths.get("web-updater.conf", new String[0]);
            return Files.readAllLines(path);
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Erro ao salvar parametros", e);
            return null;
        }
    }

    public static boolean existeArquivoParametros() {
        return Files.exists(Paths.get("web-updater.conf", new String[0]), new LinkOption[0]);
    }

    public static boolean deleteArquivoParametros() throws Exception {
        return Files.deleteIfExists(Paths.get("web-updater.conf", new String[0]));
    }

    public static boolean startServiceUpdater() throws Exception {
        return Util.execCmd("sudo systemctl start app-updater.service") == 0;
    }

    public static String newLine() {
        return "\r\n";
    }

    private static class StreamPumper
    extends Thread {
        private InputStream is;
        private String buffer;

        public StreamPumper(InputStream is) {
            this.is = is;
            this.buffer = "";
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    this.buffer = this.buffer + line;
                }
            }
            catch (Exception localException) {
                return;
            }
        }
    }
}

