/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb;

import br.intelidata.commons.bridge.ServerStartupMonitor;
import br.intelidata.commons.core.sql.SGBD;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.spring.LocalDateConverter;
import br.intelidata.uniplusweb.core.spring.LocalDateTimeConverter;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import unicoweb.ConfiguraWeb;

@SpringBootApplication(exclude={FreeMarkerAutoConfiguration.class})
@EnableScheduling
@ServletComponentScan
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={UnipluswebProperties.class})
@ComponentScan(value={"br.intelidata"})
public class Application
extends WebMvcConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        ConfiguraWeb.setup((SGBD)SGBD.POSTGRES);
        ServerStartupMonitor.setIniciado((boolean)false);
        Locale.setDefault(new Locale("pt", "BR"));
        try {
            SpringApplication app = new SpringApplication(new Class[]{Application.class});
            app.run(args).getEnvironment();
        }
        catch (Exception e) {
            log.error("Erro ao iniciar a aplica\u00e7\u00e3o", (Throwable)e);
        }
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new LocalDateConverter("yyyy-MM-dd"));
        registry.addConverter((Converter)new LocalDateTimeConverter("yyyy-MM-dd'T'HH:mm:ss.SSSz"));
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String diretorioStatic = System.getProperty("user.dir") + "/fileserver/";
        log.info("Servido conte\u00fado est\u00e1tico em {}", (Object)diretorioStatic);
        registry.addResourceHandler(new String[]{"/fileserver/**"}).addResourceLocations(new String[]{"file:///" + diretorioStatic});
    }
}

