/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.config;

import br.intelidata.uniplusweb.config.UnipluswebProperties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class AsyncConfiguration
implements AsyncConfigurer {
    private final Logger log = LoggerFactory.getLogger(AsyncConfiguration.class);
    @Autowired
    private UnipluswebProperties unipluswebProperties;

    @Bean(name={"taskExecutor"})
    public Executor getAsyncExecutor() {
        this.log.debug("Criando Async Task Executor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.unipluswebProperties.getAsync().getCorePoolSize());
        executor.setMaxPoolSize(this.unipluswebProperties.getAsync().getMaxPoolSize());
        executor.setQueueCapacity(this.unipluswebProperties.getAsync().getQueueCapacity());
        executor.setThreadNamePrefix("uniplusweb-Executor-");
        executor.initialize();
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }
}

