/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.grid;

import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.grid.GridTree;
import java.util.List;

public class GridHierarquia<RN extends AbstractRegraNegocio<?, ?>>
extends GridTree<RN> {
    public GridHierarquia(GridBuilder<RN> gridBuilder) {
        super(gridBuilder);
    }

    protected void configuraGridControler(int paginaInicial, int tamanhoPagina, String query, List<FilterField> filters, String parent, List<CustomFilterGrid> customFilters) {
        int itemInicial = (paginaInicial - 1) * tamanhoPagina;
        this.getGridBuilder().setPaginaAtual(itemInicial);
        this.getGridBuilder().setQuantidadeRegistroPorPagina(tamanhoPagina);
        this.getGridBuilder().limparCondicoes();
        this.filtro(filters);
        if (query == null || query.isEmpty()) {
            this.parent(parent);
            this.getGridBuilder().limparCondicoesPesquisaRapida();
        } else {
            this.parentWithQuery(parent);
            this.getGridBuilder().limparCondicoesPesquisaRapida();
            if (parent == null) {
                this.trataPesquisaRapida(query);
            }
        }
    }

    private void parentWithQuery(String parent) {
        if (parent != null) {
            this.getGridBuilder().addCondicao(new Condicao("codigo", Operador.COMECE_COM, parent));
            this.getGridBuilder().addReferencia(new Referencia(Funcao.LENGTH, "codigo", "ref", new Object[0]));
            this.getGridBuilder().addCondicao(new Condicao("ref", Operador.IGUAL, parent.length() + 6));
        }
    }

    protected String getNomeColunaNivel() {
        return "nivel";
    }

    protected String getNomeColunaDescricao() {
        return "nome";
    }

    protected boolean isPrincipal(Object[] linha) {
        return linha[this.getIndexColuna("codigo", this.getColunasSql())].toString().length() == 6;
    }

    protected boolean isFilhoDe(Object[] linha1, Object[] linha2) {
        int idxCodigo = this.getIndexColuna("codigo", this.getColunasSql());
        String v1 = linha1[idxCodigo].toString();
        String v2 = linha2[idxCodigo].toString();
        return v2.startsWith(v1) && v2.length() == v1.length() + 6;
    }
}

