/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.grid;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.Grid;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.print.SaidaImpressaoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class GridTree<RN extends AbstractRegraNegocio<?, ?>>
extends Grid<RN> {
    public GridTree(GridBuilder<RN> gridBuilder) {
        super(gridBuilder);
    }

    protected void exportarDados(SaidaImpressaoWrapper saidaImpressaoWrapper, List<Object[]> dados, UViewer uViewer) {
        int idxNivel = this.getIndexColuna(this.getNomeColunaNivel(), this.getColunasSql());
        for (Object[] linha : dados) {
            this.gerarLinhas(saidaImpressaoWrapper, uViewer, idxNivel, linha);
        }
    }

    private void gerarLinhas(SaidaImpressaoWrapper saidaImpressaoWrapper, UViewer uViewer, int idxNivel, Object[] dadosLinha) {
        uViewer.inicioLinha();
        int col = 0;
        String sufixo = saidaImpressaoWrapper.getSaidaRelatorio().getSaida() == 0 ? "---" : "   ";
        for (int i = 0; i < this.getColunasSql().size(); ++i) {
            ColunaSQL colunaSQL = (ColunaSQL)this.getColunasSql().get(i);
            if (!colunaSQL.isVisivel()) continue;
            Object dado = dadosLinha[i];
            if (dado == null) {
                uViewer.escreveColuna("");
            } else if (colunaSQL.getClasseEnum() != null) {
                String valorEnum = "";
                for (Object enumConstant : colunaSQL.getClasseEnum().getEnumConstants()) {
                    if (!((Enum)enumConstant).name().equalsIgnoreCase(dado.toString())) continue;
                    valorEnum = enumConstant.toString();
                    break;
                }
                uViewer.escreveColuna(valorEnum);
            } else if (dado instanceof Number) {
                BigDecimal valorBigDecimal = dado instanceof BigDecimal ? (BigDecimal)dado : NumberUtil.toBigDecimal((Object)dado);
                if (valorBigDecimal != null && valorBigDecimal.scale() > 6) {
                    valorBigDecimal = valorBigDecimal.setScale(6, RoundingMode.HALF_EVEN);
                }
                uViewer.escreveColuna(valorBigDecimal);
            } else if (dado instanceof Date) {
                uViewer.escreveColuna(DateUtil.date2String((java.util.Date)((java.util.Date)dado)));
            } else {
                String valor;
                if (col == 0) {
                    int nivel = (Integer)dadosLinha[idxNivel];
                    valor = StringUtil.replicate((String)sufixo, (int)(nivel - 1)) + dado;
                } else {
                    valor = (String)dado;
                }
                uViewer.escreveColuna(valor);
            }
            ++col;
        }
        uViewer.fimLinha();
    }

    public List<Object[]> getDadosWeb(int paginaInicial, int tamanhoPagina, String query, String parent, List<FilterField> filters, List<CustomFilterGrid> customFilters) {
        List dados = super.getDadosWeb(paginaInicial, tamanhoPagina, "", parent, filters, customFilters);
        if (!StringUtil.stringNullOrEmpty((String)query)) {
            dados = dados.stream().map(obj -> Arrays.copyOf(obj, ((Object[])obj).length + 1)).collect(Collectors.toList());
            List pais = dados.stream().filter(arg_0 -> this.isPrincipal(arg_0)).collect(Collectors.toList());
            for (Object[] pai : pais) {
                pai[pai.length - 1] = this.getFilhos(dados, pai);
            }
            int idxNome = this.getIndexColuna(this.getNomeColunaDescricao(), this.getColunasSql());
            List dadosFiltrados = this.filtrarDados(pais, query, idxNome);
            return this.flatDados(dadosFiltrados);
        }
        return dados;
    }

    private List<Object[]> getFilhos(List<Object[]> dados, Object[] pai) {
        ArrayList<Object[]> filhos = new ArrayList<Object[]>();
        for (Object[] dado : dados) {
            if (!this.isFilhoDe(pai, dado)) continue;
            dado[dado.length - 1] = this.getFilhos(dados, dado);
            filhos.add(dado);
        }
        return filhos;
    }

    private List<Object[]> filtrarDados(List<Object[]> dados, String query, int idxNome) {
        ArrayList<Object[]> retorno = new ArrayList<Object[]>();
        for (Object[] dado : dados) {
            List filhosFiltrados;
            if (dado[idxNome].toString().toLowerCase().contains(query.toLowerCase())) {
                retorno.add(dado);
                continue;
            }
            if (ListMapUtil.listNullOrEmpty((List)((List)dado[dado.length - 1])) || ListMapUtil.listNullOrEmpty((List)(filhosFiltrados = this.filtrarDados((List)dado[dado.length - 1], query, idxNome)))) continue;
            dado[dado.length - 1] = filhosFiltrados;
            retorno.add(dado);
        }
        return retorno;
    }

    public List<Object[]> flatDados(List<Object[]> dados) {
        ArrayList<Object[]> retorno = new ArrayList<Object[]>();
        for (Object[] dado : dados) {
            retorno.add(dado);
            if (ListMapUtil.listNullOrEmpty((List)((List)dado[dado.length - 1]))) continue;
            retorno.addAll(this.flatDados((List)dado[dado.length - 1]));
        }
        return retorno;
    }

    protected abstract String getNomeColunaNivel();

    protected abstract String getNomeColunaDescricao();

    protected abstract boolean isPrincipal(Object[] var1);

    protected abstract boolean isFilhoDe(Object[] var1, Object[] var2);
}

