/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.DicionarioDados;
import br.intelidata.commons.core.sql.SenhaBanco;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.LogSistema;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.util.agendador.ProcessBuilderWrapper;
import br.intelidata.commons.domain.pojo.Controle;
import br.intelidata.commons.domain.pojo.EventoSistema;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.CategoriaEventoSistema;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EventoSistemaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.ferramentas.agendamento.regranegocio.BackupAgendadoRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.wrapper.PreferenciasBackupWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BackupService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String[] COMANDOS_BASICOS;
    private final String DIRETORIO_BACKUP;
    private final StorageService storageService;
    private final UnipluswebProperties unipluswebProperties;
    private final IConnectionHandler connectionHandler;
    private final NotificationService notificationService;

    public BackupService(StorageService storageService, UnipluswebProperties unipluswebProperties, IConnectionHandler connectionHandler, NotificationService notificationService) {
        File file;
        String[] stringArray;
        if (SystemUtil.isLinux()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "/bin/sh";
            stringArray = stringArray2;
            stringArray2[1] = "-c";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "cmd.exe";
            stringArray = stringArray3;
            stringArray3[1] = "/c";
        }
        this.COMANDOS_BASICOS = stringArray;
        this.DIRETORIO_BACKUP = SystemUtil.getDiretorioAplicacao() + File.separator + "backup";
        this.storageService = storageService;
        this.unipluswebProperties = unipluswebProperties;
        this.connectionHandler = connectionHandler;
        this.notificationService = notificationService;
        if (this.unipluswebProperties.getAmbiente().isLocal() && !(file = new File(SystemUtil.getDiretorioAplicacao() + File.separator + "backup")).exists() && !file.mkdir()) {
            this.log.error("N\u00e3o foi poss\u00edvel criar o diret\u00f3rio de backup");
        }
    }

    public void backupLocal(String database, String host) throws UnicoMensagemUsuarioException {
        ProcessBuilderWrapper processBuilder;
        Sessao sessao = SessaoUtil.getSessao();
        PreferenciasBackupWrapper preferencia = this.carregarPreferencias(sessao);
        boolean ignoraUltimoTamanhoBackup = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 742);
        boolean isLinux = SystemUtil.isLinux();
        String pg = isLinux ? "/usr/bin/pg_dump " : "pg_dump.exe ";
        String nomeArquivo = this.getNomeArquivo(ContextoHolder.getTenant(), preferencia.isDataHora(), preferencia.isRazaoSocial());
        File backup = new File(this.DIRETORIO_BACKUP + File.separator + nomeArquivo + ".backup");
        if (backup.exists() && !backup.delete()) {
            this.log.error("N\u00e3o foi poss\u00edvel deletar o arquivo de backup existente.");
            throw new UnicoException("WWW380", "N\u00e3o foi poss\u00edvel deletar o arquivo de backup existente.");
        }
        String variaveisAmbiente = "PGPASSWORD=" + new SenhaBanco().getPwd();
        String comadoExcluirAuditoria = "";
        if (preferencia.isExclusaoAuditoria()) {
            comadoExcluirAuditoria = " --exclude-table-data=auditoria --exclude-table-data=auditoriacampo --exclude-table-data=auditoriaregistro --exclude-table-data=auditoriaregistroresumo --exclude-table-data=replicadorlog";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry visao : DicionarioDados.getInstance().getVisoes().entrySet()) {
            sb.append(" --exclude-table=").append((String)visao.getKey());
        }
        Object[] comando = new String[]{pg + " --file \"" + backup.getAbsolutePath() + "\" --host \"" + host + "\" --port \"5432\" --username uniplus-task" + comadoExcluirAuditoria + sb + " --verbose --format=c --blobs \"" + database + "\""};
        File directory = backup.getParentFile();
        if (!isLinux) {
            String diretorioPG = this.unipluswebProperties.getBancoDados().getDiretorio();
            if (!SystemUtil.isExisteInstalacaoPostgresOuCaminhoConfigurado((String)diretorioPG)) {
                String mensagem = "N\u00e3o foi poss\u00edvel executar o backup. Verifique o diret\u00f3rio configurado para o Banco de Dados.";
                this.gravaEventoSistema(sessao, mensagem, false);
                this.log.error(mensagem);
                this.notificationService.notityUsersAdministrator(TipoNotificacaoSimples.ERROR, ContextoHolder.getTenant(), mensagem);
                throw new UnicoMensagemUsuarioException("WWW676", mensagem);
            }
            this.log.info("Diret\u00f3rio do PG: " + SystemUtil.getDiretorioPostgres((String)diretorioPG));
            directory = new File(SystemUtil.getDiretorioPostgres((String)diretorioPG));
        }
        this.log.info("Executando backup no " + (isLinux ? "Linux" : "Windows") + " com os seguintes comandos: {}", (Object)String.join((CharSequence)" ", (CharSequence[])ArrayUtils.addAll((Object[])this.COMANDOS_BASICOS, (Object[])comando)));
        this.connectionHandler.releaseConnection();
        try {
            processBuilder = new ProcessBuilderWrapper(directory, Arrays.asList(ArrayUtils.addAll((Object[])this.COMANDOS_BASICOS, (Object[])comando)), new String[]{variaveisAmbiente});
        }
        catch (Exception e) {
            if (!backup.delete()) {
                backup.deleteOnExit();
            }
            this.log.error("N\u00e3o foi poss\u00edvel executar o backup.", (Throwable)e);
            this.gravaEventoSistema(sessao, "N\u00e3o foi poss\u00edvel executar o backup: " + e.getMessage(), false);
            throw new UnicoMensagemUsuarioException("WWW677", "N\u00e3o foi poss\u00edvel executar o backup.", (Throwable)e);
        }
        this.log.info("Executando VACCUM");
        this.vacuum();
        this.log.info("Finalizando processo de backup.");
        Long tamanhoBackup = backup.length();
        boolean sucesso = processBuilder.getStatus() == 0 && !NumberUtil.longNullOuZero((Long)tamanhoBackup);
        this.validacoesAposBackup(sessao, preferencia.isConsiderarTamanhoMenorErro(), ignoraUltimoTamanhoBackup, processBuilder, tamanhoBackup, sucesso, true);
    }

    public boolean backupAmazon(String tenant, String database, String ambiente, String host, String username, String password) throws UnicoMensagemUsuarioException {
        boolean sucesso;
        Sessao sessao = SessaoUtil.getSessao();
        PreferenciasBackupWrapper preferencia = this.carregarPreferencias(sessao);
        boolean ignoraUltimoTamanhoBackup = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 742);
        File backup = null;
        try {
            String nomeArquivo = this.getNomeArquivo(ContextoHolder.getTenant(), preferencia.isDataHora(), preferencia.isRazaoSocial());
            backup = File.createTempFile("backup", ".backup");
            File directory = backup.getParentFile();
            String variaveisAmbiente = "PGPASSWORD=" + password;
            Object[] comando = new String[]{"/usr/bin/pg_dump --file \"" + backup.getAbsolutePath() + "\" --host \"" + host + "\" --port \"5432\" --username \"" + username + "\" --verbose --format=c --blobs \"" + database + "\""};
            this.log.info("Executando backup com os seguintes comandos: {}", (Object)comando[0]);
            this.connectionHandler.releaseConnection();
            ProcessBuilderWrapper processBuilder = new ProcessBuilderWrapper(directory, Arrays.asList(ArrayUtils.addAll((Object[])this.COMANDOS_BASICOS, (Object[])comando)), new String[]{variaveisAmbiente});
            this.log.info("Executando VACCUM");
            this.vacuum();
            Long tamanhoBackup = backup.length();
            boolean bl = sucesso = processBuilder.getStatus() == 0 && !NumberUtil.longNullOuZero((Long)tamanhoBackup);
            if (sucesso) {
                this.log.info("Realizando o upload do backup.");
                this.storageService.uploadBackupFile(backup, tenant, ambiente, nomeArquivo, TipoArquivoArmazenado.Backup);
                this.log.info("Upload do backup executado com sucesso.");
                this.validacoesAposBackup(sessao, preferencia.isConsiderarTamanhoMenorErro(), ignoraUltimoTamanhoBackup, processBuilder, tamanhoBackup, true, false);
            } else {
                this.log.warn("N\u00e3o foi realizado o upload do backup pois o arquivo gerado estava incorreto.");
            }
        }
        catch (Exception ex) {
            LogSistema.escreveStackTrace((String)"N\u00e3o foi poss\u00edvel realizar o backup da base", (Throwable)ex);
            this.log.error("N\u00e3o foi poss\u00edvel realizar o backup da base {}", (Object)tenant, (Object)ex);
            throw new UnicoMensagemUsuarioException("WWW675", "N\u00e3o foi poss\u00edvel realizar o backup da base", (Throwable)ex);
        }
        finally {
            if (backup != null && backup.exists() && !backup.delete()) {
                backup.deleteOnExit();
            }
        }
        return sucesso;
    }

    private void validacoesAposBackup(Sessao sessao, boolean considerarTamanhoMenorErroBackup, boolean ignoraUltimoTamanhoBackup, ProcessBuilderWrapper processBuilder, Long tamanhoBackup, boolean sucesso, boolean verificarArquivos) throws UnicoMensagemUsuarioException {
        String mensagem;
        TipoNotificacaoSimples tipoNotificacao;
        boolean isTamanhoMenor = false;
        if (sucesso) {
            boolean erroTamanhoMenor;
            tipoNotificacao = TipoNotificacaoSimples.SUCCESS;
            mensagem = "C\u00f3pia de seguran\u00e7a gerada com sucesso " + (verificarArquivos ? "no caminho " + this.DIRETORIO_BACKUP : "");
            Long tamanhoUltimoBackup = ControleRN.getInstance().getTamanhoUltimoBackup(1);
            Long tamanhoBackupComparacao = tamanhoBackup + (tamanhoBackup > 0L ? tamanhoBackup / 10L : 0L);
            if (tamanhoBackupComparacao.compareTo(tamanhoUltimoBackup) < 0) {
                mensagem = "A c\u00f3pia de seguran\u00e7a foi gerada, por\u00e9m o tamanho do backup \u00e9 inferior ao \u00faltimo backup. Verifique se o backup foi gerado " + (verificarArquivos ? "corretamente no caminho " + this.DIRETORIO_BACKUP : "");
                tipoNotificacao = TipoNotificacaoSimples.WARNING;
                isTamanhoMenor = true;
            }
            boolean bl = erroTamanhoMenor = isTamanhoMenor && considerarTamanhoMenorErroBackup;
            if (!erroTamanhoMenor || ignoraUltimoTamanhoBackup) {
                this.gravaDataUltimoBackup(sessao, tamanhoBackup);
            }
            this.gravaEventoSistema(sessao, mensagem, erroTamanhoMenor);
        } else {
            tipoNotificacao = TipoNotificacaoSimples.ERROR;
            mensagem = "Falha ao executar o backup no caminho " + this.DIRETORIO_BACKUP + ". Detalhes: " + processBuilder.getErrors();
            this.gravaEventoSistema(sessao, mensagem, true);
        }
        this.log.info(mensagem);
        this.notificationService.notityUsersAdministrator(tipoNotificacao, ContextoHolder.getTenant(), mensagem);
    }

    private String getNomeArquivo(String nomeBaseDados, boolean incluirDataHoraBkp, boolean incluirRazaoSocialBkp) {
        Filial filial;
        LocalDateTime dataHoraBkp = DataHoraFactory.getDataHora();
        String nomeArquivo = nomeBaseDados;
        if (incluirDataHoraBkp) {
            nomeArquivo = nomeArquivo + "_" + StringUtil.formataDataHora((Temporal)dataHoraBkp, (String)"yyyyMMddHHmm");
        }
        if (incluirRazaoSocialBkp && (filial = FilialRN.getInstance().buscaMatriz()) != null) {
            nomeArquivo = nomeArquivo + "_" + StringUtil.removerAcentosSubstituiCaracteresEspeciais((String)filial.getRazaoSocialCompleta()).toUpperCase().replace(" ", "_");
        }
        return nomeArquivo;
    }

    private void gravaDataUltimoBackup(Sessao sessao, Long tamanhoBackup) throws UnicoMensagemUsuarioException {
        LocalDateTime dataHora = DataHoraFactory.getDataHora();
        BackupAgendadoRN.getInstance().atualizaDataUltimoBackup(sessao, dataHora);
        ControleRN.getInstance().atualizaDataUltimoBackup(sessao, tamanhoBackup, dataHora);
    }

    private void gravaEventoSistema(Sessao sessao, String msg, boolean avisar) throws UnicoMensagemUsuarioException {
        if (avisar) {
            EventoSistema evento = new EventoSistema();
            evento.setCategoria(CategoriaEventoSistema.BACKUP);
            evento.setAvisar(false);
            evento.setMillis(Long.valueOf(System.currentTimeMillis()));
            evento.setDescricao(msg);
            EventoSistemaRN.getInstance().enviarEmailAvisoBackup(sessao, evento);
        }
        EventoSistemaRN.getInstance().gravaEvento(sessao, avisar, CategoriaEventoSistema.BACKUP, msg);
    }

    public void verificarSeDeveExcluirArquivos(Sessao sessao) {
        this.log.info("Verificar se deve excluir arquivos de backup");
        String tenant = ContextoHolder.getTenant();
        PreferenciasBackupWrapper preferencia = this.carregarPreferencias(sessao);
        int diasParaManterBkp = preferencia.diasBackup;
        this.log.info("Dias para marter os backups: " + diasParaManterBkp);
        if (diasParaManterBkp > 0) {
            try {
                List backups = FileUtil.buscarListaBackup((String)this.DIRETORIO_BACKUP, (String)tenant);
                this.log.info("N\u00famero de backups na pasta: " + backups.size());
                for (Path backup : backups) {
                    this.log.info("Verificando o arquivo de backup " + backup.getFileName());
                    BasicFileAttributes attr = Files.readAttributes(backup, BasicFileAttributes.class, new LinkOption[0]);
                    LocalDate dataCriacaoArquivo = DataHoraFactory.long2LocalDate((long)attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                    this.log.info("Data do arquivo de backup " + backup.getFileName() + ": " + Util.formataDataHora((Temporal)dataCriacaoArquivo, (String)"dd/MM/yyyy"));
                    int dias = (int)ChronoUnit.DAYS.between(dataCriacaoArquivo, DataHoraFactory.getData());
                    this.log.info("Idade em dias do arquivo de backup " + backup.getFileName() + ": " + dias);
                    if (dias <= diasParaManterBkp) continue;
                    this.log.info("Excluindo o backup " + backup.getFileName());
                    Files.delete(backup);
                }
            }
            catch (IOException ex) {
                throw new UnicoException("COM236547", "N\u00e3o foi poss\u00edvel excluir os arquivos de backup mais antigos que " + diasParaManterBkp + " dias no diret\u00f3rio " + this.DIRETORIO_BACKUP, (Throwable)ex);
            }
        }
    }

    public PreferenciasBackupWrapper carregarPreferencias(Sessao sessao) {
        Controle controle = ControleRN.getInstance().buscar();
        PreferenciasBackupWrapper pbw = new PreferenciasBackupWrapper();
        if (controle.getDiasBackup() > 0) {
            pbw.setDiasBackup(controle.getDiasBackup());
            pbw.setDataHora(controle.isDataHora());
            pbw.setRazaoSocial(controle.isRazaoSocial());
            pbw.setExclusaoAuditoria(controle.isExclusaoAuditoria());
            pbw.setConsiderarTamanhoMenorErro(controle.isConsiderarTamanhoMenorErro());
        } else {
            pbw.setDiasBackup(PropriedadeRN.getInstance().getPropriedadeInt(sessao.getFilial(), 674));
            pbw.setDataHora(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 670));
            pbw.setRazaoSocial(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 672));
            pbw.setExclusaoAuditoria(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 675));
            pbw.setConsiderarTamanhoMenorErro(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 692));
        }
        return pbw;
    }

    private void vacuum() {
        Statement ps = null;
        try {
            this.connectionHandler.createConnection(false);
            Connection conn = this.connectionHandler.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement("VACUUM ANALYSE");
            ps.execute();
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            LogSistema.escreveStackTrace((String)"Backup VACUUM", (Throwable)e);
            this.log.error("N\u00e3o foi poss\u00edvel ralizar o VACUUM");
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    LogSistema.escreveStackTrace((String)"Erro ao fechar a conex\u00e3o", (Throwable)e);
                    this.log.error("Erro ao fechar a conex\u00e3o");
                }
            }
        }
    }
}

