/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.uniplusweb.core.util.TipoCache;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.stereotype.Service;

@Service
public class CacheService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String CACHE_SERVER = "cacheService";
    private final CacheManager cacheManager;

    @Autowired
    public CacheService(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public <T> Object get(T id) {
        try {
            Cache.ValueWrapper obj = null;
            Cache cache = this.getCache();
            if (cache != null) {
                obj = cache.get((Object)this.getKey(ContextoHolder.getTenant(), id));
            }
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> void put(T id, Object value) {
        try {
            Cache cache = this.getCache();
            if (cache != null) {
                cache.put((Object)this.getKey(ContextoHolder.getTenant(), id), value);
            }
        }
        catch (Exception e) {
            this.log.error("Erro no m\u00e9todo put", (Throwable)e);
        }
    }

    public void clear() {
        this.remove(null);
    }

    public void removerPorPrefixo(String prefixo) {
        this.remove(prefixo);
    }

    private void remove(String prefixo) {
        Cache cache = this.getCache();
        if (cache != null) {
            List cachesNaoRemoviveis = Stream.of(TipoCache.values()).filter(t -> !t.isClearDefault()).map(t -> this.getKey(ContextoHolder.getTenant(), (Object)t.getId())).collect(Collectors.toList());
            CaffeineCache caffeineCache = (CaffeineCache)this.getCache();
            com.github.benmanes.caffeine.cache.Cache nativeCache = caffeineCache.getNativeCache();
            Set keySet = nativeCache.asMap().keySet();
            for (Object idCache : keySet) {
                if (cachesNaoRemoviveis.contains(idCache.toString()) || prefixo != null && !idCache.toString().startsWith(prefixo)) continue;
                cache.evict((Object)idCache.toString());
            }
        }
    }

    public void removerCache(String idCache) {
        Cache cache = this.getCache();
        if (cache != null) {
            cache.evict((Object)this.getKey(ContextoHolder.getTenant(), (Object)idCache));
        }
    }

    private Cache getCache() {
        return this.cacheManager.getCache(CACHE_SERVER);
    }

    private <T> String getKey(String tenant, T id) {
        return tenant + "_" + id;
    }
}

