/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.uniplusweb.core.coreinterfaces.MenuMapping;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.spring.SpringClassScanner;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.menus.MenuObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.stereotype.Service;

@Service
@SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public class MenuService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public List<MenuObject> menu;

    public MenuService() {
        if (this.menu == null) {
            this.menu = this.loadMenu();
        }
    }

    private List<MenuObject> loadMenu() {
        return this.mountTree(this.loadMenuMapping(SpringClassScanner.findMenuMapping((String)"br.intelidata.uniplusweb.web.rest.*")), this.loadSubMenuMapping(SpringClassScanner.findSubMenuMapping((String[])new String[]{"br.intelidata.uniplusweb.web.rest.*", "br.intelidata.uniplusweb.core.session"})));
    }

    private List<MenuObject> mountTree(List<MenuObject> menu, List<MenuObject> subMenu) {
        if (subMenu.isEmpty()) {
            return menu;
        }
        subMenu.forEach(subMenuSingle -> {
            Optional<MenuObject> filterPai = menu.stream().filter(menuSingle -> menuSingle.getNome().toLowerCase().equals(subMenuSingle.getSubMenuMapping().MENU().toLowerCase())).findFirst();
            this.parseItemMenu(filterPai, subMenuSingle);
        });
        subMenu.forEach(subMenuSingle -> {
            Optional<MenuObject> filterPai = subMenu.stream().filter(subMenuMapping -> subMenuMapping.getNome().toLowerCase().equals(subMenuSingle.getSubMenuMapping().MENU().toLowerCase())).findFirst();
            this.parseItemMenu(filterPai, subMenuSingle);
        });
        return menu;
    }

    private void parseItemMenu(Optional<MenuObject> filterPai, MenuObject subMenuSingle) {
        if (filterPai.isPresent()) {
            MenuObject pai = filterPai.get();
            if (ListMapUtil.listNullOrEmpty((List)pai.getFilhos())) {
                ArrayList<MenuObject> temp = new ArrayList<MenuObject>();
                temp.add(subMenuSingle);
                pai.setFilhos(temp);
            } else {
                pai.getFilhos().add(subMenuSingle);
            }
        }
    }

    private List<MenuObject> loadMenuMapping(Set<BeanDefinition> listControllersDefinition) {
        return listControllersDefinition.stream().map(restControl -> {
            MenuObject temp = new MenuObject();
            try {
                Class<?> beanDefinitionConsumer = Class.forName(restControl.getBeanClassName());
                temp.setNome(beanDefinitionConsumer.getSimpleName());
                MenuMapping menuMapping = beanDefinitionConsumer.getAnnotation(MenuMapping.class);
                temp.setMenuMapping(menuMapping);
                temp.setDefine(0);
                temp.setEndpoint(menuMapping.ENDPOINT());
                temp.setTitulo(menuMapping.NOME());
                temp.setIcone(menuMapping.ICONE());
                temp.setCorTexto(menuMapping.COR_TEXTO());
                temp.setPeso(menuMapping.PESO());
                return temp;
            }
            catch (ClassNotFoundException e) {
                this.log.error("erro ao carregar menu", (Throwable)e);
                return temp;
            }
        }).collect(Collectors.toList());
    }

    private List<MenuObject> loadSubMenuMapping(Set<BeanDefinition> listControllersDefinition) {
        return listControllersDefinition.stream().map(control -> {
            MenuObject temp = new MenuObject();
            try {
                Class<?> tempObject = Class.forName(control.getBeanClassName());
                temp.setNome(tempObject.getSimpleName());
                SubMenuMapping subMenuMapping = tempObject.getAnnotation(SubMenuMapping.class);
                temp.setSubMenuMapping(tempObject.getAnnotation(SubMenuMapping.class));
                temp.setDefine(1);
                temp.setEndpoint(subMenuMapping.ROTA());
                temp.setTitulo(subMenuMapping.NOME());
                temp.setIcone(subMenuMapping.ICONE());
                temp.setCorTexto(subMenuMapping.COR_TEXTO());
                temp.setCustomAction(subMenuMapping.CUSTOM_ACTION());
                temp.setPeso(subMenuMapping.PESO());
                return temp;
            }
            catch (ClassNotFoundException e) {
                this.log.error("erro ao carregar sub menu", (Throwable)e);
                return temp;
            }
        }).collect(Collectors.toList());
    }
}

