/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.IFileStorage;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.modulo.notafiscal.nfse.NfseManagerWeb;
import br.intelidata.commons.modulo.notafiscal.nfse.RetornoImpressaoNfse;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class TrabalhoImpressaoNFSeComponent {
    public ResponseEntity<byte[]> imprimirDanfe(NotaFiscal notaFiscal, ArquivoFiscalWeb arquivoFiscal) throws UnicoMensagemUsuarioException {
        RetornoImpressaoNfse retornoImpressaoNfse = new NfseManagerWeb(SessaoUtil.getSessao(), null, (IFileStorage)arquivoFiscal).imprimirNFSe(notaFiscal.getId(), false);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("access-control-expose-headers", "content-disposition");
        responseHeaders.setContentType(MediaType.APPLICATION_PDF);
        responseHeaders.add("Content-Disposition", "attachment;filename=NFSe-".concat(notaFiscal.getNumeroNotaFiscal()) + ".pdf");
        responseHeaders.add("link", retornoImpressaoNfse.getLink());
        responseHeaders.add("Access-Control-Expose-Headers", "link");
        return new ResponseEntity((Object)retornoImpressaoNfse.getArquivo(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }
}

