/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.core.util.TipoCache;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.stereotype.Service;

@Service
public class ZoneIdService {
    private final CacheService cacheService;
    private final IConnectionHandler iConnectionHandler;

    public ZoneIdService(CacheService cacheService, IConnectionHandler iConnectionHandler) {
        this.cacheService = cacheService;
        this.iConnectionHandler = iConnectionHandler;
    }

    public ZoneId getZoneId() {
        SimpleValueWrapper valueCache;
        String timeZoneId;
        Long idFilial = SessaoUtil.getSessao().getIdFilial();
        ZoneId zoneId = ZoneOffset.systemDefault();
        if (NumberUtil.longNullOuZero((Long)idFilial)) {
            return zoneId;
        }
        boolean fecharConexao = false;
        if (!this.iConnectionHandler.isConnected()) {
            fecharConexao = true;
            this.iConnectionHandler.createConnection(true);
        }
        String string = timeZoneId = (valueCache = (SimpleValueWrapper)this.cacheService.get((Object)TipoCache.ID_TIME_ZONE_ID.getId().concat(idFilial.toString()))) != null ? (String)valueCache.get() : null;
        if (StringUtil.stringNullOrEmpty((String)timeZoneId)) {
            timeZoneId = FilialRN.getInstance().getTimeZoneId(idFilial);
            this.cacheService.put((Object)TipoCache.ID_TIME_ZONE_ID.getId().concat(idFilial.toString()), (Object)timeZoneId);
        }
        if (!StringUtil.stringNullOrEmpty((String)timeZoneId)) {
            zoneId = TimeZone.getTimeZone(timeZoneId).toZoneId();
        }
        if (fecharConexao) {
            this.iConnectionHandler.releaseConnection();
        }
        return zoneId;
    }
}

