/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.session;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sql.ControleConexoes;
import br.intelidata.commons.domain.pojo.b2c.SessaoWebDTO;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoAcesso;
import br.intelidata.commons.domain.regranegocio.b2c.SessaoWebRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import unipaf.servidor.nfce.StatusPdvFilialHelper;

@RestController
@RequestMapping(value={"/api/sessao"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Usu\u00e1rios conectados", ROTA="/session-components/sessao", PROGRAMA=541, ICONE="icon-usuario")
public class SessionController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NotificationService notificationService;
    private final IConnectionHandler connectionHandler;

    @Autowired
    public SessionController(NotificationService notificationService, IConnectionHandler connectionHandler) {
        this.notificationService = notificationService;
        this.connectionHandler = connectionHandler;
    }

    @RequestMapping(value={"/find-all"})
    @DBAutoCommit
    public List<SessaoWebDTO> buscaSessoes() {
        List sessoesWeb = SessaoWebRN.getInstance().buscarSessoes();
        sessoesWeb.addAll(ControleConexoes.getInstance().getListaUsuarioAtivosRetaguarda(this.connectionHandler.getConnection()).stream().map(linha -> {
            String pid = "";
            if (linha.get("pid") != null) {
                pid = linha.get("pid").toString();
            }
            LocalDateTime login = (LocalDateTime)linha.get("inicio");
            String usuario = linha.get("usuario") != null ? (String)linha.get("usuario") : (String)linha.get("endereco");
            usuario = usuario + " (Desktop)";
            return new SessaoWebDTO(pid, usuario, login, false, null, true, false);
        }).collect(Collectors.toList()));
        sessoesWeb.addAll(StatusPdvFilialHelper.getPdvsConectados().stream().map(locacaoPDV -> {
            String pdv = "PDV " + locacaoPDV.getIdentificador();
            if (!StringUtil.stringNullOrEmpty((String)locacaoPDV.getIp())) {
                pdv = pdv + " (" + locacaoPDV.getIp() + ")";
            }
            return new SessaoWebDTO(locacaoPDV.getIp(), pdv, locacaoPDV.getInicio(), false, null, true, false);
        }).collect(Collectors.toList()));
        sessoesWeb.removeIf(sessaoWeb -> {
            Integer tipoAcessoID = (Integer)UsuarioRN.getInstance().buscarValorPorID(sessaoWeb.getIdUsuario(), "tipoacesso");
            TipoAcesso tipoAcesso = (TipoAcesso)EnumUtils.getPorId(TipoAcesso.class, (Object)tipoAcessoID, (AbstractEnum)TipoAcesso.USUARIO);
            return TipoAcesso.TECNICO.equals((Object)tipoAcesso);
        });
        return sessoesWeb;
    }

    @RequestMapping(value={"/delete/{sessionId}"}, method={RequestMethod.POST})
    @DBAutoCommit
    public boolean apagaSessaoWeb(@PathVariable String sessionId) {
        SessaoWebDTO sessaoWebDTO = SessaoWebRN.getInstance().buscaSessaoWebDTO(sessionId);
        SessaoWebRN.getInstance().apagaSessaoWeb(sessionId);
        boolean demonstracao = LicencaManager.getInstance().isDemonstracao();
        int usuariosPDV = StatusPdvFilialHelper.getTotalPdvsConectados();
        int usuariosConectados = SessaoWebRN.getInstance().buscaNumeroSessoes();
        int totalUsuarios = usuariosConectados + usuariosPDV;
        boolean numeroUsuariosMaiorQueContratado = demonstracao && totalUsuarios > 2 || !demonstracao && totalUsuarios > LicencaManager.getInstance().getNumeroUsuariosSistema();
        String mensagem = "Voc\u00ea foi desconectado por " + SessaoUtil.getSessao().getUsuario().getNome() + ". Considere aumentar o n\u00famero de usu\u00e1rios contratados.";
        this.notificationService.notifyTokenNow(ContextoHolder.getTenant(), sessionId, NotificationType.ENCERRAR_SESSAO, (Object)mensagem);
        this.log.info("O usu\u00e1rio " + SessaoUtil.getSessao().getUsuario().getNome() + " derrubou a sess\u00e3o " + sessionId + (sessionId != null ? " do usu\u00e1rio " + sessaoWebDTO.getNome() : ""));
        return !numeroUsuariosMaiorQueContratado;
    }

    @RequestMapping(value={"/contem-mais-sessoes/{sessionId}"})
    @DBAutoCommit
    public boolean isContemMaisSessaoPorJti(@PathVariable String sessionId) {
        SessaoWebDTO sessaoWebDTO = SessaoWebRN.getInstance().buscaSessaoWebDTO(sessionId);
        List sessoesPorUsuario = SessaoWebRN.getInstance().buscarSessoesPorIdUsuario(sessaoWebDTO.getIdUsuario());
        sessoesPorUsuario.removeIf(s -> s.getJti().equalsIgnoreCase(sessionId) || s.isUniplusMobile());
        return !sessoesPorUsuario.isEmpty();
    }

    @RequestMapping(value={"/derrubar-outras-sessoes-do-usuario/{sessionId}"})
    @DBAutoCommit
    public void apagarOutrasSessoesDoUsuario(@PathVariable String sessionId) {
        SessaoWebDTO sessaoWebDTO = SessaoWebRN.getInstance().buscaSessaoWebDTO(sessionId);
        List sessoesPorUsuario = SessaoWebRN.getInstance().buscarSessoesPorIdUsuario(sessaoWebDTO.getIdUsuario());
        sessoesPorUsuario.removeIf(s -> s.getJti().equalsIgnoreCase(sessionId) || s.isUniplusMobile());
        for (SessaoWebDTO sessao : sessoesPorUsuario) {
            SessaoWebRN.getInstance().apagaSessaoWeb(sessao.getJti());
        }
        for (SessaoWebDTO sessao : sessoesPorUsuario) {
            String mensagem = "Voc\u00ea foi desconectado por " + SessaoUtil.getSessao().getUsuario().getNome() + ". Considere aumentar o n\u00famero de usu\u00e1rios contratados.";
            this.notificationService.notifyTokenNow(ContextoHolder.getTenant(), sessao.getJti(), NotificationType.ENCERRAR_SESSAO, (Object)mensagem);
        }
    }

    @RequestMapping(value={"/derrubar-sessoes-do-usuario-inativo/{idUsuario}"})
    @DBAutoCommit
    public void apagarOutrasSessoesPorIdUsuario(@PathVariable Long idUsuario) {
        List sessoesPorUsuario = SessaoWebRN.getInstance().buscarSessoesPorIdUsuario(idUsuario);
        for (SessaoWebDTO sessao : sessoesPorUsuario) {
            SessaoWebRN.getInstance().apagaSessaoWeb(sessao.getJti());
        }
        for (SessaoWebDTO sessao : sessoesPorUsuario) {
            String mensagem = "Voc\u00ea foi desconectado por " + SessaoUtil.getSessao().getUsuario().getNome() + ". Seu usu\u00e1rio foi inativado.";
            this.notificationService.notifyTokenNow(ContextoHolder.getTenant(), sessao.getJti(), NotificationType.ENCERRAR_SESSAO, (Object)mensagem);
        }
    }
}

