/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.sgbd;

import br.intelidata.commons.bridge.ConnectionHolder;
import br.intelidata.commons.bridge.IBridgeConnectionScheduler;
import br.intelidata.commons.bridge.RuntimeDataSource;
import br.intelidata.core.sgdb.IConnectionHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Primary
@Component
@Profile(value={"dev", "prod", "aws"})
@SuppressFBWarnings(value={"ODR_OPEN_DATABASE_RESOURCE", "OBL_UNSATISFIED_OBLIGATION"}, justification="O close ocorre em classes acima.")
public class ConnectionHandler
implements IConnectionHandler,
IBridgeConnectionScheduler {
    protected final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    @Autowired
    private RuntimeDataSource multitenantDS;

    public void createConnection(boolean readOnly) {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holder.get();
        if (connectionHolder == null) {
            try {
                Connection connection = this.multitenantDS.getDataSource().getConnection();
                connectionHolder = new ConnectionHolder(connection, readOnly);
                ConnectionHolder.holder.set(connectionHolder);
                this.log.debug("CREATE CONNECTION executado");
            }
            catch (SQLException e) {
                this.log.error("N\u00e3o foi poss\u00edvel adquirir uma conex\u00e3o ao banco", (Throwable)e);
                throw new RuntimeException("N\u00e3o foi poss\u00edvel adquirir uma conex\u00e3o ao banco", e);
            }
        } else {
            this.log.error("Thread atual j\u00e1 tem uma conex\u00e3o ao banco");
            throw new RuntimeException("Thread atual j\u00e1 tem uma conex\u00e3o ao banco");
        }
    }

    public ConnectionHolder getConnectionHolder() {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holder.get();
        if (connectionHolder == null) {
            this.log.error("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery");
            throw new RuntimeException("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery");
        }
        return connectionHolder;
    }

    public Connection getConnection() {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holder.get();
        if (connectionHolder == null) {
            this.log.error("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery");
            throw new RuntimeException("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery");
        }
        return connectionHolder.getCurrentConnection();
    }

    public void releaseConnection() {
        Connection connection = this.getConnection();
        try {
            connection.close();
            int openStatements = ConnectionHolder.getConnectionHolder().getOpenStatements();
            ConnectionHolder.holder.remove();
            this.log.debug("RELEASE CONNECTION executado");
            if (openStatements != 0) {
                this.log.error("Transa\u00e7\u00e3o sem close detectada - revise o c\u00f3digo fonte");
                throw new RuntimeException("Transa\u00e7\u00e3o sem close detectada - revise o c\u00f3digo fonte");
            }
        }
        catch (SQLException e) {
            this.log.error("N\u00e3o foi poss\u00edvel liberar uma transa\u00e7\u00e3o");
            throw new RuntimeException("N\u00e3o foi poss\u00edvel liberar uma transa\u00e7\u00e3o", e);
        }
    }

    public void beginTransaction() {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            this.log.debug("BEGIN TRANSACTION executado");
        }
        catch (SQLException e) {
            this.log.error("N\u00e3o foi poss\u00edvel iniciar uma transa\u00e7\u00e3o");
            throw new RuntimeException("N\u00e3o foi poss\u00edvel iniciar uma transa\u00e7\u00e3o", e);
        }
    }

    public void commit() {
        Connection connection = this.getConnection();
        try {
            connection.commit();
            connection.setAutoCommit(true);
            this.log.debug("COMMIT executado");
        }
        catch (SQLException e) {
            this.log.error("N\u00e3o foi poss\u00edvel concluir uma transa\u00e7\u00e3o");
            throw new RuntimeException("N\u00e3o foi poss\u00edvel concluir uma transa\u00e7\u00e3o", e);
        }
    }

    public void commitAndContinue() {
        this.commit();
        this.beginTransaction();
    }

    public void rollback() {
        Connection connection = this.getConnection();
        try {
            connection.rollback();
            connection.setAutoCommit(true);
            this.log.debug("ROLLBACK executado");
        }
        catch (SQLException e) {
            this.log.error("N\u00e3o foi poss\u00edvel fazer desfazer na transa\u00e7\u00e3o");
            throw new RuntimeException("N\u00e3o foi poss\u00edvel fazer desfazer na transa\u00e7\u00e3o", e);
        }
    }

    public boolean isConnected() {
        return ConnectionHolder.holder.get() != null;
    }

    public boolean isAutoCommit() {
        if (this.isConnected()) {
            Connection connection = this.getConnection();
            try {
                return connection.getAutoCommit();
            }
            catch (SQLException e) {
                this.log.error("N\u00e3o foi poss\u00edvel verificar o autocommit");
                throw new RuntimeException("N\u00e3o foi poss\u00edvel verificar o autocommit", e);
            }
        }
        return false;
    }
}

