/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.sgbd;

import br.intelidata.commons.bridge.ConnectionHolder;
import br.intelidata.core.sgdb.IConnectionHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"test"})
@Component(value="connectionHandler")
public class ConnectionHandlerTest
implements IConnectionHandler {
    @Autowired
    DataSource dataSource;

    public void createConnection(boolean readOnly) {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holder.get();
        if (connectionHolder == null) {
            try {
                Connection connection = this.dataSource.getConnection();
                connectionHolder = new ConnectionHolder(connection, readOnly);
                ConnectionHolder.holder.set(connectionHolder);
            }
            catch (SQLException e) {
                throw new RuntimeException("N\u00e3o foi poss\u00edvel adquirir uma conex\u00e3o ao banco");
            }
        } else {
            throw new RuntimeException("Thread atual j\u00e1 tem uma conex\u00e3o ao banco");
        }
    }

    public ConnectionHolder getConnectionHolder() {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holder.get();
        if (connectionHolder == null) {
            throw new RuntimeException("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery");
        }
        return connectionHolder;
    }

    public Connection getConnection() {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holder.get();
        if (connectionHolder == null) {
            throw new RuntimeException("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery");
        }
        return connectionHolder.getCurrentConnection();
    }

    public void releaseConnection() {
        Connection connection = this.getConnection();
        try {
            connection.close();
            int openStatements = ConnectionHolder.getConnectionHolder().getOpenStatements();
            ConnectionHolder.holder.remove();
            if (openStatements != 0) {
                throw new RuntimeException("Transa\u00e7\u00e3o sem close detectada - revise o c\u00f3digo fonte");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel liberar uma transa\u00e7\u00e3o", e);
        }
    }

    @SuppressFBWarnings(value={"ODR_OPEN_DATABASE_RESOURCE", "OBL_UNSATISFIED_OBLIGATION"})
    public void beginTransaction() {
        Connection connection = this.getConnection();
        try {
            connection.prepareStatement("begin transaction;").executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel iniciar uma transa\u00e7\u00e3o", e);
        }
    }

    @SuppressFBWarnings(value={"ODR_OPEN_DATABASE_RESOURCE", "OBL_UNSATISFIED_OBLIGATION"})
    public void commit() {
        Connection connection = this.getConnection();
        try {
            connection.prepareStatement("commit;").executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel concluir uma transa\u00e7\u00e3o", e);
        }
    }

    public void commitAndContinue() {
        this.commit();
        this.beginTransaction();
    }

    @SuppressFBWarnings(value={"ODR_OPEN_DATABASE_RESOURCE", "OBL_UNSATISFIED_OBLIGATION"})
    public void rollback() {
        Connection connection = this.getConnection();
        try {
            connection.prepareStatement("rollback;").executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel fazer desfazer na transa\u00e7\u00e3o", e);
        }
    }

    public boolean isConnected() {
        return ConnectionHolder.holder.get() != null;
    }

    public boolean isAutoCommit() {
        return false;
    }
}

