/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.Cache;

import br.intelidata.uniplusweb.core.spring.Cache.MapDbCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.lang.Nullable;

@SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER", "NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Matido por compatibilidade e funcionamento.")
public class MapDbCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(MapDbCacheManager.class);
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap(16);
    private boolean dynamic = true;
    private DB db;
    private int duracaoEmSegundos;

    public MapDbCacheManager(int duracaoEmSegundos) throws IOException {
        Path arquivo = Paths.get("mapdb.cache", new String[0]);
        Files.deleteIfExists(arquivo);
        log.info("Arquivo de cache: {}", (Object)arquivo);
        this.db = DBMaker.fileDB((File)arquivo.toFile()).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().cleanerHackEnable().make();
        this.duracaoEmSegundos = duracaoEmSegundos;
    }

    public MapDbCacheManager(int duracaoEmSegundos, String ... cacheNames) throws IOException {
        this(duracaoEmSegundos);
        this.setCacheNames(Arrays.asList(cacheNames));
    }

    private void setCacheNames(@Nullable Collection<String> cacheNames) {
        if (cacheNames != null) {
            for (String name : cacheNames) {
                this.cacheMap.put(name, this.createMapDbCache(name));
            }
            this.dynamic = false;
        } else {
            this.dynamic = true;
        }
    }

    private Cache createMapDbCache(String name) {
        HTreeMap map = this.db.hashMap(name).keySerializer((Serializer)Serializer.STRING).create();
        return new MapDbCache(name, map, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(@NotNull String name) {
        Cache cache = (Cache)this.cacheMap.get(name);
        if (cache == null && this.dynamic) {
            ConcurrentMap var3 = this.cacheMap;
            ConcurrentMap concurrentMap = this.cacheMap;
            synchronized (concurrentMap) {
                cache = (Cache)this.cacheMap.get(name);
                if (cache == null) {
                    cache = this.createMapDbCache(name);
                    this.cacheMap.put(name, cache);
                }
            }
        }
        return cache;
    }

    @Nullable
    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    public void compact() {
        this.db.getStore().compact();
    }
}

