/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring;

import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.uniplusweb.core.spring.JSR310LocalDateTimeDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;

public class JSR310LocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    private static final String FORMATTER_WITH_26_CHAR = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    private static final String FORMATTER_WITH_22_CHAR = "yyyy-MM-dd'T'HH:mm:ssz";
    private static final String FORMATTER_WITH_21_CHAR = "yyyy-MM-dd'T'HH:mm:sz";
    public static final JSR310LocalDateTimeDeserializer INSTANCE = new JSR310LocalDateTimeDeserializer();
    private static final DateTimeFormatter ISO_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    private JSR310LocalDateTimeDeserializer() {
    }

    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[parser.getCurrentToken().ordinal()]) {
            case 1: {
                if (parser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                int year = parser.getIntValue();
                parser.nextToken();
                int month = parser.getIntValue();
                parser.nextToken();
                int day = parser.getIntValue();
                parser.nextToken();
                int hour = parser.getIntValue();
                parser.nextToken();
                int minute = parser.getIntValue();
                parser.nextToken();
                int second = parser.getIntValue();
                parser.nextToken();
                int milisecond = parser.getIntValue();
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    throw context.wrongTokenException(parser, JsonToken.END_ARRAY, "Expected array to end.");
                }
                return DataHoraFactory.of((int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second, (int)milisecond);
            }
            case 2: {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                try {
                    if (string.contains("T")) {
                        return LocalDateTime.parse(string, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                    }
                    return LocalDateTime.parse(string, ISO_FORMATTER);
                }
                catch (DateTimeParseException ex) {
                    try {
                        if (parser.getText().length() == 19) {
                            return LocalDateTime.parse(parser.getText(), DateTimeFormatter.ofPattern(FORMATTER_WITH_21_CHAR));
                        }
                        if (parser.getText().length() == 20) {
                            return LocalDateTime.parse(parser.getText(), DateTimeFormatter.ofPattern(FORMATTER_WITH_22_CHAR));
                        }
                        return LocalDateTime.parse(parser.getText(), DateTimeFormatter.ofPattern(FORMATTER_WITH_26_CHAR));
                    }
                    catch (DateTimeParseException ex1) {
                        return LocalDateTime.parse(parser.getText().substring(0, 19), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
                    }
                }
            }
        }
        throw context.wrongTokenException(parser, JsonToken.START_ARRAY, "Expected array or string.");
    }
}

